/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtatoms.h
 \brief iq̌qzuf[^̃NX
*/

#ifndef __DTATOMS_H_INCLUDED
#define __DTATOMS_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "position.h"
#include "imatrix.h"


class DTElement
{
public:
  int    number; // qԍ
  QString name;   // f
  double zo;     // dq
  double zn;     // jdא
  double mass;   // q

  QString file_pseudo;   // [|eVt@C
  QString file_charge;   // dqt@C

  DTElement( void ){}
  DTElement( const QString& name );
  DTElement( const double zo, const double zn );

  bool operator == ( const DTElement& element ) const {
    return number == element.number;
  }
  bool operator != ( const DTElement& element ) const {
    return number != element.number;
  }
};


class DTAtom
{
public:
  DTElement   element; // f
  Coordinates coords;  // ZW(A,B,C)
  int         motion;
  Position    velocity;
 
  struct {
    bool    flag;   // ̌qRs[ǂ
    int     index;  // ̌q̃IWĩCfbNX
    IMatrix matrix; // ̌qRs[Ώ̑
    IMatrix matrix_inv; // ̌qRs[Ώ̑̋ts
  } copy;

  struct {
    bool   flag;   // ̌q̓_ƏdȂ邩
  } duplicate;

  struct {
    bool   flag;   // ̌qΏ̑Ɋւĕs_ǂ
    vector<IMatrix> vmatrix; // sȑΏ̑̃Xg
    IMatrix matrix_const; // Cӂ̃xNgΏ̑sɐs
  } special;

public:
  DTAtom( void ){}
  DTAtom( const DTElement& element,
	  const Coordinates& coords, const int motion=1 );

  const QString& getElement( void ) const ;
  const int&    getNumber( void ) const ;
  const Coordinates& getCoordinates( void ) const;

  void setAsOriginal( int index );
  void setAsCopy( int index, const IMatrix& matrix );
  int getIndex( void ) const;
  const IMatrix& getMatrix( void ) const;
  const IMatrix& getMatrixInv( void ) const;
  const IMatrix& getConstraintMatrix( void ) const;

  void setAsDuplicate( void );
  void setAsSpecial( const IMatrix& matrix );

  bool isCopy( void ) const;
  bool isDuplicate( void ) const;
  bool isSpecial( void ) const;

  bool translateCoordinates( const Coordinates& coords );
  bool changeCoordinates( const Coordinates& coords );
  bool changeElement( const DTElement& element );
  bool changeMotion( const int motion );
};

class DTCell;
class DTLattice;

class DTAtoms
{
  DTCell* cell;
public:
  enum CellAlignment {
    ANY, SIMPLE, FACE_CENTERED, BODY_CENTERED, BASE_CENTERED, DIAMOND
  };
  int alignment;

public:
  vector<DTAtom> vatom;    // qQ
  vector<int>    viatom;   // IqCfbNXXg
  int            iatom;    // IqCfbNX
  vector<int>    vselected;   // IqCfbNXXg
  vector<Coordinates> vcoords_selected; // Iq̌̍W
  Coordinates          coords_selected; // Ō̑Iq̈ړ̍W

  vector<DTElement> velement;
  DTElement         velement_value_shown;
  int               velement_index_shown;
  const DTElement* findElement( const QString& name ) const;
  const DTElement* findElement( const int     number ) const;
  int findPPID( const QString& name ) const;
  int findPPID( const int     number ) const;

  void change_shown( void );
  void update_shown( void );
  int  size_shown( void );

  void addElement( void );
  void delElement( void );
  
  int getDragMode( void ) const {
    return (int)vcoords_selected.size();
  }
  const Coordinates& getDragCoordinate( const int i ) const {
    return i==(int)vcoords_selected.size() ? coords_selected : vcoords_selected[i];
  }

public:
  DTAtoms( DTCell& cell );

public:
  // z񏈗
  void clear( void );
  bool empty( void ) const { return vatom.empty(); }
  int  size( void ) const { return vatom.size(); }
  void push_back( const DTAtom& atom ){ vatom.push_back(atom); }

  DTAtom& operator [] ( const int i ) { return vatom[i]; }
  const DTAtom& operator [] ( const int i ) const { return vatom[i]; }
  DTAtom& front( void ) { return vatom.front(); }
  DTAtom& back ( void ) { return vatom.back();  }

  void update( void );

public:
  bool load( DTLattice& lattice, const QString& fname );
  bool loadXYZ( const QString& fname );
  bool loadPDB( const QString& fname );
  bool loadCIF( DTLattice& lattice, const QString& fname );
  bool save( const QString& fname );
  bool saveXYZ( const QString& fname );

  // QT,GLɂ錴qI
  bool selectAtom( const int iatom );
  bool addselectAtom( const int iatom );
  bool selectAtoms( const vector<int> viatom );
  void unselectAtom( void );

  int getAtomSelected( void );
  const vector<int>& getAtomsSelected( void );
  bool isAtomSelected( void ) const;

public:
  // IqւQT,GLɂ鑀

  double bond_length;
  double bond_angle;
  double bond_dihedral;
  bool moveBond( void );
  bool updateBond( void );
  bool moveAtomCoords( const Position& t );
  bool moveAtomsCoords( const Position& t );
  bool changeAtomElement( const QString& name );
  bool changeAtomCoordinates( const Coordinates& coords );
  bool changeAtomCoordA( const double a );
  bool changeAtomCoordB( const double b );
  bool changeAtomCoordC( const double c );
  bool changeAtomMotion( const int motion );
  bool changeAtomVelocityX( const double vx );
  bool changeAtomVelocityY( const double vy );
  bool changeAtomVelocityZ( const double vz );
  bool removeAtoms( void );
  bool addAtoms( void );
};

#endif // __DTATOMS_H_INCLUDED
