/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtband.h
 \brief ohf[^̃NX
*/

#ifndef __DTBAND_H_INCLUDED
#define __DTBAND_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>

class DTBand
{
  struct datum {
    QString xlabel;
    double          x;
    vector<double> vy_orig, vy;
    void resize( const int size ){
      vy_orig.resize(size);
      vy.resize(size);
    }
    int size( void ) const { return vy_orig.size(); }
    void setValue( const int m, const double value ){
      vy[m] = vy_orig[m] = value;
    }
  };
public:
  vector<datum> data[2];
  int nspin;

  double kmin, kmax;
  double emin, emax;
  enum { DEFAULT_ORDER, ASCENDING_ORDER, NATUAL_ORDER } order;

public:
  DTBand( void );
  void clear( void );
  bool update( void );
  bool load( const QString& fname );
  bool isset( void ) const {
    return !data[0].empty();
  }
  bool isset1( void ) const {
    return !data[0].empty();
  }
  bool isset2( void ) const {
    return !data[1].empty();
  }

  int sizeX( void ) const {
    return data[0].size();
  }
  int sizeY( void ) const {
    return data[0].empty() ? 0 : data[0].front().size();
  }

  void swapBandByDefaultOrder( vector<datum>& data );
  void swapBandByAscendingOrder( vector<datum>& data );
  void swapBandByNatualOrder( vector<datum>& data );
};

#endif
