/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtcell.h
 \brief iq̒PʖEf[^̃NX
*/

#ifndef __DTCELL_H_INCLUDED
#define __DTCELL_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "position.h"

struct BrillouinPlane
{
  Position normal;
  double distance;
public:
  BrillouinPlane( void );
  BrillouinPlane( const Position& normal );
  double equation( const Position& position ) const;
};

struct BrillouinSegment
{
  QString   labelL;
  QString   labelPs;
  Position positions;
  QString   labelPe;
  Position positione;
  Position positionc;
  bool     cutted;
  int      npoint;
public:
  BrillouinSegment( void );
  BrillouinSegment( const QString& labelL,
		    const QString& labelPs,
		    const double xs, const double ys, const double zs,
		    const QString& labelPe,
		    const double xe, const double ye, const double ze );
  BrillouinSegment( const Position& positions,
		    const Position& positione );
  bool cut( const BrillouinPlane& plane );
  BrillouinSegment reverse( void ) const;

  static bool match( const BrillouinSegment& segment1, const BrillouinSegment& segment2 );
  static bool find( const vector<BrillouinSegment>& vs, const BrillouinSegment& s );
};


struct BrillouinFacet
{
  vector<BrillouinSegment> vsegment;
  BrillouinSegment          segmentc;
  bool                      cutted;
public:
  BrillouinFacet( const Position& position0,
		  const Position& position1,
		  const Position& position2,
		  const Position& position3 );
  BrillouinFacet( const vector<BrillouinSegment>& vs );
  bool cut( const BrillouinPlane& plane );
  void order( void );
};

// 擪vf̒ǉ폜\vector^
template <typename T> class vector_both : public vector<T>
{
public:
  vector_both<T>( void ){
  }
  vector_both<T>( const int size ) : vector<T>(size) {
  }
  void pop_front( void ){
    vector<T>::erase( vector<T>::begin() );
  }
  void push_front( const T& t ){
    vector<T> tmp;
    tmp.push_back(t);
    tmp.insert( tmp.end(), vector<T>::begin(), vector<T>::end() );
    vector<T>::clear();
    vector<T>::insert( vector<T>::end(), tmp.begin(), tmp.end() );
  }
};

// PʖĚ`Ɋւf[^ێNX
class DTCell
{
public:
  enum CellShape {
    CUBIC, TETRAGONAL_A, TETRAGONAL_B, TETRAGONAL_C,
    ORTHORHOMBIC, MONOCLINIC_A, MONOCLINIC_B, MONOCLINIC_C,
    TRIGONAL, TRICLINIC,
    HEXAGONAL_A, HEXAGONAL_B, HEXAGONAL_C };
  int shape;
  struct Bravais{
    QString shape;
    QString center;
    QString subtype;
  } bravais;
  struct KPathDefaults
  {
    QString shape, center, subtype;
    vector<BrillouinSegment> kpath;
  };
  vector<KPathDefaults> kpath_defaults;


  double   length;
  Position Ea, Eb, Ec;
  Position La, Lb, Lc, Lo;
  Position Ka, Kb, Kc;
  Position La_conv, Lb_conv, Lc_conv;
  Position Ka_conv, Kb_conv, Kc_conv;
  double   V;

  bool shape_changed;
  bool vectors_changed;
  bool alignment_changed;

  static double length_min, length_max;
  static double E_min, E_max;

  vector<BrillouinPlane>   vplane;
  vector<BrillouinFacet>   vfacet;
  vector<BrillouinSegment> vsymmL;
  vector_both<BrillouinSegment> vsymmLselected;
  bool                     vsymmLselected_loaded;

public:
  DTCell( void );

  void clear( void );

  Position getPosition( const Coordinates& q ) const;
  Position getPositionLocal( const Coordinates& q ) const;
  Coordinates getCoordinates( const Position& p ) const;
  Coordinates getCoordinatesLocal( const Position& p ) const;
  Coordinates getCoordinatesNormalized( const Position& p ) const;
  Coordinates getCoordinatesLocalNormalized( const Position& p ) const;

public:
  void update( void );

  bool selectBrillouin( const int segment );

private:
  void loadKPathDefaults( void );
  void updateShape( void );
  void updateVectors( void );

  void checkBravais( void );
  bool save( const QString& filename ) const;
  void constructBrillouin( void );

  void setupKPathDefault( void );
public:
  void defaultKPathSelect( void );
  void clearKPathSelect( void );
};

#endif // __DTCELL_H_INCLUDED
