/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#ifndef __DTCIF_H_INCLUDED
#define __DTCIF_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>

#include "spacegroup.h"
#include "position.h"
#include "imatrix.h"

struct DTCIF
{
  struct Cell
  {
    double length_a;
    double length_b;
    double length_c;
    double angle_alpha;
    double angle_beta;
    double angle_gamma;
  } cell;

  struct Atom
  {
    QString     element;
    Coordinates coords;

  public:
    Atom( const QString& element, const Coordinates& coords ){
      this->element = element;
      this->coords  = coords;
    }
    bool operator == ( const Atom& a ) const {
      const double eps=2.0e-4;

      if( this->element != a.element ) return false;

      const double dx = fabs(coords[0]-a.coords[0]);
      if( dx>eps && fabs(dx-1.0)>eps ) return false;

      const double dy = fabs(coords[1]-a.coords[1]);
      if( dy>eps && fabs(dy-1.0)>eps ) return false;

      const double dz = fabs(coords[2]-a.coords[2]);
      if( dz>eps && fabs(dz-1.0)>eps ) return false;

      return true;
    }
  };

  SpaceGroup      spacegroup;
  vector<IMatrix> voperation;
  vector<Atom>    vatom;
  Position unit_conv[3];
  Position baseP2C[3];
  Position baseC2P[3];

  Position unit_prim[3];
  bool has_inv;
  vector<IMatrix> voperation_prim;
  vector<Atom>    vatom_prim;

public:
  DTCIF( void ){}
  ~DTCIF( void ){}

  bool load( const QString& fname );

  void constructVectors( void );
  void constructAtoms( void );
  void constructSymmetrys( void );

  bool output( void ) const;

private:
  vector<QString> parseLine( const char* line );
};


#endif // __DTCIF_H_INCLUDED

