/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtdos.h
 \brief Ԗxf[^̃NX
*/

#ifndef __DTDOS_H_INCLUDED
#define __DTDOS_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>

class DTDos
{
  struct Data {
    QString title;
    vector<double> energy;
    vector<double> dos;
  };

public:
  vector<Data> vdata[2];

  double emin, emax;
  double dmin, dmax;

public:
  DTDos( void );
  void clear( void );
  bool update( void );
  bool load( const QString& fname );

  bool isset( void ) const {
    return !vdata[0].empty();
  }
  bool isset1( void ) const {
    return !vdata[0].empty();
  }
  bool isset2( void ) const {
    return !vdata[1].empty();
  }

  int sizeData1( void ) const {
    return vdata[0].size();
  }
  int sizeData2( void ) const {
    return vdata[1].size();
  }
  int sizeEnergy( void ) const {
    if( vdata[0].empty() ) return 0;
    return vdata[0][0].energy.size();
  }
  const QString& getTitle1( const int i ) const {
    return vdata[0][i].title;
  }
  const QString& getTitle2( const int i ) const {
    return vdata[1][i].title;
  }
};

#endif
