/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtfield.h
 \brief OtB[hf[^̃NX
*/

#ifndef __DTFIELD_H_INCLUDED
#define __DTFIELD_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "position.h"
#include "vector2d.h"
#include "vector3d.h"

class DTLattice;
class DTCell;

class DTField
{
public:
  int      Na, Nb, Nc;
  Position Lo, dLa, dLb, dLc;
  Position La, Lb, Lc;

  enum { FIELD_REAL=1, FIELD_COMPLEX=2 };
  struct Datum {
    QString          filename;
    int              fieldtype;
    vector3d<double> data1;
    vector3d<double> data2;
    Datum( void ){
    }
    ~Datum( void ){
      data1.clear();
      data2.clear();
    }
  };
  vector<Datum> vdata;
  int           idata;

  int getFieldType( void ) const {
    return (int)vdata[idata-1].fieldtype;
  }

  int getSize( void ) const {
    return vdata.size();
  }

  struct Multi {
    int mode; // 0:single, 1:multiple, 2:slater
    int istart;
    double min, max;

    vector3d<double> data;
    vector<Coordinates> vcoord;
    Coordinates coord_shown;
    int         index_shown;
    bool        coord_manual;

    void change_shown( void );
    void update_shown( void );
  } multi;

  bool nextfield( const bool init );

  const vector<Coordinates>& getSlaterCoords( void ) const {
    return multi.vcoord;
  }
  void updateSlaterCoords( const DTLattice& lattice );
  void calcSlater( void );
  static double calcDeterminant( const vector2d<double>& matrix );

public:
  DTField( void );
public:
  void update( void );

  const QString& getFileName( void ) const {
    return vdata[idata-1].filename;
  }

  const vector3d<double>& data( void ) const {
    switch(vdata[idata-1].fieldtype){
    case FIELD_REAL : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1;
      case 1 : return vdata[idata-1].data1;
      case 2 : return multi.data;
      }
    } break;

    case FIELD_COMPLEX : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1;
      case 1 : return vdata[idata-1].data1;
      }
    } break;
    }
    return vdata[0].data1; // error!
  }

  const vector3d<double>& data_abs( void ) const {
    switch(vdata[idata-1].fieldtype){
    case FIELD_REAL : {
    } break;

    case FIELD_COMPLEX : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1;
      case 1 : return vdata[idata-1].data1;
      }
    } break;
    }
    return vdata[0].data1; // error!
  }
  const vector3d<double>& data_arg( void ) const {
    switch(vdata[idata-1].fieldtype){
    case FIELD_REAL : {
    } break;

    case FIELD_COMPLEX : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data2;
      case 1 : return vdata[idata-1].data2;
      }
    } break;
    }
    return vdata[0].data1; // error!
  }

  double data_min( void ) const {
    switch(vdata[idata-1].fieldtype){
    case FIELD_REAL : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1.min();
      case 1 : return multi.min;
      case 2 : return multi.data.min();
      }
    } break;
    case FIELD_COMPLEX : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1.min();
      case 1 : return multi.min;
      }
    } break;
    }
    return 0.0; // error!
  }

  double data_max( void ) const {
    switch(vdata[idata-1].fieldtype){
    case FIELD_REAL : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1.max();
      case 1 : return multi.max;
      case 2 : return multi.data.max();
      }
    } break;
    case FIELD_COMPLEX : {
      switch( multi.mode ){
      case 0 : return vdata[idata-1].data1.max();
      case 1 : return multi.max;
      }
    } break;
    }
    return 0.0; // error!
  }

public:
  void clear( void );
  bool isset( void ) const {
    return getSize()>0;
  }

  bool load    ( const QString& fname );

  bool loadDX  ( const QString& fname );
  bool saveDX  ( const QString& fname );

  bool loadCube( const QString& fname );
  bool saveCube( const QString& fname );

  bool loadTAPP( const QString& fname );
  bool saveTAPP( const QString& fname );

  void exec_clustering( const DTCell& cell );

  double getScale( void ) const;
};


#endif // __DTFIELD_H_INCLUDED
