/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dthistory.h
 \brief Ǘ̃NX
*/

#ifndef __DTHISTORY_H_INCLUDED
#define __DTHISTORY_H_INCLUDED

#include <list>

// Undo@\f[^qXgǗNX
template <typename Datum> class DTHistory
{
  Datum& target;    // ĎΏۃf[^ւ̃|C^
  bool   undo_done; // undostO
  typename std::list<Datum>                 data; // f[^
  typename std::list<Datum>::const_iterator current; // 
  static const int maxhistory = 100; // őۑ

public:
  DTHistory( Datum& instance ) : target(instance) {
    data.push_front( target );
    current = data.begin();
    undo_done = false;
  }

  void clear( void ){
    data.clear();
    data.push_front( target );
    current = data.begin();
    undo_done = false;
  }

  // XV\bh
  // f[^̒lύXۂɂ͕K̃\bhĂԂƁB
  // UNDOĂԂƁB
  void update( void ){
    data.push_front( target );

    if( !undo_done ){
      current = data.begin();
      while( (int)data.size() > maxhistory ) data.pop_back();
    }
    undo_done = false;
  }

  // UNDO\bhBUNDOɂ͕Kupdate\bhĂԂƁB
  bool undo( void ){
    if( ++current != data.end() ){
      target = *current;
      undo_done = true;
    }
    else{
      current--;
      undo_done = false;
    }
    return undo_done;
  }
};

#endif // __DTHISTORY_H_INCLUDED
