/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtlattice.h
 \brief iqf[^̓NX
*/

#ifndef __DTLATTICE_H_INCLUDED
#define __DTLATTICE_H_INCLUDED

#include <vector>
using namespace std;

#include "dtcell.h"
#include "dtsymmetry.h"
#include "dtatoms.h"

const double AU_TO_AA = 0.529177210818; // a.u. length to angstrom

// ̃f[^ǗNX
class DTLattice
{
public:
  DTCell         cell;     // Z`
  DTSymmetry     symmetry; // ԌQ
  vector<DTAtoms> vdata;
  int             idata;

  int getAtomsSize( void ) const {
    return vdata.size();
  }
  DTAtoms& getData( void ){
    return vdata[idata-1];
  }
  const DTAtoms& getData( void ) const {
    return vdata[idata-1];
  }

public:
  DTLattice( void );

public:
  void update( void );
  void updateAtoms( void );

public:
  void clear( void );

public:
  // atomsf[^ɑ΂鑀
  const vector<DTAtom>& getAtoms( void ) const {
    return getData().vatom;
  }
  int getAtomSize( void ) const {
    return getData().size();
  }
  bool  selectAtom( const int iatom ){
    return getData().selectAtom( iatom );
  }
  bool  addselectAtom( const int iatom ){
    return getData().addselectAtom( iatom );
  }
  bool  selectAtoms( const vector<int> viatom ){
    return getData().selectAtoms( viatom );
  }
  void  unselectAtom( void ){
    getData().unselectAtom();
  }
  int getAtomSelected( void ){
    return getData().getAtomSelected();
  }
  const vector<int>& getAtomsSelected( void ){
    return getData().getAtomsSelected();
  }
  bool  isAtomSelected( void ) const {
    return getData().isAtomSelected();
  }

  bool moveAtomsCoords( const Position& t ){
    return getData().moveAtomsCoords( t );
  }
  bool moveAtomCoords( const Position& t ){
    return getData().moveAtomCoords( t );
  }

  bool changeAtomCoordA( const double a ){
    return getData().changeAtomCoordA( a );
  }
  bool changeAtomCoordB( const double b ){
    return getData().changeAtomCoordB( b );
  }
  bool changeAtomCoordC( const double c ){
    return getData().changeAtomCoordC( c );
  }
  bool changeAtomMotion( const int motion ){
    return getData().changeAtomMotion( motion );
  }
  bool changeAtomVelocityX( const double vx ){
    return getData().changeAtomVelocityX( vx );
  }
  bool changeAtomVelocityY( const double vy ){
    return getData().changeAtomVelocityY( vy );
  }
  bool changeAtomVelocityZ( const double vz ){
    return getData().changeAtomVelocityX( vz );
  }
  bool changeAtomElement( const QString& element ){
    return getData().changeAtomElement( element );
  }
  bool removeAtoms( void ){
    return getData().removeAtoms();
  }
  bool addAtoms( void ){
    return getData().addAtoms();
  }
  bool selectBrillouin( const int segment ){
    return cell.selectBrillouin( segment );
  }

  struct Cluster {
    int      method;
    int      Ex, Ey, Ez;
    int      M[3][3];
    Position La, Lb, Lc;
    
    vector<DTAtom> vatom;

    Cluster( void );
    void clear( void );
  } cluster;

  void clustering( void );
  void cancel_clustering( void );
  void exec_clustering( void );
  bool isclustering( void ){ return !cluster.vatom.empty(); }

  double getScale( void ) const;

  void findSymmetry( void );
};


#endif // __DTLATTICE_H_INCLUDED
