/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtmodel.h
 \brief f[^̓NX
*/

#ifndef __DTMODEL_H_INCLUDED
#define __DTMODEL_H_INCLUDED

#include <QtGui/QtGui>
#include "dtlattice.h"
#include "dtfield.h"
#include "dttapp.h"
#include "dtxtapp.h"
#include "dttcpp.h"
#include "dtband.h"
#include "dtdos.h"
#include "gloption.h"
#include "dthistory.h"

class DTModel : public QWidget
{
  Q_OBJECT

public:
  DTLattice    lattice;
  DTField      field;
  DTTapp       tapp;
  DTXTapp      xtapp;
  DTBand       band;
  DTDos        dos;
  GLOption     gloption;

  DTHistory<DTLattice> history_lattice;
  DTHistory<DTXTapp>   history_xtapp;

private:
  QString fname_saved;

public:
  const QString& getFileNameSaved( void ) const {
    return fname_saved;
  }

public:
  DTModel( void );

signals:
  void changed( void );
public slots:
  void update( void );

public:
  void clear( void );
  void undo( void );

  bool loadMolecule( const QString& fname );
  bool saveMolecule( const QString& fname );
  bool loadTAPP( const QString& fname );
  bool loadXTAPP( const QString& fname );
  bool saveXTAPP( const QString& fname );
  bool loadField( const QString& fname );
  bool loadBand( const QString& fname );
  bool loadDos( const QString& fname );

  void calcSlater( void );

  double getScale( void ) const;

  void exec_clustering( void );
};

QString getDirName( const QString& path );
QString getFileName( const QString& path );

#endif
