/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dtsymmetry.h
 \brief iq̑Ώ̐f[^̃NX
*/

#ifndef __DTSYMMETRY_H_INCLUDED
#define __DTSYMMETRY_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "imatrix.h"

class DTSymmetry
{
public:
  QString          name;
  bool            has_inversion;
  vector<IMatrix> vmatrix;

public:
  DTSymmetry( void );
  DTSymmetry( const char* symname,
	      const vector<const char*> vmatname,
	      const bool has_inversion, const int index );

  void clear( void );
  void clearIdentity( void );
  void update( void );

  bool match( const DTSymmetry& sym ) const;

public:
  void expand( void );
private:
  void expand_recursive( const IMatrix matrix );

public:
  static vector<DTSymmetry> vdbsymmetry;
  static vector<QString>     vdbsymname;
  int                       idbsymname;

public:
  static bool loadDB( const QString& fname );
  static bool findDB( DTSymmetry& sym );
};

#endif // __DTSGROUP_H_INCLUDED
