/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dttcpp.cc
 \brief TC++ ݒf[^̃NXij
*/

#include "dttcpp.h"
#include "qtxml.h"
#include "qtexception.h"


int  DTTCPP::Group::value_def = 1, DTTCPP::Group::value_min = 0, DTTCPP::Group::value_max = 10;

static char* fgets_comment( char* buf, int size, FILE* fptr )
{
  do{
    if( fgets(buf,size,fptr) == NULL ) return NULL;
  }while( buf[0] == '#' || buf[0] == '!' ||
	  buf[0] == '\r' || buf[0] == '\n' );

  return buf;
}

DTTCPP::DTTCPP( void )
{
  loadDefaults();
  clear();
}

void DTTCPP::update( void )
{
  // calculate other parameters.
}

void DTTCPP::clear( void )
{
  group.clear();
}

bool DTTCPP::load( DTLattice& lattice, const QString& fname )
{
  FILE* fptr = fopen( fname, "rb" );
  if( fptr == NULL ){
    throw MyException("TCPP input file is not found.",fname);
  }

  clear();

  if( !group.load(fptr) ){
    goto error_block;
  }

  fclose(fptr);

  update();

  return true;

 error_block:
  fclose(fptr);
  clear();
  throw MyException("TCPP input file is broken.",fname);
  return false; // dummy statement
}

bool DTTCPP::save( const DTLattice& lattice, const QString& fname )
{
  FILE* fptr = fopen( fname, "wb" );
  if( fptr == NULL ){
    throw MyException("can not create a config file.",fname);
  }

  group.save(fptr);

  fclose(fptr);
 
  return true;
}


DTTCPP::Group::Group( void )
{
  clear();
}

void DTTCPP::Group::clear( void )
{
  value = value_def;
}

bool DTTCPP::Group::load( FILE* fptr )
{
  char buf[1024];

  if( fgets_comment(buf,sizeof(buf),fptr) &&
      1 == sscanf(buf, "%d", &value ) ){
  }
  else{
    return false;
  }
  return true;
}

bool DTTCPP::Group::save( FILE* fptr )
{
  fprintf(fptr, "%d\n", value );

  return true;
}


bool DTTCPP::loadDefaults( void )
{
  QDomDocument doc;

  if( !XML::load( doc, "defaults.qtml") ) return false;

  QDomNode root = XML::getRoot(doc);
  root = XML::getFirstElementByTagName(root,"TCPP");

  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"Group");

    node  = XML::getFirstElementByTagName(group,"value");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &Group::value_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &Group::value_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &Group::value_max );
  }

  return true;
}

