/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file dttcpp.h
 \brief TC++ ݒf[^̃NXij
*/

#ifndef __DTTCPP_H_INCLUDED
#define __DTTCPP_H_INCLUDED

#include <stdio.h>

class DTLattice;

class DTTCPP
{
public:
  DTTCPP( void );
public:
  void update( void );
  void clear( void );

public:
  bool load( DTLattice& lattice, const QString& fname );
  bool save( const DTLattice& lattice, const QString& fname );
  static bool loadDefaults( void );

public:
  struct Group {
    int value; // sample value

    Group( void );
    void clear( void );
    bool load( FILE* fptr );
    bool save( FILE* fptr );

    static int value_def, value_min, value_max;
  } group;
};


#endif // __DTTCPP_H_INCLUDED
