/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
  \file dttapp.cc
  \brief TAPPݒf[^̃NX
*/

#include <stdio.h>
#include "dtlattice.h"
#include "dtxtapp.h"
#include "qtmisc.h"
#include "qtxml.h"
#include "qtexception.h"
#include "dttapp.h"

QString DTXTapp::TappInput::number_spin_bal="";
int     DTXTapp::TappInput::number_spin_def=1;
int     DTXTapp::TappInput::number_spin_min=1;
int     DTXTapp::TappInput::number_spin_max=2;
bool    DTXTapp::TappInput::number_spin_expert=false;
bool    DTXTapp::TappInput::number_spin_manual=false;

QString DTXTapp::TappInput::spin_mode_bal="";
int     DTXTapp::TappInput::spin_mode_def=1;
int     DTXTapp::TappInput::spin_mode_min=1;
int     DTXTapp::TappInput::spin_mode_max=2;
bool    DTXTapp::TappInput::spin_mode_expert=false;
bool    DTXTapp::TappInput::spin_mode_manual=false;

QString DTXTapp::TappInput::cutoff_local_potential_bal="";
double  DTXTapp::TappInput::cutoff_local_potential_def=10.0;
double  DTXTapp::TappInput::cutoff_local_potential_min=1.0;
double  DTXTapp::TappInput::cutoff_local_potential_max=100.0;
bool    DTXTapp::TappInput::cutoff_local_potential_expert=false;
bool    DTXTapp::TappInput::cutoff_local_potential_manual=false;

QString DTXTapp::TappInput::cutoff_wave_function_bal="";
double  DTXTapp::TappInput::cutoff_wave_function_def=10.0;
double  DTXTapp::TappInput::cutoff_wave_function_min=1.0;
double  DTXTapp::TappInput::cutoff_wave_function_max=100.0;
bool    DTXTapp::TappInput::cutoff_wave_function_expert=false;
bool    DTXTapp::TappInput::cutoff_wave_function_manual=false;

QString DTXTapp::TappInput::cutoff_uspp_q_bal="";
double  DTXTapp::TappInput::cutoff_uspp_q_def=1.0;
double  DTXTapp::TappInput::cutoff_uspp_q_min=1.0;
double  DTXTapp::TappInput::cutoff_uspp_q_max=100.0;
bool    DTXTapp::TappInput::cutoff_uspp_q_expert=false;
bool    DTXTapp::TappInput::cutoff_uspp_q_manual=false;

QString DTXTapp::TappInput::xtrap_beta_bal="";
double  DTXTapp::TappInput::xtrap_beta_def=0.4;
double  DTXTapp::TappInput::xtrap_beta_min=0.1;
double  DTXTapp::TappInput::xtrap_beta_max=0.9;
bool    DTXTapp::TappInput::xtrap_beta_expert=false;
bool    DTXTapp::TappInput::xtrap_beta_manual=false;

QString DTXTapp::TappInput::cutoff_btp_a_bal="";
double  DTXTapp::TappInput::cutoff_btp_a_def=0.0;
double  DTXTapp::TappInput::cutoff_btp_a_min=0.0;
double  DTXTapp::TappInput::cutoff_btp_a_max=10.0;
bool    DTXTapp::TappInput::cutoff_btp_a_expert=false;
bool    DTXTapp::TappInput::cutoff_btp_a_manual=false;

QString DTXTapp::TappInput::cutoff_btp_gc_bal="";
double  DTXTapp::TappInput::cutoff_btp_gc_def=4.0;
double  DTXTapp::TappInput::cutoff_btp_gc_min=0.0;
double  DTXTapp::TappInput::cutoff_btp_gc_max=10.0;
bool    DTXTapp::TappInput::cutoff_btp_gc_expert=false;
bool    DTXTapp::TappInput::cutoff_btp_gc_manual=false;

QString DTXTapp::TappInput::cutoff_btp_sigma_bal="";
double  DTXTapp::TappInput::cutoff_btp_sigma_def=4.0;
double  DTXTapp::TappInput::cutoff_btp_sigma_min=0.0;
double  DTXTapp::TappInput::cutoff_btp_sigma_max=10.0;
bool    DTXTapp::TappInput::cutoff_btp_sigma_expert=false;
bool    DTXTapp::TappInput::cutoff_btp_sigma_manual=false;

QString DTXTapp::TappInput::number_band_bal="";
int     DTXTapp::TappInput::number_band_def=10;
int     DTXTapp::TappInput::number_band_min=1;
int     DTXTapp::TappInput::number_band_max=100;
bool    DTXTapp::TappInput::number_band_expert=false;
bool    DTXTapp::TappInput::number_band_manual=false;

QString DTXTapp::TappInput::extra_charge_bal="";
double  DTXTapp::TappInput::extra_charge_def=0.0;
double  DTXTapp::TappInput::extra_charge_min=-10.0;
double  DTXTapp::TappInput::extra_charge_max=+10.0;
bool    DTXTapp::TappInput::extra_charge_expert=false;
bool    DTXTapp::TappInput::extra_charge_manual=false;

QString DTXTapp::TappInput::diff_spin_bal="";
double  DTXTapp::TappInput::diff_spin_def=0.0;
double  DTXTapp::TappInput::diff_spin_min=-1.0;
double  DTXTapp::TappInput::diff_spin_max=+1.0;
bool    DTXTapp::TappInput::diff_spin_expert=false;
bool    DTXTapp::TappInput::diff_spin_manual=false;

QString DTXTapp::TappInput::elec_kbt_bal="";
double  DTXTapp::TappInput::elec_kbt_def=0.0;
double  DTXTapp::TappInput::elec_kbt_min=0.0;
double  DTXTapp::TappInput::elec_kbt_max=100.0;
bool    DTXTapp::TappInput::elec_kbt_expert=false;
bool    DTXTapp::TappInput::elec_kbt_manual=false;

QString DTXTapp::TappInput::number_xtrap_stage_bal="";
int     DTXTapp::TappInput::number_xtrap_stage_def=0;
int     DTXTapp::TappInput::number_xtrap_stage_min=0;
int     DTXTapp::TappInput::number_xtrap_stage_max=10;
bool    DTXTapp::TappInput::number_xtrap_stage_expert=false;
bool    DTXTapp::TappInput::number_xtrap_stage_manual=false;

QString DTXTapp::TappInput::initial_wfn_bal="";
int     DTXTapp::TappInput::initial_wfn_def=0;
int     DTXTapp::TappInput::initial_wfn_min=0;
int     DTXTapp::TappInput::initial_wfn_max=1;
bool    DTXTapp::TappInput::initial_wfn_expert=false;
bool    DTXTapp::TappInput::initial_wfn_manual=false;

QString DTXTapp::TappInput::initial_lpt_bal="";
int     DTXTapp::TappInput::initial_lpt_def=0;
int     DTXTapp::TappInput::initial_lpt_min=0;
int     DTXTapp::TappInput::initial_lpt_max=2;
bool    DTXTapp::TappInput::initial_lpt_expert=false;
bool    DTXTapp::TappInput::initial_lpt_manual=false;

QString DTXTapp::TappInput::store_wfn_bal="";
int     DTXTapp::TappInput::store_wfn_def=0;
int     DTXTapp::TappInput::store_wfn_min=0;
int     DTXTapp::TappInput::store_wfn_max=1;
bool    DTXTapp::TappInput::store_wfn_expert=false;
bool    DTXTapp::TappInput::store_wfn_manual=false;

QString DTXTapp::TappInput::chain_calc_bal="";
int     DTXTapp::TappInput::chain_calc_def=0;
int     DTXTapp::TappInput::chain_calc_min=0;
int     DTXTapp::TappInput::chain_calc_max=3;
bool    DTXTapp::TappInput::chain_calc_expert=false;
bool    DTXTapp::TappInput::chain_calc_manual=false;

QString DTXTapp::TappInput::scf_converge_bal="";
double  DTXTapp::TappInput::scf_converge_def=1.0e-16;
double  DTXTapp::TappInput::scf_converge_min=1.0e-16;
double  DTXTapp::TappInput::scf_converge_max=1.0;
bool    DTXTapp::TappInput::scf_converge_expert=false;
bool    DTXTapp::TappInput::scf_converge_manual=false;

QString DTXTapp::TappInput::scf_converge_energy_bal="";
double  DTXTapp::TappInput::scf_converge_energy_def=1.0e-8;
double  DTXTapp::TappInput::scf_converge_energy_min=1.0e-8;
double  DTXTapp::TappInput::scf_converge_energy_max=1.0;
bool    DTXTapp::TappInput::scf_converge_energy_expert=false;
bool    DTXTapp::TappInput::scf_converge_energy_manual=false;

QString DTXTapp::TappInput::scf_number_iter_1st_bal="";
int     DTXTapp::TappInput::scf_number_iter_1st_def=0;
int     DTXTapp::TappInput::scf_number_iter_1st_min=50;
int     DTXTapp::TappInput::scf_number_iter_1st_max=100;
bool    DTXTapp::TappInput::scf_number_iter_1st_expert=false;
bool    DTXTapp::TappInput::scf_number_iter_1st_manual=false;

QString DTXTapp::TappInput::scf_number_iter_bal="";
int     DTXTapp::TappInput::scf_number_iter_def=0;
int     DTXTapp::TappInput::scf_number_iter_min=30;
int     DTXTapp::TappInput::scf_number_iter_max=100;
bool    DTXTapp::TappInput::scf_number_iter_expert=false;
bool    DTXTapp::TappInput::scf_number_iter_manual=false;

QString DTXTapp::TappInput::davidson_flag_bal="";
int     DTXTapp::TappInput::davidson_flag_def=-1;
int     DTXTapp::TappInput::davidson_flag_min=-1;
int     DTXTapp::TappInput::davidson_flag_max=10;
bool    DTXTapp::TappInput::davidson_flag_expert=false;
bool    DTXTapp::TappInput::davidson_flag_manual=false;

QString DTXTapp::TappInput::davidson_number_diag_1st_bal="";
int     DTXTapp::TappInput::davidson_number_diag_1st_def=1;
int     DTXTapp::TappInput::davidson_number_diag_1st_min=0;
int     DTXTapp::TappInput::davidson_number_diag_1st_max=10;
bool    DTXTapp::TappInput::davidson_number_diag_1st_expert=false;
bool    DTXTapp::TappInput::davidson_number_diag_1st_manual=false;

QString DTXTapp::TappInput::davidson_number_diag_bal="";
int     DTXTapp::TappInput::davidson_number_diag_def=1;
int     DTXTapp::TappInput::davidson_number_diag_min=0;
int     DTXTapp::TappInput::davidson_number_diag_max=10;
bool    DTXTapp::TappInput::davidson_number_diag_expert=false;
bool    DTXTapp::TappInput::davidson_number_diag_manual=false;

QString DTXTapp::TappInput::control_uptime_bal="";
double  DTXTapp::TappInput::control_uptime_def=1000.0;
double  DTXTapp::TappInput::control_uptime_min=0.0;
double  DTXTapp::TappInput::control_uptime_max=10000.0;
bool    DTXTapp::TappInput::control_uptime_expert=false;
bool    DTXTapp::TappInput::control_uptime_manual=false;

QString DTXTapp::TappInput::cutoff_bspl_fit_bal="";
double  DTXTapp::TappInput::cutoff_bspl_fit_def=15.0;
double  DTXTapp::TappInput::cutoff_bspl_fit_min=0.0;
double  DTXTapp::TappInput::cutoff_bspl_fit_max=100.0;
bool    DTXTapp::TappInput::cutoff_bspl_fit_expert=false;
bool    DTXTapp::TappInput::cutoff_bspl_fit_manual=false;

QString DTXTapp::TappInput::control_q_han_win_fac_bal="";
double  DTXTapp::TappInput::control_q_han_win_fac_def=-1.0;
double  DTXTapp::TappInput::control_q_han_win_fac_min=-1.0;
double  DTXTapp::TappInput::control_q_han_win_fac_max=10.0;
bool    DTXTapp::TappInput::control_q_han_win_fac_expert=false;
bool    DTXTapp::TappInput::control_q_han_win_fac_manual=false;

QString DTXTapp::TappInput::control_nbsf_bal="";
int     DTXTapp::TappInput::control_nbsf_def=2000;
int     DTXTapp::TappInput::control_nbsf_min=0;
int     DTXTapp::TappInput::control_nbsf_max=10000;
bool    DTXTapp::TappInput::control_nbsf_expert=false;
bool    DTXTapp::TappInput::control_nbsf_manual=false;

QString DTXTapp::TappInput::xc_type_bal="";
QString DTXTapp::TappInput::xc_type_def="'PBE'";
bool    DTXTapp::TappInput::xc_type_expert=false;
bool    DTXTapp::TappInput::xc_type_manual=false;

QString DTXTapp::TappInput::cutoff_exch_att_rc_bal="";
double  DTXTapp::TappInput::cutoff_exch_att_rc_def=-1.0;
double  DTXTapp::TappInput::cutoff_exch_att_rc_min=-1.0;
double  DTXTapp::TappInput::cutoff_exch_att_rc_max=10.0;
bool    DTXTapp::TappInput::cutoff_exch_att_rc_expert=false;
bool    DTXTapp::TappInput::cutoff_exch_att_rc_manual=false;

QString DTXTapp::TappInput::cutoff_exch_att_rd_bal="";
double  DTXTapp::TappInput::cutoff_exch_att_rd_def=-1.0;
double  DTXTapp::TappInput::cutoff_exch_att_rd_min=-1.0;
double  DTXTapp::TappInput::cutoff_exch_att_rd_max=10.0;
bool    DTXTapp::TappInput::cutoff_exch_att_rd_expert=false;
bool    DTXTapp::TappInput::cutoff_exch_att_rd_manual=false;

QString DTXTapp::TappInput::scf_threshold_hybrid_bal="";
double  DTXTapp::TappInput::scf_threshold_hybrid_def=0.0;
double  DTXTapp::TappInput::scf_threshold_hybrid_min=0.0;
double  DTXTapp::TappInput::scf_threshold_hybrid_max=1000.0;
bool    DTXTapp::TappInput::scf_threshold_hybrid_expert=false;
bool    DTXTapp::TappInput::scf_threshold_hybrid_manual=false;

QString DTXTapp::TappInput::compat_old_squ_norm_bal="";
int     DTXTapp::TappInput::compat_old_squ_norm_def=0;
int     DTXTapp::TappInput::compat_old_squ_norm_min=0;
int     DTXTapp::TappInput::compat_old_squ_norm_max=1;
bool    DTXTapp::TappInput::compat_old_squ_norm_expert=false;
bool    DTXTapp::TappInput::compat_old_squ_norm_manual=false;

QString DTXTapp::Symmetry::symmetry_format_bal="";
QString DTXTapp::Symmetry::symmetry_format_def = "'reciprocal'";
bool    DTXTapp::Symmetry::symmetry_format_expert=false;
bool    DTXTapp::Symmetry::symmetry_format_manual=false;

QString DTXTapp::SmplKpt::dos_mode_bal="";
QString DTXTapp::SmplKpt::dos_mode_def = "'COS'";
bool    DTXTapp::SmplKpt::dos_mode_expert=false;
bool    DTXTapp::SmplKpt::dos_mode_manual=false;

QString DTXTapp::SmplKpt::dos_band_lower_bal="";
int     DTXTapp::SmplKpt::dos_band_lower_def = 0;
int     DTXTapp::SmplKpt::dos_band_lower_min = 0;
int     DTXTapp::SmplKpt::dos_band_lower_max=10;
bool    DTXTapp::SmplKpt::dos_band_lower_expert=false;
bool    DTXTapp::SmplKpt::dos_band_lower_manual=false;

QString DTXTapp::SmplKpt::dos_band_upper_bal="";
int     DTXTapp::SmplKpt::dos_band_upper_def = 10;
int     DTXTapp::SmplKpt::dos_band_upper_min=0;
int     DTXTapp::SmplKpt::dos_band_upper_max=10;
bool    DTXTapp::SmplKpt::dos_band_upper_expert=false;
bool    DTXTapp::SmplKpt::dos_band_upper_manual=false;

QString DTXTapp::SmplKpt::dos_mesh_bal="";
int     DTXTapp::SmplKpt::dos_mesh_def=1;
int     DTXTapp::SmplKpt::dos_mesh_min=1;
int     DTXTapp::SmplKpt::dos_mesh_max=10;
bool    DTXTapp::SmplKpt::dos_mesh_expert=false;
bool    DTXTapp::SmplKpt::dos_mesh_manual=false;

QString DTXTapp::SmplKpt::bz_mesh_bal="";
int     DTXTapp::SmplKpt::bz_mesh_def=8;
int     DTXTapp::SmplKpt::bz_mesh_min=1;
int     DTXTapp::SmplKpt::bz_mesh_max=10;
bool    DTXTapp::SmplKpt::bz_mesh_expert=false;
bool    DTXTapp::SmplKpt::bz_mesh_manual=false;

QString DTXTapp::SmplKpt::bz_number_tile_bal="";
int     DTXTapp::SmplKpt::bz_number_tile_def=1;
int     DTXTapp::SmplKpt::bz_number_tile_min=1;
int     DTXTapp::SmplKpt::bz_number_tile_max=1;
bool    DTXTapp::SmplKpt::bz_number_tile_expert=false;
bool    DTXTapp::SmplKpt::bz_number_tile_manual=false;

QString DTXTapp::SmplKpt::cutoff_dos_cos_bal="";
double  DTXTapp::SmplKpt::cutoff_dos_cos_def=0.0;
double  DTXTapp::SmplKpt::cutoff_dos_cos_min=0.0;
double  DTXTapp::SmplKpt::cutoff_dos_cos_max=100.0;
bool    DTXTapp::SmplKpt::cutoff_dos_cos_expert=false;
bool    DTXTapp::SmplKpt::cutoff_dos_cos_manual=false;

QString DTXTapp::SmplKpt::rmesh_number_shell_bal="";
int     DTXTapp::SmplKpt::rmesh_number_shell_def=0;
int     DTXTapp::SmplKpt::rmesh_number_shell_min=0;
int     DTXTapp::SmplKpt::rmesh_number_shell_max=10;
bool    DTXTapp::SmplKpt::rmesh_number_shell_expert=false;
bool    DTXTapp::SmplKpt::rmesh_number_shell_manual=false;

QString DTXTapp::SmplKpt::rmesh_range_bal="";
int     DTXTapp::SmplKpt::rmesh_range_def=0;
int     DTXTapp::SmplKpt::rmesh_range_min=0;
int     DTXTapp::SmplKpt::rmesh_range_max=10;
bool    DTXTapp::SmplKpt::rmesh_range_expert=false;
bool    DTXTapp::SmplKpt::rmesh_range_manual=false;

QString DTXTapp::SmplKpt::mmm_outline_bal="";
bool    DTXTapp::SmplKpt::mmm_outline_expert=false;
bool    DTXTapp::SmplKpt::mmm_outline_manual=false;

QString DTXTapp::SmplKpt::mmm_detail_bal="";
bool    DTXTapp::SmplKpt::mmm_detail_expert=false;
bool    DTXTapp::SmplKpt::mmm_detail_manual=false;

QString DTXTapp::StructOpt::converge_energy_bal="";
double  DTXTapp::StructOpt::converge_energy_def=1.0e-8;
double  DTXTapp::StructOpt::converge_energy_min=1.0e-16;
double  DTXTapp::StructOpt::converge_energy_max=1.0;
bool    DTXTapp::StructOpt::converge_energy_expert=false;
bool    DTXTapp::StructOpt::converge_energy_manual=false;

QString DTXTapp::StructOpt::converge_force_bal="";
double  DTXTapp::StructOpt::converge_force_def=1.0e-3;
double  DTXTapp::StructOpt::converge_force_min=1.0e-16;
double  DTXTapp::StructOpt::converge_force_max=1.0;
bool    DTXTapp::StructOpt::converge_force_expert=false;
bool    DTXTapp::StructOpt::converge_force_manual=false;

QString DTXTapp::StructOpt::search_1d_fratio_bal="";
double  DTXTapp::StructOpt::search_1d_fratio_def=0.1;
double  DTXTapp::StructOpt::search_1d_fratio_min=0.01;
double  DTXTapp::StructOpt::search_1d_fratio_max=0.5;
bool    DTXTapp::StructOpt::search_1d_fratio_expert=false;
bool    DTXTapp::StructOpt::search_1d_fratio_manual=false;

QString DTXTapp::StructOpt::displacement_max_bal="";
double  DTXTapp::StructOpt::displacement_max_def=0.5;
double  DTXTapp::StructOpt::displacement_max_min=0.1;
double  DTXTapp::StructOpt::displacement_max_max=1.0;
bool    DTXTapp::StructOpt::displacement_max_expert=false;
bool    DTXTapp::StructOpt::displacement_max_manual=false;

QString DTXTapp::StructOpt::number_cycle_bal="";
int     DTXTapp::StructOpt::number_cycle_def=0;
int     DTXTapp::StructOpt::number_cycle_min=0;
int     DTXTapp::StructOpt::number_cycle_max=10;
bool    DTXTapp::StructOpt::number_cycle_expert=false;
bool    DTXTapp::StructOpt::number_cycle_manual=false;

QString DTXTapp::StructOpt::refresh_cycle_bal="";
int     DTXTapp::StructOpt::refresh_cycle_def=10;
int     DTXTapp::StructOpt::refresh_cycle_min=1;
int     DTXTapp::StructOpt::refresh_cycle_max=100;
bool    DTXTapp::StructOpt::refresh_cycle_expert=false;
bool    DTXTapp::StructOpt::refresh_cycle_manual=false;

QString DTXTapp::StructOpt::search_1d_max_step_bal="";
int     DTXTapp::StructOpt::search_1d_max_step_def=5;
int     DTXTapp::StructOpt::search_1d_max_step_min=1;
int     DTXTapp::StructOpt::search_1d_max_step_max=10;
bool    DTXTapp::StructOpt::search_1d_max_step_expert=false;
bool    DTXTapp::StructOpt::search_1d_max_step_manual=false;

QString DTXTapp::StructOpt::extern_pressure_bal="";
double  DTXTapp::StructOpt::extern_pressure_def=0.0;
double  DTXTapp::StructOpt::extern_pressure_min=0.0;
double  DTXTapp::StructOpt::extern_pressure_max=100.0;
bool    DTXTapp::StructOpt::extern_pressure_expert=false;
bool    DTXTapp::StructOpt::extern_pressure_manual=false;

QString DTXTapp::StructOpt::stress_scale_bal="";
double  DTXTapp::StructOpt::stress_scale_def=0.0;
double  DTXTapp::StructOpt::stress_scale_min=0.0;
double  DTXTapp::StructOpt::stress_scale_max=1.0;
bool    DTXTapp::StructOpt::stress_scale_expert=false;
bool    DTXTapp::StructOpt::stress_scale_manual=false;

QString DTXTapp::StrOptConstr::tim_bal="";
bool    DTXTapp::StrOptConstr::tim_expert=false;
bool    DTXTapp::StrOptConstr::tim_manual=false;

QString DTXTapp::StrOptConstr::set_bal="";
bool    DTXTapp::StrOptConstr::set_expert=false;
bool    DTXTapp::StrOptConstr::set_manual=false;

QString DTXTapp::TraceBand::distrib_mode_bal="";
QString DTXTapp::TraceBand::distrib_mode_def="'none'";
bool    DTXTapp::TraceBand::distrib_mode_expert=false;
bool    DTXTapp::TraceBand::distrib_mode_manual=false;

QString DTXTapp::TraceBand::output_charge_bal="";
int     DTXTapp::TraceBand::output_charge_def=0;
int     DTXTapp::TraceBand::output_charge_min=0;
int     DTXTapp::TraceBand::output_charge_max=1;
bool    DTXTapp::TraceBand::output_charge_expert=false;
bool    DTXTapp::TraceBand::output_charge_manual=false;

QString DTXTapp::TraceBand::output_wave_function_bal="";
int     DTXTapp::TraceBand::output_wave_function_def=0;
int     DTXTapp::TraceBand::output_wave_function_min=0;
int     DTXTapp::TraceBand::output_wave_function_max=1;
bool    DTXTapp::TraceBand::output_wave_function_expert=false;
bool    DTXTapp::TraceBand::output_wave_function_manual=false;

QString DTXTapp::TraceBand::davidson_flag_bal="";
int     DTXTapp::TraceBand::davidson_flag_def=5;
int     DTXTapp::TraceBand::davidson_flag_min=0;
int     DTXTapp::TraceBand::davidson_flag_max=10;
bool    DTXTapp::TraceBand::davidson_flag_expert=false;
bool    DTXTapp::TraceBand::davidson_flag_manual=false;

QString DTXTapp::TraceBand::davidson_number_diag_bal="";
int     DTXTapp::TraceBand::davidson_number_diag_def=40;
int     DTXTapp::TraceBand::davidson_number_diag_min=0;
int     DTXTapp::TraceBand::davidson_number_diag_max=100;
bool    DTXTapp::TraceBand::davidson_number_diag_expert=false;
bool    DTXTapp::TraceBand::davidson_number_diag_manual=false;

QString DTXTapp::TraceBand::diag_converge_bal="";
double  DTXTapp::TraceBand::diag_converge_def=1.0e-5;
double  DTXTapp::TraceBand::diag_converge_min=1.0e-10;
double  DTXTapp::TraceBand::diag_converge_max=1.0e-0;
bool    DTXTapp::TraceBand::diag_converge_expert=false;
bool    DTXTapp::TraceBand::diag_converge_manual=false;

QString DTXTapp::TraceBand::distrib_band_lower_bal="";
int     DTXTapp::TraceBand::distrib_band_lower_def=1;
int     DTXTapp::TraceBand::distrib_band_lower_min=1;
int     DTXTapp::TraceBand::distrib_band_lower_max=10;
bool    DTXTapp::TraceBand::distrib_band_lower_expert=false;
bool    DTXTapp::TraceBand::distrib_band_lower_manual=false;

QString DTXTapp::TraceBand::distrib_band_upper_bal="";
int     DTXTapp::TraceBand::distrib_band_upper_def=8;
int     DTXTapp::TraceBand::distrib_band_upper_min=1;
int     DTXTapp::TraceBand::distrib_band_upper_max=10;
bool    DTXTapp::TraceBand::distrib_band_upper_expert=false;
bool    DTXTapp::TraceBand::distrib_band_upper_manual=false;

QString DTXTapp::TraceBand::distrib_number_sphere_bal="";
int     DTXTapp::TraceBand::distrib_number_sphere_def=1;
int     DTXTapp::TraceBand::distrib_number_sphere_min=0;
int     DTXTapp::TraceBand::distrib_number_sphere_max=10;
bool    DTXTapp::TraceBand::distrib_number_sphere_expert=false;
bool    DTXTapp::TraceBand::distrib_number_sphere_manual=false;

QString DTXTapp::TraceBand::distrib_number_plate_bal="";
int     DTXTapp::TraceBand::distrib_number_plate_def=0;
int     DTXTapp::TraceBand::distrib_number_plate_min=0;
int     DTXTapp::TraceBand::distrib_number_plate_max=10;
bool    DTXTapp::TraceBand::distrib_number_plate_expert=false;
bool    DTXTapp::TraceBand::distrib_number_plate_manual=false;

QString DTXTapp::TraceBand::number_band_bal="";
int     DTXTapp::TraceBand::number_band_def=8;
int     DTXTapp::TraceBand::number_band_min=1;
int     DTXTapp::TraceBand::number_band_max=10;
bool    DTXTapp::TraceBand::number_band_expert=false;
bool    DTXTapp::TraceBand::number_band_manual=false;

/* DEBUG
QString DTXTapp::TraceBand::number_band_traced_bal="";
int     DTXTapp::TraceBand::number_band_traced_def=8;
int     DTXTapp::TraceBand::number_band_traced_min=1;
int     DTXTapp::TraceBand::number_band_traced_max=10;
bool    DTXTapp::TraceBand::number_band_traced_expert=false;
bool    DTXTapp::TraceBand::number_band_traced_manual=false;

QString DTXTapp::TraceBand::number_trace_block_bal="";
int     DTXTapp::TraceBand::number_trace_block_def=7;
int     DTXTapp::TraceBand::number_trace_block_min=0;
int     DTXTapp::TraceBand::number_trace_block_max=10;
bool    DTXTapp::TraceBand::number_trace_block_expert=false;
bool    DTXTapp::TraceBand::number_trace_block_manual=false;
*/

QString DTXTapp::TraceBand::iaxis_bal="";
int     DTXTapp::TraceBand::iaxis_def=1;
int     DTXTapp::TraceBand::iaxis_min=1;
int     DTXTapp::TraceBand::iaxis_max=3;
bool    DTXTapp::TraceBand::iaxis_expert=false;
bool    DTXTapp::TraceBand::iaxis_manual=false;

QString DTXTapp::TraceBand::rzero_bal="";
double  DTXTapp::TraceBand::rzero_def=0.0;
double  DTXTapp::TraceBand::rzero_min=0.0;
double  DTXTapp::TraceBand::rzero_max=1.0;
bool    DTXTapp::TraceBand::rzero_expert=false;
bool    DTXTapp::TraceBand::rzero_manual=false;

QString DTXTapp::TraceBand::rmin_bal="";
double  DTXTapp::TraceBand::rmin_def=0.0;
double  DTXTapp::TraceBand::rmin_min=0.0;
double  DTXTapp::TraceBand::rmin_max=1.0;
bool    DTXTapp::TraceBand::rmin_expert=false;
bool    DTXTapp::TraceBand::rmin_manual=false;

QString DTXTapp::TraceBand::ndiv_bal="";
int     DTXTapp::TraceBand::ndiv_def=1;
int     DTXTapp::TraceBand::ndiv_min=1;
int     DTXTapp::TraceBand::ndiv_max=100;
bool    DTXTapp::TraceBand::ndiv_expert=false;
bool    DTXTapp::TraceBand::ndiv_manual=false;

QString DTXTapp::TraceBand::kpoint_bal="";
bool    DTXTapp::TraceBand::kpoint_expert=false;
bool    DTXTapp::TraceBand::kpoint_manual=false;

QString DTXTapp::InspectWfn::distrib_mode_bal="";
QString DTXTapp::InspectWfn::distrib_mode_def="'none'";
bool    DTXTapp::InspectWfn::distrib_mode_expert=false;
bool    DTXTapp::InspectWfn::distrib_mode_manual=false;

QString DTXTapp::InspectWfn::output_charge_bal="";
int     DTXTapp::InspectWfn::output_charge_def=0;
int     DTXTapp::InspectWfn::output_charge_min=0;
int     DTXTapp::InspectWfn::output_charge_max=1;
bool    DTXTapp::InspectWfn::output_charge_expert=false;
bool    DTXTapp::InspectWfn::output_charge_manual=false;

QString DTXTapp::InspectWfn::distrib_band_lower_bal="";
int     DTXTapp::InspectWfn::distrib_band_lower_def=1;
int     DTXTapp::InspectWfn::distrib_band_lower_min=1;
int     DTXTapp::InspectWfn::distrib_band_lower_max=10;
bool    DTXTapp::InspectWfn::distrib_band_lower_expert=false;
bool    DTXTapp::InspectWfn::distrib_band_lower_manual=false;

QString DTXTapp::InspectWfn::distrib_band_upper_bal="";
int     DTXTapp::InspectWfn::distrib_band_upper_def=8;
int     DTXTapp::InspectWfn::distrib_band_upper_min=1;
int     DTXTapp::InspectWfn::distrib_band_upper_max=10;
bool    DTXTapp::InspectWfn::distrib_band_upper_expert=false;
bool    DTXTapp::InspectWfn::distrib_band_upper_manual=false;

QString DTXTapp::InspectWfn::distrib_number_sphere_bal="";
int     DTXTapp::InspectWfn::distrib_number_sphere_def=1;
int     DTXTapp::InspectWfn::distrib_number_sphere_min=0;
int     DTXTapp::InspectWfn::distrib_number_sphere_max=10;
bool    DTXTapp::InspectWfn::distrib_number_sphere_expert=false;
bool    DTXTapp::InspectWfn::distrib_number_sphere_manual=false;

QString DTXTapp::InspectWfn::distrib_number_plate_bal="";
int     DTXTapp::InspectWfn::distrib_number_plate_def=0;
int     DTXTapp::InspectWfn::distrib_number_plate_min=0;
int     DTXTapp::InspectWfn::distrib_number_plate_max=10;
bool    DTXTapp::InspectWfn::distrib_number_plate_expert=false;
bool    DTXTapp::InspectWfn::distrib_number_plate_manual=false;

QString DTXTapp::InspectWfn::pdos_target_atom_bal="";
int     DTXTapp::InspectWfn::pdos_target_atom_def=1;
int     DTXTapp::InspectWfn::pdos_target_atom_min=1;
int     DTXTapp::InspectWfn::pdos_target_atom_max=10;
bool    DTXTapp::InspectWfn::pdos_target_atom_expert=false;
bool    DTXTapp::InspectWfn::pdos_target_atom_manual=false;

QString DTXTapp::InspectWfn::iaxis_bal="";
int     DTXTapp::InspectWfn::iaxis_def=1;
int     DTXTapp::InspectWfn::iaxis_min=1;
int     DTXTapp::InspectWfn::iaxis_max=3;
bool    DTXTapp::InspectWfn::iaxis_expert=false;
bool    DTXTapp::InspectWfn::iaxis_manual=false;

QString DTXTapp::InspectWfn::rzero_bal="";
double  DTXTapp::InspectWfn::rzero_def=0.0;
double  DTXTapp::InspectWfn::rzero_min=0.0;
double  DTXTapp::InspectWfn::rzero_max=1.0;
bool    DTXTapp::InspectWfn::rzero_expert=false;
bool    DTXTapp::InspectWfn::rzero_manual=false;


QString DTXTapp::InspectWfn::rmin_bal="";
double  DTXTapp::InspectWfn::rmin_def=0.0;
double  DTXTapp::InspectWfn::rmin_min=0.0;
double  DTXTapp::InspectWfn::rmin_max=1.0;
bool    DTXTapp::InspectWfn::rmin_expert=false;
bool    DTXTapp::InspectWfn::rmin_manual=false;

QString DTXTapp::InspectWfn::ndiv_bal="";
int     DTXTapp::InspectWfn::ndiv_def=1;
int     DTXTapp::InspectWfn::ndiv_min=1;
int     DTXTapp::InspectWfn::ndiv_max=100;
bool    DTXTapp::InspectWfn::ndiv_expert=false;
bool    DTXTapp::InspectWfn::ndiv_manual=false;

QString DTXTapp::StmInput::stm_fermi_energy_bal="";
double  DTXTapp::StmInput::stm_fermi_energy_def=0.0;
double  DTXTapp::StmInput::stm_fermi_energy_min=0.0;
double  DTXTapp::StmInput::stm_fermi_energy_max=100.0;
bool    DTXTapp::StmInput::stm_fermi_energy_expert=false;
bool    DTXTapp::StmInput::stm_fermi_energy_manual=false;

QString DTXTapp::StmInput::vs_bal="";
double  DTXTapp::StmInput::vs_def=0.0;
double  DTXTapp::StmInput::vs_min=0.0;
double  DTXTapp::StmInput::vs_max=100.0;
bool    DTXTapp::StmInput::vs_expert=false;
bool    DTXTapp::StmInput::vs_manual=false;

QString DTXTapp::MolDyn::md_mode_bal="";
QString DTXTapp::MolDyn::md_mode_def="'NVE'";
bool    DTXTapp::MolDyn::md_mode_expert=false;
bool    DTXTapp::MolDyn::md_mode_manual=false;

QString DTXTapp::MolDyn::delta_time_bal="";
double  DTXTapp::MolDyn::delta_time_def=40.0;
double  DTXTapp::MolDyn::delta_time_min=1.0;
double  DTXTapp::MolDyn::delta_time_max=100.0;
bool    DTXTapp::MolDyn::delta_time_expert=false;
bool    DTXTapp::MolDyn::delta_time_manual=false;

QString DTXTapp::MolDyn::init_md_step_bal="";
int     DTXTapp::MolDyn::init_md_step_def=1;
int     DTXTapp::MolDyn::init_md_step_min=-1;
int     DTXTapp::MolDyn::init_md_step_max=1;
bool    DTXTapp::MolDyn::init_md_step_expert=false;
bool    DTXTapp::MolDyn::init_md_step_manual=false;

QString DTXTapp::MolDyn::end_md_step_bal="";
int     DTXTapp::MolDyn::end_md_step_def=1000;
int     DTXTapp::MolDyn::end_md_step_min=1;
int     DTXTapp::MolDyn::end_md_step_max=100000;
bool    DTXTapp::MolDyn::end_md_step_expert=false;
bool    DTXTapp::MolDyn::end_md_step_manual=false;

QString DTXTapp::MolDyn::mode_xtrap_rho_wfn_bal="";
int     DTXTapp::MolDyn::mode_xtrap_rho_wfn_def=2;
int     DTXTapp::MolDyn::mode_xtrap_rho_wfn_min=0;
int     DTXTapp::MolDyn::mode_xtrap_rho_wfn_max=2;
bool    DTXTapp::MolDyn::mode_xtrap_rho_wfn_expert=false;
bool    DTXTapp::MolDyn::mode_xtrap_rho_wfn_manual=false;

QString DTXTapp::MolDyn::message_cycle_bal="";
int     DTXTapp::MolDyn::message_cycle_def=1;
int     DTXTapp::MolDyn::message_cycle_min=1;
int     DTXTapp::MolDyn::message_cycle_max=10;
bool    DTXTapp::MolDyn::message_cycle_expert=false;
bool    DTXTapp::MolDyn::message_cycle_manual=false;

QString DTXTapp::MolDyn::system_volume_bal="";
double  DTXTapp::MolDyn::system_volume_def=0.0;
double  DTXTapp::MolDyn::system_volume_min=0.0;
double  DTXTapp::MolDyn::system_volume_max=100000.0;
bool    DTXTapp::MolDyn::system_volume_expert=false;
bool    DTXTapp::MolDyn::system_volume_manual=false;

QString DTXTapp::MolDyn::system_kbt_bal="";
double  DTXTapp::MolDyn::system_kbt_def=1.584044991946715e-003;
double  DTXTapp::MolDyn::system_kbt_min=0.0;
double  DTXTapp::MolDyn::system_kbt_max=1.0;
bool    DTXTapp::MolDyn::system_kbt_expert=false;
bool    DTXTapp::MolDyn::system_kbt_manual=false;

QString DTXTapp::MolDyn::system_pressure_bal="";
double  DTXTapp::MolDyn::system_pressure_def=0.0;
double  DTXTapp::MolDyn::system_pressure_min=0.0;
double  DTXTapp::MolDyn::system_pressure_max=1.0;
bool    DTXTapp::MolDyn::system_pressure_expert=false;
bool    DTXTapp::MolDyn::system_pressure_manual=false;

QString DTXTapp::MolDyn::stern_omega_zeta_bal="";
double  DTXTapp::MolDyn::stern_omega_zeta_def=0.0;
double  DTXTapp::MolDyn::stern_omega_zeta_min=0.0;
double  DTXTapp::MolDyn::stern_omega_zeta_max=1.0;
bool    DTXTapp::MolDyn::stern_omega_zeta_expert=false;
bool    DTXTapp::MolDyn::stern_omega_zeta_manual=false;

QString DTXTapp::MolDyn::stern_omega_eta_bal="";
double  DTXTapp::MolDyn::stern_omega_eta_def=0.0;
double  DTXTapp::MolDyn::stern_omega_eta_min=0.0;
double  DTXTapp::MolDyn::stern_omega_eta_max=1.0;
bool    DTXTapp::MolDyn::stern_omega_eta_expert=false;
bool    DTXTapp::MolDyn::stern_omega_eta_manual=false;

QString DTXTapp::MolDyn::stern_zeta_bal="";
double  DTXTapp::MolDyn::stern_zeta_def=0.0;
double  DTXTapp::MolDyn::stern_zeta_min=0.0;
double  DTXTapp::MolDyn::stern_zeta_max=1.0;
bool    DTXTapp::MolDyn::stern_zeta_expert=false;
bool    DTXTapp::MolDyn::stern_zeta_manual=false;

QString DTXTapp::MolDyn::stern_eta_bal="";
double  DTXTapp::MolDyn::stern_eta_def=0.0;
double  DTXTapp::MolDyn::stern_eta_min=0.0;
double  DTXTapp::MolDyn::stern_eta_max=1.0;
bool    DTXTapp::MolDyn::stern_eta_expert=false;
bool    DTXTapp::MolDyn::stern_eta_manual=false;

QString DTXTapp::MolDyn::stern_sigma_bal="";
double  DTXTapp::MolDyn::stern_sigma_def=0.0;
double  DTXTapp::MolDyn::stern_sigma_min=0.0;
double  DTXTapp::MolDyn::stern_sigma_max=1.0;
bool    DTXTapp::MolDyn::stern_sigma_expert=false;
bool    DTXTapp::MolDyn::stern_sigma_manual=false;

QString DTXTapp::MolDyn::abinitio_cycle_bal="";
int     DTXTapp::MolDyn::abinitio_cycle_def=0;
int     DTXTapp::MolDyn::abinitio_cycle_min=0;
int     DTXTapp::MolDyn::abinitio_cycle_max=100;
bool    DTXTapp::MolDyn::abinitio_cycle_expert=false;
bool    DTXTapp::MolDyn::abinitio_cycle_manual=false;

QString DTXTapp::Filemap::basename_bal="";
QString DTXTapp::Filemap::basename_def="";
bool    DTXTapp::Filemap::basename_expert=false;
bool    DTXTapp::Filemap::basename_manual=false;


// Fortran̎w` 1.0d2 C̎w` 1.0e2 ɕϊ֐
static bool change_exp_format( char* ptr )
{
  while( *ptr ){
    if( *ptr == 'd' ) *ptr = 'e';
    ptr++;
  }
  return true;
}

static int findmode( const vector<QString>& vmode, const QString mode )
{
  for( int n=0; n<(int)vmode.size(); n++ ){
    if( vmode[n] == mode ){
      return n;
    }
  }
  return 0;
}


DTXTapp::TappInput::TappInput( void )
{
  clear();
}

void DTXTapp::TappInput::clear( void )
{
  number_spin = number_spin_def;
  spin_mode = spin_mode_def; 
  cutoff_local_potential = cutoff_local_potential_def; 
  cutoff_wave_function = cutoff_wave_function_def; 
  cutoff_uspp_q = cutoff_uspp_q_def; 
  xtrap_beta = xtrap_beta_def; 
  cutoff_btp_a = cutoff_btp_a_def; 
  cutoff_btp_gc = cutoff_btp_gc_def; 
  cutoff_btp_sigma = cutoff_btp_sigma_def; 
  number_band = number_band_def;
  extra_charge = extra_charge_def; 
  diff_spin = diff_spin_def; 
  elec_kbt = elec_kbt_def; 
  number_xtrap_stage = number_xtrap_stage_def; 
  initial_wfn = initial_wfn_def; 
  initial_lpt = initial_lpt_def; 
  store_wfn = store_wfn_def; 
  chain_calc = chain_calc_def; 
  scf_converge = scf_converge_def; 
  scf_converge_energy = scf_converge_energy_def; 
  scf_number_iter_1st = scf_number_iter_1st_def; 
  scf_number_iter = scf_number_iter_def; 
  davidson_flag = davidson_flag_def; 
  davidson_number_diag_1st = davidson_number_diag_1st_def; 
  davidson_number_diag = davidson_number_diag_def; 
  control_uptime = control_uptime_def; 
  cutoff_bspl_fit = cutoff_bspl_fit_def; 
  control_q_han_win_fac = control_q_han_win_fac_def; 
  control_nbsf = control_nbsf_def; 
  cutoff_exch_att_rc = cutoff_exch_att_rc_def; 
  cutoff_exch_att_rd = cutoff_exch_att_rd_def; 
  scf_threshold_hybrid = scf_threshold_hybrid_def; 
  compat_old_squ_norm = compat_old_squ_norm_def; 

  vxc_type.clear();
  vxc_type.push_back("'PBE'");
  vxc_type.push_back("'PBEsol'");
  vxc_type.push_back("'PW91'");
  vxc_type.push_back("'CAPZ'");
  vxc_type.push_back("'LDAPW92'");
  vxc_type.push_back("'HF'");
  vxc_type.push_back("'PBE0'");
  vxc_type.push_back("'B3LYP'");

  ixc_type = findmode( vxc_type, xc_type_def );
}

void DTXTapp::TappInput::update( void )
{
}

bool DTXTapp::TappInput::load( DTLattice& lattice, NameListBuffer& nlb )
{
  char name[1024], value[1024];
  int number_element = 0;
  int number_atom = 0;

  // for str file
  if( nlb.readList("&struct_data") ) {
    while( nlb.getVariable(name,value) ){
      if( false );
      else if( !strcasecmp(name,"lattice_factor") ){
	if( 1 != sscanf(value,"%lf",&lattice.cell.length) ){ // &lattice_factor
	  MyException::critical("broken lattice_factor.");
	  return false;
	}
	else{
	  lattice.cell.length *= AU_TO_AA;
	}
      }
      else if( !strcasecmp(name,"lattice_list") ){
	if( 9 != sscanf(value,"%lf %lf %lf %lf %lf %lf %lf %lf %lf",
			&lattice.cell.Ea.x, &lattice.cell.Ea.y, &lattice.cell.Ea.z,
			&lattice.cell.Eb.x, &lattice.cell.Eb.y, &lattice.cell.Eb.z,
			&lattice.cell.Ec.x, &lattice.cell.Ec.y, &lattice.cell.Ec.z ) ){
	  MyException::critical("broken lattice_list.");
	  return false;
	}
	else{
	  lattice.cell.vectors_changed = true;
	}
      }
      else if( !strcasecmp(name,"number_element") ){
	if( 1 != sscanf(value,"%d", &number_element ) ) {
	  MyException::critical("broken number_element.");
	  return false;
	}
      }
      else if( !strcasecmp(name,"number_atom") ){
	if( 1 != sscanf(value,"%d", &number_atom ) ){
	  MyException::critical("broken number_atom.");
	  return false;
	}
      }
    }

    lattice.getData().clear();
    lattice.getData().vatom.resize(number_atom);
    lattice.getData().velement.resize(number_element);

    return true;
  }


  // for normal cg file
  if( !nlb.readList("&tappinput","# main data") ) return false;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"lattice_factor") ){
      if( 1 != sscanf(value,"%lf",&lattice.cell.length) ){ // &lattice_factor
	MyException::critical("broken lattice_factor.");
	return false;
      }
      else{
	lattice.cell.length *= AU_TO_AA;
      }
    }
    else if( !strcasecmp(name,"lattice_list") ){
      if( 9 != sscanf(value,"%lf %lf %lf %lf %lf %lf %lf %lf %lf",
		      &lattice.cell.Ea.x, &lattice.cell.Ea.y, &lattice.cell.Ea.z,
		      &lattice.cell.Eb.x, &lattice.cell.Eb.y, &lattice.cell.Eb.z,
		      &lattice.cell.Ec.x, &lattice.cell.Ec.y, &lattice.cell.Ec.z ) ){
	MyException::critical("broken lattice_list.");
	return false;
      }
      else{
	lattice.cell.vectors_changed = true;
      }
    }

    else if( !strcasecmp(name,"number_spin") ){
      if( 1 != sscanf(value,"%d", &number_spin ) ){
	MyException::critical("broken number_spin.");
	return false;
      }
      number_spin_manual=true;
    }
    else if( !strcasecmp(name,"spin_mode") ){
      if( 1 != sscanf(value,"%d", &spin_mode ) ){
	MyException::critical("broken spin_mode.");
	return false;
      }
      spin_mode_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_local_potential") ){
      if( 1 != sscanf(value,"%lf", &cutoff_local_potential ) ) {
	MyException::critical("broken cutoff_local_potential.");
	return false;
      }
      cutoff_local_potential_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_wave_function") ){
      if( 1 != sscanf(value,"%lf", &cutoff_wave_function ) ) {
	MyException::critical("broken cutoff_wave_function.");
	return false;
      }
      cutoff_wave_function_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_uspp_q") ){
      if( 1 != sscanf(value,"%lf", &cutoff_uspp_q ) ){
	MyException::critical("broken cutoff_uspp_q.");
	return false;
      }
      cutoff_uspp_q_manual=true;
    }
    else if( !strcasecmp(name,"xtrap_beta") ){
      if( 1 != sscanf(value,"%lf", &xtrap_beta ) ){
	MyException::critical("broken xtrap_beta.");
	return false;
      }
      xtrap_beta_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_btp_a") ){
      if( 1 != sscanf(value,"%lf", &cutoff_btp_a ) ){
	MyException::critical("broken cutoff_btp_a.");
	return false;
      }
      cutoff_btp_a_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_btp_gc") ){
      if( 1 != sscanf(value,"%lf", &cutoff_btp_gc ) ){
	MyException::critical("broken cutoff_btp_gc.");
	return false;
      }
      cutoff_btp_gc_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_btp_sigma") ){
      if( 1 != sscanf(value,"%lf", &cutoff_btp_sigma ) ){
	MyException::critical("broken cutoff_btp_sigma.");
	return false;
      }
      cutoff_btp_sigma_manual=true;
    }
    else if( !strcasecmp(name,"number_element") ){
      if( 1 != sscanf(value,"%d", &number_element ) ) {
	MyException::critical("broken number_element.");
	return false;
      }
    }
    else if( !strcasecmp(name,"number_atom") ){
      if( 1 != sscanf(value,"%d", &number_atom ) ){
	MyException::critical("broken number_atom.");
	return false;
      }
    }
    else if( !strcasecmp(name,"number_band") ){
      if( 1 != sscanf(value,"%d", &number_band ) ){
	MyException::critical("broken number_band.");
	return false;
      }
      number_band_manual=true;
    }
    else if( !strcasecmp(name,"extra_charge") ){
      if( 1 != sscanf(value,"%lf", &extra_charge ) ) {
	MyException::critical("broken extra_charge.");
	return false;
      }
      extra_charge_manual=true;
    }
    else if( !strcasecmp(name,"diff_spin") ){
      if( 1 != sscanf(value,"%lf", &diff_spin ) ) {
	MyException::critical("broken diff_spin.");
	return false;
      }
      diff_spin_manual=true;
    }
    else if( !strcasecmp(name,"elec_kbt") ){
      if( 1 != sscanf(value,"%lf", &elec_kbt ) ){
	MyException::critical("broken elec_kbt.");
	return false;
      }
      elec_kbt_manual=true;
    }
    else if( !strcasecmp(name,"number_xtrap_stage") ){
      if( 1 != sscanf(value,"%d", &number_xtrap_stage ) ){
	MyException::critical("broken number_xtrap_stage.");
	return false;
      }
      number_xtrap_stage_manual=true;
    }
    else if( !strcasecmp(name,"initial_wfn") ){
      if( 1 != sscanf(value,"%d", &initial_wfn ) ){
	MyException::critical("broken initial_wfn.");
	return false;
      }
      initial_wfn_manual=true;
    }
    else if( !strcasecmp(name,"initial_lpt") ){
      if( 1 != sscanf(value,"%d", &initial_lpt ) ){
	MyException::critical("broken initial_lpt.");
	return false;
      }
      initial_lpt_manual=true;
    }
    else if( !strcasecmp(name,"store_wfn") ){
      if( 1 != sscanf(value,"%d", &store_wfn ) ){
	MyException::critical("broken store_wfn.");
	return false;
      }
      store_wfn_manual=true;
    }
    else if( !strcasecmp(name,"chain_calc") ){
      if( 1 != sscanf(value,"%d", &chain_calc ) ){
	MyException::critical("broken chain_calc.");
	return false;
      }
      chain_calc_manual=true;
    }
    else if( !strcasecmp(name,"scf_converge") ){
      if( 1 != sscanf(value,"%lf", &scf_converge ) ){
	MyException::critical("broken scf_converge.");
	return false;
      }
      scf_converge_manual=true;
    }
    else if( !strcasecmp(name,"scf_converge_energy") ){
      if( 1 != sscanf(value,"%lf", &scf_converge_energy ) ){
	MyException::critical("broken scf_converge_energy.");
	return false;
      }
      scf_converge_energy_manual=true;
    }
    else if( !strcasecmp(name,"scf_number_iter_1st") ){
      if( 1 != sscanf(value,"%d", &scf_number_iter_1st ) ){
	MyException::critical("broken scf_number_iter_1st.");
	return false;
      }
      scf_number_iter_1st_manual=true;
    }
    else if( !strcasecmp(name,"scf_number_iter") ){
      if( 1 != sscanf(value,"%d", &scf_number_iter ) ){
	MyException::critical("broken scf_number_iter.");
	return false;
      }
      scf_number_iter_manual=true;
    }
    else if( !strcasecmp(name,"davidson_flag") ){
      if( 1 != sscanf(value,"%d", &davidson_flag ) ){
	MyException::critical("broken davidson_flag.");
	return false;
      }
      davidson_flag_manual=true;
    }
    else if( !strcasecmp(name,"davidson_number_diag_1st") ){
      if( 1 != sscanf(value,"%d", &davidson_number_diag_1st ) ){
	MyException::critical("broken davidson_number_diag_1st.");
	return false;
      }
      davidson_number_diag_1st_manual=true;
    }
    else if( !strcasecmp(name,"davidson_number_diag") ){
      if( 1 != sscanf(value,"%d", &davidson_number_diag ) ){
	MyException::critical("broken davidson_number_diag.");
	return false;
      }
      davidson_number_diag_manual=true;
    }
    else if( !strcasecmp(name,"control_uptime") ){
      if( 1 != sscanf(value,"%lf", &control_uptime ) ){
	MyException::critical("broken control_uptime.");
	return false;
      }
      control_uptime_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_bspl_fit") ){
      if( 1 != sscanf(value,"%lf", &cutoff_bspl_fit ) ){
	MyException::critical("broken cutoff_bspl_fit.");
	return false;
      }
      cutoff_bspl_fit_manual=true;
    }
    else if( !strcasecmp(name,"control_q_han_win_fac") ){
      if( 1 != sscanf(value,"%lf", &control_q_han_win_fac ) ){
	MyException::critical("broken control_q_han_win_fac.");
	return false;
      }
      control_q_han_win_fac_manual=true;
    }
    else if( !strcasecmp(name,"control_nbsf") ){
      if( 1 != sscanf(value,"%d", &control_nbsf ) ){
	MyException::critical("broken control_nbsf.");
	return false;
      }
      control_nbsf_manual=true;
    }
    else if( !strcasecmp(name,"xc_type") ){
      ixc_type = findmode( vxc_type, value );
      xc_type_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_exch_att_rc") ){
      if( 1 != sscanf(value,"%lf", &cutoff_exch_att_rc ) ){
	MyException::critical("broken cutoff_exch_att_rc.");
	return false;
      }
      cutoff_exch_att_rc_manual=true;
    }
    else if( !strcasecmp(name,"cutoff_exch_att_rd") ){
      if( 1 != sscanf(value,"%lf", &cutoff_exch_att_rd ) ){
	MyException::critical("broken cutoff_exch_att_rd.");
	return false;
      }
      cutoff_exch_att_rd_manual=true;
    }
    else if( !strcasecmp(name,"scf_threshold_hybrid") ){
      if( 1 != sscanf(value,"%lf", &scf_threshold_hybrid ) ){
	MyException::critical("broken scf_threshold_hybrid.");
	return false;
      }
      scf_threshold_hybrid_manual=true;
    }
    else if( !strcasecmp(name,"compat_old_squ_norm") ){
      if( 1 != sscanf(value,"%d", &compat_old_squ_norm ) ){
	MyException::critical("broken compat_old_squ_norm.");
	return false;
      }
      compat_old_squ_norm_manual=true;
    }
    else{
	MyException::warning("unknown parameter:"+QString(name) );
	//      return true;
    }
  }

  {
    lattice.getData().clear();
    lattice.getData().vatom.resize(number_atom);
    lattice.getData().velement.resize(number_element);
  }

  return true;
}

bool DTXTapp::TappInput::save( const DTLattice& lattice, FILE* fptr )
{
  int number_atom=0;
  {
    for( int i=0; i<(int)lattice.getData().vatom.size(); i++ ){
      if( lattice.getData().vatom[i].isCopy() ) continue; // Rs[q
      //      if( lattice.getData().vatom[i].element == 0 ) continue; // _~[q
      number_atom++;
    }
  }

  fprintf(fptr, "# main data\n");
  fprintf(fptr, "&tappinput\n");

  fprintf(fptr,"  lattice_factor = %f\n", lattice.cell.length/AU_TO_AA );
  fprintf(fptr,"  lattice_list   = \n");
  fprintf(fptr,"    %+15.10f %+15.10f %+15.10f\n",
	  lattice.cell.Ea.x, lattice.cell.Ea.y, lattice.cell.Ea.z );
  fprintf(fptr,"    %+15.10f %+15.10f %+15.10f\n",
	  lattice.cell.Eb.x, lattice.cell.Eb.y, lattice.cell.Eb.z );
  fprintf(fptr,"    %+15.10f %+15.10f %+15.10f\n",
	  lattice.cell.Ec.x, lattice.cell.Ec.y, lattice.cell.Ec.z );

  if( TappInput::number_spin_manual ){
    fprintf(fptr,"  number_spin = %d\n", number_spin );
  }
  if( TappInput::spin_mode_manual ){
    fprintf(fptr,"  spin_mode = %d\n", spin_mode );
  }
  if( TappInput::cutoff_local_potential_manual ){
    fprintf(fptr,"  cutoff_local_potential = %f\n", cutoff_local_potential );
  }
  if( TappInput::cutoff_wave_function_manual ){
    fprintf(fptr,"  cutoff_wave_function = %f\n", cutoff_wave_function );
  }
  if( TappInput::cutoff_uspp_q_manual ){
    fprintf(fptr,"  cutoff_uspp_q = %f\n", cutoff_uspp_q );
  }
  if( TappInput::xtrap_beta_manual ){
    fprintf(fptr,"  xtrap_beta = %f\n", xtrap_beta );
  }
  if( TappInput::cutoff_btp_a_manual ){
    fprintf(fptr,"  cutoff_btp_a = %f\n", cutoff_btp_a );
  }
  if( TappInput::cutoff_btp_gc_manual ){
    fprintf(fptr,"  cutoff_btp_gc = %f\n", cutoff_btp_gc );
  }
  if( TappInput::cutoff_btp_sigma_manual ){
    fprintf(fptr,"  cutoff_btp_sigma = %f\n", cutoff_btp_sigma );
  }
  fprintf(fptr,"  number_element = %d\n", (int)lattice.getData().velement.size() );
  fprintf(fptr,"  number_atom = %d\n", number_atom );
  fprintf(fptr,"  number_band = %d\n", number_band );
 
  if( TappInput::extra_charge_manual ){
    fprintf(fptr,"  extra_charge = %f\n", extra_charge );
  }
  if( TappInput::diff_spin_manual ){
    fprintf(fptr,"  diff_spin = %f\n", diff_spin );
  }
  if( TappInput::elec_kbt_manual ){
    fprintf(fptr,"  elec_kbt = %e\n", elec_kbt );
  }
  if( TappInput::number_xtrap_stage_manual ){
    fprintf(fptr,"  number_xtrap_stage = %d\n", number_xtrap_stage );
  }
  if( TappInput::initial_wfn_manual ){
    fprintf(fptr,"  initial_wfn = %d\n", initial_wfn );
  }
  if( TappInput::initial_lpt_manual ){
    fprintf(fptr,"  initial_lpt = %d\n", initial_lpt );
  }
  if( TappInput::store_wfn_manual ){
    fprintf(fptr,"  store_wfn = %d\n", store_wfn );
  }
  if( TappInput::chain_calc_manual ){
    fprintf(fptr,"  chain_calc = %d\n", chain_calc );
  }
  if( TappInput::scf_converge_manual ){
    fprintf(fptr,"  scf_converge = %e\n", scf_converge );
  }
  if( TappInput::scf_converge_energy_manual ){
    fprintf(fptr,"  scf_converge_energy = %e\n", scf_converge_energy );
  }
  if( TappInput::scf_number_iter_1st_manual ){
    fprintf(fptr,"  scf_number_iter_1st = %d\n", scf_number_iter_1st );
  }
  if( TappInput::scf_number_iter_manual ){
    fprintf(fptr,"  scf_number_iter = %d\n", scf_number_iter );
  }
  if( TappInput::davidson_flag_manual ){
    fprintf(fptr,"  davidson_flag = %d\n", davidson_flag );
  }
  if( TappInput::davidson_number_diag_1st_manual ){
    fprintf(fptr,"  davidson_number_diag_1st = %d\n", davidson_number_diag_1st );
  }
  if( TappInput::davidson_number_diag_manual ){
    fprintf(fptr,"  davidson_number_diag = %d\n", davidson_number_diag );
  }
  if( TappInput::control_uptime_manual ){
    fprintf(fptr,"  control_uptime = %e\n", control_uptime );
  }
  if( TappInput::cutoff_bspl_fit_manual ){
    fprintf(fptr,"  cutoff_bspl_fit = %f\n", cutoff_bspl_fit );
  }
  if( TappInput::control_q_han_win_fac_manual ){
    fprintf(fptr,"  control_q_han_win_fac = %f\n", control_q_han_win_fac );
  }
  if( TappInput::control_nbsf_manual ){
    fprintf(fptr,"  control_nbsf = %d\n", control_nbsf );
  }
  if( TappInput::xc_type_manual ){
    fprintf(fptr,"  xc_type = %s\n", qPrintable(vxc_type[ixc_type]) );
  }
  if( TappInput::cutoff_exch_att_rc_manual ){
    fprintf(fptr,"  cutoff_exch_att_rc = %f\n", cutoff_exch_att_rc );
  }
  if( TappInput::cutoff_exch_att_rd_manual ){
    fprintf(fptr,"  cutoff_exch_att_rd = %f\n", cutoff_exch_att_rd );
  }
  if( TappInput::scf_threshold_hybrid_manual ){
    fprintf(fptr,"  scf_threshold_hybrid = %e\n", scf_threshold_hybrid );
  }
  if( TappInput::compat_old_squ_norm_manual ){
    fprintf(fptr,"  compat_old_squ_norm = %d\n", compat_old_squ_norm );
  }
  fprintf(fptr,"/\n");

  return true;
}



DTXTapp::Symmetry::Symmetry( void )
{
  clear();
}

void DTXTapp::Symmetry::clear( void )
{
  vsymmetry_format.clear();
  vsymmetry_format.push_back("'reciprocal'");
  isymmetry_format = findmode( vsymmetry_format, symmetry_format_def );

  number_sym_op = 1;
  has_inversion = 0;
  denom_trans = 1;
}

void DTXTapp::Symmetry::update( void )
{
}

bool DTXTapp::Symmetry::load( DTSymmetry& symmetry, NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];

  if( !nlb.readList("&symmetry","# symmetry data") ) return false;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"symmetry_format") ){
      isymmetry_format = findmode( vsymmetry_format, value );
      symmetry_format_manual=true;;
    }
    else if( !strcasecmp(name,"number_sym_op") ){
      if( 1 != sscanf(value,"%d", &number_sym_op ) ){
	MyException::critical("broken number_sym_op.");
	return false;
      }
    }
    else if( !strcasecmp(name,"has_inversion") ){
      if( 1 != sscanf(value,"%d", &has_inversion ) ){
	MyException::critical("broken has_inversion.");
	return false;
      }
    }
    else if( !strcasecmp(name,"denom_trans") ){
      if( 1 != sscanf(value,"%d", &denom_trans ) ){
	MyException::critical("broken denom_trans.");
	return false;
      }
    }
    else{
      MyException::warning("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  symmetry.name = "data";
  symmetry.has_inversion = has_inversion == 1;
  symmetry.vmatrix.resize(number_sym_op);

  for( int n=0; n<(int)symmetry.vmatrix.size(); n++ ){
    IMatrix imatrix;
    int Ta, Tb, Tc;
    if( nlb.readExtra(buf) &&
	12 == sscanf(buf, " %d %d %d %d %d %d %d %d %d %d %d %d",
		     &imatrix.M[0][0], &imatrix.M[1][0], &imatrix.M[2][0],
		     &imatrix.M[0][1], &imatrix.M[1][1], &imatrix.M[2][1],
		     &imatrix.M[0][2], &imatrix.M[1][2], &imatrix.M[2][2],
		     &Ta, &Tb, &Tc ) ){
    }
    else{
      return false;
    }
    imatrix.T[0] = fraction( Ta, denom_trans );
    imatrix.T[1] = fraction( Tb, denom_trans );
    imatrix.T[2] = fraction( Tc, denom_trans );
    symmetry.vmatrix[n] = imatrix.getTransInverse();
  }

  symmetry.expand();

  if( !DTSymmetry::findDB(symmetry) ){
    //    MyException::warning("unknown new symmetry");
    //    return false;
    return true;
  }

  return true;
}

bool DTXTapp::Symmetry::save( const DTSymmetry& symmetry, FILE* fptr )
{
  // SĂ̕sړq̍̕ŏ{߂B
  denom_trans=1;
  for( int n=0; n<(int)symmetry.vmatrix.size(); n++ ){
    denom_trans = fraction::common_denominator
      ( denom_trans, symmetry.vmatrix[n].T[0].denominator );
    denom_trans = fraction::common_denominator
      ( denom_trans, symmetry.vmatrix[n].T[1].denominator );
    denom_trans = fraction::common_denominator
      ( denom_trans, symmetry.vmatrix[n].T[2].denominator );
  }

  fprintf(fptr, "# symmetry data\n");
  fprintf(fptr, "&symmetry\n");
  if( Symmetry::symmetry_format_manual ){
    fprintf(fptr, "  symmetry_format = %s\n",
	    qPrintable(vsymmetry_format[isymmetry_format]) );
  }
  fprintf(fptr, "  number_sym_op = %d\n", (int)symmetry.vmatrix.size() );
  fprintf(fptr, "  has_inversion = %d\n", symmetry.has_inversion ? 1 : 0 );
  fprintf(fptr, "  denom_trans = %d\n", denom_trans );
  fprintf(fptr, "/\n");

  for( int n=0; n<(int)symmetry.vmatrix.size(); n++ ){
    const IMatrix imatrix = symmetry.vmatrix[n].getTransInverse();
    for( int i=0; i<3; i++ ){
      for( int j=0; j<3; j++ ){
	fprintf(fptr, " %2d", imatrix.M[j][i] );
      }
      fprintf(fptr,"  ");
    }
    fprintf(fptr," ");
    for( int i=0; i<3; i++ ){
      fprintf(fptr, " %d", (symmetry.vmatrix[n].T[i]*denom_trans).toInteger() );
    }
    fprintf(fptr, " ! %s\n", symmetry.vmatrix[n].name() );
  }

  return true;
}


DTXTapp::Atoms::Atoms( void )
{
  clear();
}

void DTXTapp::Atoms::clear( void )
{
}

void DTXTapp::Atoms::update( void )
{
}

bool DTXTapp::Atoms::load( DTAtoms& atoms, NameListBuffer& nlb )
{
  char buf[1024];
  double zo, zn;

  // for str file
  if( nlb.readList(NULL,"# valence_charge, nucleous_charge") ) {
    for( int n=0; n<(int)atoms.velement.size(); n++ ){
      if( nlb.readExtra(buf) && change_exp_format(buf) &&
	  2 == sscanf( buf, "%lf %lf", &zo, &zn ) ){
      }
      else{
	return false;
      }
      atoms.velement[n] = DTElement(zo,zn);
    }

    if( !nlb.readList(NULL,"# atom_kind, atom_position by cell coordinate") ){
      return false;
    }

    int ppid;
    Coordinates coords;
    int motion=1;
    for( int i=0; i<(int)atoms.vatom.size(); i++ ){
      if( nlb.readExtra(buf) && change_exp_format(buf) &&
	  4 == sscanf(buf, "%d %le %le %le",
		      &ppid,
		      &coords.a,
		      &coords.b,
		      &coords.c ) ){
	ppid--;
	if( ppid<0 || (int)atoms.velement.size()<=ppid ){
	  return false;
	}
	atoms.vatom[i] = DTAtom( atoms.velement[ppid], coords, motion );
	atoms.vatom[i].setAsOriginal(i);
      }else{
	return false;
      }
    }
    return true;
  }

  // for normal cg file
  if( nlb.readList("&atom","# atom data") ) {
    for( int n=0; n<(int)atoms.velement.size(); n++ ){
      if( nlb.readExtra(buf) && change_exp_format(buf) &&
	  2 == sscanf( buf, "%lf %lf", &zo, &zn ) ){
      }
      else{
	return false;
      }
      atoms.velement[n] = DTElement(zo,zn);
    }
 
    int ppid;
    Coordinates coords;
    int motion=1;
    for( int i=0; i<(int)atoms.vatom.size(); i++ ){
      if( nlb.readExtra(buf) && change_exp_format(buf) &&
	  4 == sscanf(buf, "%d %le %le %le",
		      &ppid,
		      &coords.a,
		      &coords.b,
		      &coords.c ) ){
	ppid--;
	if( ppid<0 || (int)atoms.velement.size()<=ppid ){
	  return false;
	}
	atoms.vatom[i] = DTAtom( atoms.velement[ppid], coords, motion );
	atoms.vatom[i].setAsOriginal(i);
      }else{
	return false;
      }
    }
    return true;
  }

  return false;
}

bool DTXTapp::Atoms::save( const DTAtoms& atoms, FILE* fptr )
{
  fprintf(fptr, "# atom data\n");
  //  fprintf(fptr, "&atom\n");
  //  fprintf(fptr, "/\n");

  for( int n=0; n<(int)atoms.velement.size(); n++ ){
    fprintf(fptr, " %f %f\n", atoms.velement[n].zo, atoms.velement[n].zn );
  }
  for( int i=0; i<(int)atoms.vatom.size(); i++ ){
    if( atoms.vatom[i].isCopy() ) continue; // Rs[q
    //    if( atoms.vatom[i].element == 0 ) continue; // _~[q

    fprintf(fptr, " %d %15.10f %15.10f %15.10f\n",
	    atoms.findPPID(atoms.vatom[i].element.number)+1,
	    atoms.vatom[i].coords.a,
	    atoms.vatom[i].coords.b,
	    atoms.vatom[i].coords.c );
    //    ,atoms.vatom[i].motion );
  }

  return true;
}


DTXTapp::SmplKpt::SmplKpt( void )
{
  clear();
}

void DTXTapp::SmplKpt::clear( void )
{
  dos_band_lower = dos_band_lower_def;
  dos_band_upper = dos_band_upper_def;
  dos_mesh[0]=dos_mesh[1]=dos_mesh[2]=dos_mesh_def;
  bz_mesh = bz_mesh_def;
  bz_number_tile = bz_number_tile_def;
  cutoff_dos_cos = cutoff_dos_cos_def;
  rmesh_number_shell = rmesh_number_shell_def;
  rmesh_range[0]=rmesh_range[1]=rmesh_range[2]=rmesh_range_def;

  gamma = true;

  vdos_mode.clear();
  vdos_mode.push_back("'COS'");
  vdos_mode.push_back("'METH-FESSEL_PAXTON'");
  vdos_mode.push_back("'FERMI'");
  idos_mode = findmode( vdos_mode, dos_mode_def );

  mmm1.clear();
  mmm2.clear();
  mmm1.push_back( int3(bz_mesh_def/2+1,bz_mesh_def/2+1,bz_mesh_def/2+1) );
  mmm2.push_back( int3(2,2,2) );
  mmm1_shown = mmm1.back();
  mmm2_shown = mmm2.back();

  index_shown = 1;

  update_shown();
  setByDetail();

  vmesh.clear();
  vmesh.push_back("manual");
  vmesh.push_back("(1x1x1)");
  vmesh.push_back("(2x2x2)");
  vmesh.push_back("(3x3x3)");
  vmesh.push_back("(4x4x4)");
  vmesh.push_back("(5x5x5)");
  vmesh.push_back("(6x6x6)");
  vmesh.push_back("(7x7x7)");
  vmesh.push_back("(8x8x8)");
  vmesh.push_back("(9x9x9)");
  vmesh.push_back("(10x10x10)");
  imesh = 0;
}

void DTXTapp::SmplKpt::update( void )
{
}

bool DTXTapp::SmplKpt::load( NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];

  if( !nlb.readList("&smpl_kpt","# k-points data") ) return false;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"dos_mode") ){
      idos_mode = findmode( vdos_mode, value );
      dos_mode_manual=true;;
    }
    else if( !strcasecmp(name,"dos_band_lower") ){
      if( 1 != sscanf(value,"%d", &dos_band_lower ) ){
	MyException::critical("broken dos_band_lower.");
	return false;
      }
      dos_band_lower_manual=true;;
    }
    else if( !strcasecmp(name,"dos_band_upper") ){
      if( 1 != sscanf(value,"%d", &dos_band_upper ) ){
	MyException::critical("broken dos_band_upper.");
	return false;
      }
      dos_band_upper_manual=true;;
    }
    else if( !strcasecmp(name,"dos_mesh") ){
      if( 3 != sscanf(value,"%d %d %d",
		      &dos_mesh[0],
		      &dos_mesh[1],
		      &dos_mesh[2] ) ){
	MyException::critical("broken dos_mesh.");
	return false;
      }
      dos_mesh_manual=true;;
    }
    else if( !strcasecmp(name,"bz_mesh") ){
      if( 1 != sscanf(value,"%d", &bz_mesh ) ){
	MyException::critical("broken bz_mesh.");
	return false;
      }
      bz_mesh_manual=true;;
    }
    else if( !strcasecmp(name,"bz_number_tile") ){
      if( 1 != sscanf(value,"%d", &bz_number_tile ) ){
	MyException::critical("broken bz_number_tile.");
	return false;
      }
      bz_number_tile_manual=true;;
    }
    else if( !strcasecmp(name,"cutoff_dos_cos") ){
      if( 1 != sscanf(value,"%lf", &cutoff_dos_cos ) ){
	MyException::critical("broken cutoff_dos_cos.");
	return false;
      }
      cutoff_dos_cos_manual=true;;
    }
    else if( !strcasecmp(name,"rmesh_number_shell") ){
      if( 1 != sscanf(value,"%d", &rmesh_number_shell ) ){
	MyException::critical("broken rmesh_number_shell.");
	return false;
      }
      rmesh_number_shell_manual=true;;
    }
    else if( !strcasecmp(name,"rmesh_range") ){
      if( 3 != sscanf(value,"%d %d %d",
		      &rmesh_range[0],
		      &rmesh_range[1],
		      &rmesh_range[2] ) ){
	MyException::critical("broken rmesh_range.");
	return false;
      }
      rmesh_range_manual=true;;
    }
    else{
      MyException::warning("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  mmm1.clear();
  mmm2.clear();
  //  imesh = 0;

  int3 mmm;

  for( int i=0; i<bz_number_tile; i++ ){
    if( nlb.readExtra(buf) &&
	3 == sscanf(buf, "%d %d %d", &mmm[0], &mmm[1], &mmm[2] ) ){
      mmm1.push_back(mmm);
    }
    else{
      return false;
    }

    if( nlb.readExtra(buf) &&
	3 == sscanf(buf, "%d %d %d", &mmm[0], &mmm[1], &mmm[2] ) ){
      mmm2.push_back(mmm);
    }
    else{
      return false;
    }
  }

  update_shown();

  setByDetail();

  return true;
}

bool DTXTapp::SmplKpt::save( FILE* fptr )
{
  fprintf(fptr, "# k-points data\n");
  fprintf(fptr, "&smpl_kpt\n");

  if( SmplKpt::dos_mode_manual ){
    fprintf(fptr, "  dos_mode = %s\n", qPrintable(vdos_mode[idos_mode]) );
  }
  if( SmplKpt::dos_band_lower_manual ){
    fprintf(fptr, "  dos_band_lower = %d\n", dos_band_lower );
  }
  if( SmplKpt::dos_band_upper_manual ){
    fprintf(fptr, "  dos_band_upper = %d\n", dos_band_upper );
  }
  if( SmplKpt::dos_mesh_manual ){
    fprintf(fptr, "  dos_mesh = %d %d %d\n",
	    dos_mesh[0], dos_mesh[1], dos_mesh[2] );
  }
  if( SmplKpt::bz_mesh_manual ){
    fprintf(fptr, "  bz_mesh = %d\n", bz_mesh );
  }
  {
    fprintf(fptr, "  bz_number_tile = %d\n", bz_number_tile );
  }
  if( SmplKpt::cutoff_dos_cos_manual ){
    fprintf(fptr, "  cutoff_dos_cos = %f\n", cutoff_dos_cos );
  }
  if( SmplKpt::rmesh_number_shell_manual ){
    fprintf(fptr, "  rmesh_number_shell = %d\n", rmesh_number_shell );
  }
  if( SmplKpt::rmesh_range_manual ){
    fprintf(fptr, "  rmesh_range = %d %d %d\n",
	    rmesh_range[0],rmesh_range[1],rmesh_range[2] );
  }
  fprintf(fptr, "/\n");
  for( int n=0; n<(int)mmm1.size(); n++ ){
    fprintf(fptr, "%d %d %d\n",
	    mmm1[n][0], mmm1[n][1], mmm1[n][2] );
    fprintf(fptr, "%d %d %d\n",
	    mmm2[n][0], mmm2[n][1], mmm2[n][2] );
  }

  return true;
}

void DTXTapp::SmplKpt::change_shown( void )
{
  if( mmm1.empty() ) return;
  if( index_shown > (int)mmm1.size() ) index_shown = 1;

  mmm1[index_shown-1] = mmm1_shown;
  mmm2[index_shown-1] = mmm2_shown;
}

void DTXTapp::SmplKpt::update_shown( void )
{
  if( mmm1.empty() ) return;
  if( index_shown > (int)mmm1.size() ) index_shown = 1;
    
  mmm1_shown  = mmm1[index_shown-1];
  mmm2_shown  = mmm2[index_shown-1];
}

int DTXTapp::SmplKpt::size_shown( void )
{
  return (int)mmm1.size();
}

static int GCD( int a, int b )
{
  int na, nb, nr;

  na = a;
  nb = b;

  while( nb>0 ){
    nr = na%nb;
    na = nb;
    nb = nr;
  }

  return na;
}

static int LCM( int a, int b )
{
  int g = GCD(a,b);
  return (a/g)*(b/g)*g;
}

static int LCM( int a, int b, int c )
{
  return LCM(LCM(a,b),c);
}

void DTXTapp::SmplKpt::setByOutline( void )
{
  //  if( imesh == 0 ) return;

  mmm1.clear();
  mmm2.clear();
  index_shown = 1;

  bz_mesh = LCM(2*mesh[0],2*mesh[1],2*mesh[2]);

  int3 m1;
  int3 m2;
  for( int i=0; i<3; i++ ){
    const int n = bz_mesh/(2*mesh[i]);
    m2[i] = 2*n;
    m1[i] = ( gamma ?
	      (mesh[i]%2==0 ? mesh[i]+0 : mesh[i]+1) :
	      (mesh[i]%2==0 ? mesh[i]+1 : mesh[i]+0)) * n;
  }

  mmm1.push_back(m1);
  mmm2.push_back(m2);
}

void DTXTapp::SmplKpt::setByDetail( void )
{
  //  imesh = 0;

  mesh = int3(0,0,0);

  int3 g = int3(0,0,0);

  for( int i=0; i<3; i++ ){
    for( int m=-mmm1_shown[i]; m<=+mmm1_shown[i]; m+=mmm2_shown[i] ){
      if( m<-bz_mesh/2 || +bz_mesh/2<m ) continue;
      mesh[i]++;
      if( m==0 ) g[i] = 1;
    }
  }

  gamma = g[0] && g[1] && g[2];
}

void DTXTapp::SmplKpt::addMMM( void )
{
  mmm1.push_back( mmm1.back() );
  mmm2.push_back( mmm2.back() );
  index_shown = (int)mmm1.size();
  update_shown();
}

void DTXTapp::SmplKpt::delMMM( void )
{
  if( (int)mmm1.size()<=1 ) return;
  if( index_shown > (int)mmm1.size() ) index_shown = 1;
  mmm1.erase( mmm1.begin()+index_shown-1 );
  mmm2.erase( mmm2.begin()+index_shown-1 );
  update_shown();
}

DTXTapp::StructOpt::StructOpt( void )
{
  clear();
}

void DTXTapp::StructOpt::clear( void )
{
  converge_energy  = converge_energy_def;
  converge_force   = converge_force_def;
  search_1d_fratio = search_1d_fratio_def; 
  displacement_max = displacement_max_def; 
  number_cycle     = number_cycle_def; 
  refresh_cycle    = refresh_cycle_def; 
  search_1d_max_step = search_1d_max_step_def; 
  extern_pressure  = extern_pressure_def; 
  stress_scale[0]  = stress_scale_def;
  stress_scale[1]  = stress_scale_def;
  stress_scale[2]  = stress_scale_def;
  stress_scale[3]  = stress_scale_def;
  stress_scale[4]  = stress_scale_def;
  stress_scale[5]  = stress_scale_def;
}


void DTXTapp::StructOpt::update( void )
{
}

bool DTXTapp::StructOpt::load( NameListBuffer& nlb )
{
  char name[1024], value[1024];
  if( !nlb.readList("&struct_opt","# struct_opt data") ) return false;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"converge_energy") ){
      if( 1 != sscanf(value,"%lf", &converge_energy ) ){
	MyException::critical("broken converge_energy.");
	return false;
      }
      converge_energy_manual=true;;
    }
    else if( !strcasecmp(name,"converge_force") ){
      if( 1 != sscanf(value,"%lf", &converge_force ) ){
	MyException::critical("broken converge_force.");
	return false;
      }
      converge_force_manual=true;;
    }
    else if( !strcasecmp(name,"search_1d_fratio") ){
      if( 1 != sscanf(value,"%lf", &search_1d_fratio ) ){
	MyException::critical("broken search_1d_fratio.");
	return false;
      }
      search_1d_fratio_manual=true;;
    }
    else if( !strcasecmp(name,"displacement_max") ){
      if( 1 != sscanf(value,"%lf", &displacement_max ) ){
	MyException::critical("broken displacement_max.");
	return false;
      }
      displacement_max_manual=true;;
    }
    else if( !strcasecmp(name,"number_cycle") ){
      if( 1 != sscanf(value,"%d", &number_cycle ) ){
	MyException::critical("broken number_cycle.");
	return false;
      }
      number_cycle_manual=true;;
    }
    else if( !strcasecmp(name,"refresh_cycle") ){
      if( 1 != sscanf(value,"%d", &refresh_cycle ) ){
	MyException::critical("broken refresh_cycle.");
	return false;
      }
      refresh_cycle_manual=true;;
    }
    else if( !strcasecmp(name,"search_1d_max_step") ){
      if( 1 != sscanf(value,"%d", &search_1d_max_step ) ){
	MyException::critical("broken search_1d_max_step.");
	return false;
      }
      search_1d_max_step_manual=true;;
    }
    else if( !strcasecmp(name,"extern_pressure") ){
      if( 1 != sscanf(value,"%lf", &extern_pressure ) ){
	MyException::critical("broken extern_pressure.");
	return false;
      }
      extern_pressure_manual=true;;
    }
    else if( !strcasecmp(name,"stress_scale") ){
      if( 6 != sscanf(value,"%lf %lf %lf %lf %lf %lf",
		      &stress_scale[0],
		      &stress_scale[1],
		      &stress_scale[2],
		      &stress_scale[3],
		      &stress_scale[4],
		      &stress_scale[5] ) ){
	MyException::critical("broken stress_scale.");
	return false;
      }
      stress_scale_manual=true;;
    }
    else{
      MyException::warning("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  return true;
}

bool DTXTapp::StructOpt::save( FILE* fptr )
{
  fprintf(fptr, "# struct_opt data\n");
  fprintf(fptr, "&struct_opt\n");
  if( StructOpt::converge_energy_manual ){
    fprintf(fptr, "  converge_energy = %e\n", converge_energy );
  }
  if( StructOpt::converge_force_manual ){
    fprintf(fptr, "  converge_force = %e\n", converge_force );
  }
  if( StructOpt::search_1d_fratio_manual ){
    fprintf(fptr, "  search_1d_fratio = %f\n", search_1d_fratio );
  }
  if( StructOpt::displacement_max_manual ){
    fprintf(fptr, "  displacement_max = %f\n", displacement_max );
  }
  if( StructOpt::number_cycle_manual ){
    fprintf(fptr, "  number_cycle = %d\n", number_cycle );
  }
  if( StructOpt::refresh_cycle_manual ){
    fprintf(fptr, "  refresh_cycle = %d\n", refresh_cycle );
  }
  if( StructOpt::search_1d_max_step_manual ){
    fprintf(fptr, "  search_1d_max_step = %d\n", search_1d_max_step );
  }
  if( StructOpt::extern_pressure_manual ){
    fprintf(fptr, "  extern_pressure = %e\n", extern_pressure );
  }
  if( StructOpt::stress_scale_manual ){
    fprintf(fptr, "  stress_scale = %f %f\n", stress_scale[0], stress_scale[1] );
    fprintf(fptr, "                 %f %f\n", stress_scale[2], stress_scale[3] );
    fprintf(fptr, "                 %f %f\n", stress_scale[4], stress_scale[5] );
  }
  fprintf(fptr, "/\n");

  return true;
}


DTXTapp::StrOptConstr::StrOptConstr( void )
{
  clear();
}

void DTXTapp::StrOptConstr::clear( void )
{
  tim.clear();
  //  tim.push_back( Matrix::getIdentity() );
  tim_index_shown = 1;
  tim_shown = Matrix::getZero();

  set.clear();
  //  set.push_back( Target() );
  set_index_shown = 1;
  set_shown = Target();
}

void DTXTapp::StrOptConstr::update( void )
{
}

bool DTXTapp::StrOptConstr::load( DTAtoms& atoms, NameListBuffer& nlb )
{
  //  char name[1024], value[1024];
  char buf[1024];
  int ivalue;

  if( !nlb.readList("&str_opt_constr","# str_opt_constr data") ) return false;

  if( nlb.readExtra(buf) &&
      1 == sscanf(buf, "%d", &ivalue ) && ivalue>=1 ){ // nmkd
    tim.resize(ivalue-1);
  }
  else{
    return false;
  }
  for( int n=0; n<(int)tim.size(); n++ ){
    for( int i=0; i<3; i++ ){
      if( nlb.readExtra(buf) && change_exp_format(buf) &&
	  3 == sscanf(buf, " %le %le %le",
		      &tim[n](0,i), &tim[n](1,i), &tim[n](2,i) ) ){
      }
      else{
	return false;
      }
    }
  }

  if( nlb.readExtra(buf) && 1 == sscanf(buf,"%d",&ivalue), ivalue>=0 ){//nset
  }
  else{
    return false;
  }
  set.resize(ivalue);
  for( int s=0; s<(int)set.size(); s++ ){
    if( nlb.readExtra(buf) &&
	1 == sscanf(buf,"%d %*d", &set[s].imkd ) ){
      set[s].imkd--; // skip the first element
    }
    else{
      return false;
    }
    if( nlb.readExtra(buf) ){
      set[s].tatm = buf;
      int n=set[s].imkd-1;
      if( tim[n] == Matrix::getZero() ){
	int len;
	int tatm;
	const char* ptr = qPrintable(set[s].tatm);
	while( 1 == sscanf( ptr, "%d%n", &tatm, &len ) ){
	  ptr+=len;
	  int i=tatm-1; // change offset to 0
	  atoms.vatom[i].motion = 0;
	}
      }
    }
  }

  return true;
}

bool DTXTapp::StrOptConstr::save( const DTAtoms& atoms, FILE* fptr )
{
  char list_fixed[1024]="";

  // q̃XgɌŒ茴q邩mF
  bool has_atom_fixed=false;
  char* ptr=list_fixed;
  for( int i=0; i<(int)atoms.vatom.size(); i++ ){
    if( atoms.vatom[i].isCopy() ) continue; // Rs[q
    //    if( atoms.vatom[i].element == 0 ) continue; // _~[q

    if( atoms.vatom[i].motion == 0 ){
      ptr += sprintf( ptr, " %d", i+1 ); // change offset to 1
      has_atom_fixed=true;
    }
  }

  // tʍs̃XgɌqŒ肷0s񂪂邩mF
  bool has_tim_fixed=false;
  int  index_tim_fixed=0;
  for( int n=0; n<(int)tim.size(); n++ ){
    if( tim[n] == Matrix::getZero() ){
      has_tim_fixed=true;
      index_tim_fixed=n;
      break;
    }
  }

  // 0s񂪎w肳ꂽq̃Xg邩mF
  bool has_set_fixed= false;
  int  index_set_fixed=0;
  for( int s=0; s<(int)set.size(); s++ ){
    if( set[s].imkd == index_tim_fixed+1 ){
      has_set_fixed=true;
      index_set_fixed=s;
      break;
    }
  }

  if( has_atom_fixed ){
    if( has_tim_fixed ){
      // use it
    }
    else{
      // add tim
      tim.push_back(Matrix::getZero());
      index_tim_fixed = (int)tim.size()-1;
    }
  }
  else{
    if( has_tim_fixed ){
      // delete it
      tim.erase( tim.begin()+index_tim_fixed );
      has_tim_fixed=false;
      index_tim_fixed=-1;
    }
  }

  if( has_atom_fixed ){
    if( has_set_fixed ){
      // use it
    }
    else{
      set.push_back(Target());
      index_set_fixed = (int)set.size()-1;
    }
  }
  else{
    if( has_set_fixed ){
      // delete it
      set.erase( set.begin()+index_set_fixed );
      has_set_fixed=false;
      index_set_fixed=-1;
    }
  }

  if( has_atom_fixed ){
    set[index_set_fixed].imkd = index_tim_fixed+1;
    set[index_set_fixed].tatm = QString(list_fixed);
  }

  fprintf(fptr, "# str_opt_constr data\n");
  //  fprintf(fptr, "&str_opt_constr\n");
  //  fprintf(fptr, "/\n");

  fprintf(fptr, "%d\n", (int)tim.size()+1 ); // unit matrix added
  for( int n=0; n<(int)tim.size(); n++ ){
    for( int i=0; i<3; i++ ){
      for( int j=0; j<3; j++ ){
	fprintf(fptr, " %f", tim[n](j,i) );
      }
      fprintf(fptr,"\n");
    }
  }

  fprintf(fptr, "%d\n", (int)set.size() );
  for( int s=0; s<(int)set.size(); s++ ){
    int nmsi=0;
    int tatm;
    int len;
    const char* ptr = qPrintable(set[s].tatm);
    while( 1 == sscanf( ptr, "%d%n", &tatm, &len ) ){
      ptr+=len;
      nmsi++;
    }
    fprintf(fptr,"%d %d\n%s\n", set[s].imkd+1, nmsi, qPrintable(set[s].tatm) );
  }
  return true;
}

void DTXTapp::StrOptConstr::tim_change_shown( void )
{
  if( tim.empty() ) return;
  if( tim_index_shown > (int)tim.size() ) tim_index_shown = 1;

  tim[tim_index_shown-1] = tim_shown;
}

void DTXTapp::StrOptConstr::tim_update_shown( void )
{
  if( tim.empty() ){
    tim_shown = Matrix::getZero();
    return;
  }
  if( tim_index_shown > (int)tim.size() ) tim_index_shown = 1;
    
  tim_shown  = tim[tim_index_shown-1];
}

int DTXTapp::StrOptConstr::tim_size_shown( void )
{
  return (int)tim.size();
}

void DTXTapp::StrOptConstr::tim_add( void )
{
  tim.push_back( Matrix::getZero() );
  tim_index_shown = (int)tim.size();
  tim_update_shown();
}

void DTXTapp::StrOptConstr::tim_del( void )
{
  if( tim.empty() ) return;
  if( tim_index_shown > (int)tim.size() ) tim_index_shown = 1;
  tim.erase( tim.begin()+tim_index_shown-1 );
  tim_update_shown();
}


void DTXTapp::StrOptConstr::set_change_shown( void )
{
  if( set.empty() ) return;
  if( set_index_shown > (int)set.size() ) set_index_shown = 1;

  set[set_index_shown-1] = set_shown;
}

void DTXTapp::StrOptConstr::set_update_shown( void )
{
  if( set.empty() ){
    set_shown = Target();
    return;
  }
  if( set_index_shown > (int)set.size() ) set_index_shown = 1;
    
  set_shown  = set[set_index_shown-1];
}

int DTXTapp::StrOptConstr::set_size_shown( void )
{
  return (int)set.size();
}

void DTXTapp::StrOptConstr::set_add( void )
{
  set.push_back( Target() );
  set_index_shown = (int)set.size();
  set_update_shown();
}

void DTXTapp::StrOptConstr::set_del( void )
{
  if( set.empty() ) return;
  if( set_index_shown > (int)set.size() ) set_index_shown = 1;
  set.erase( set.begin()+set_index_shown-1 );
  set_update_shown();
}




DTXTapp::TraceBand::TraceBand( void )
{
  clear();
}

void DTXTapp::TraceBand::clear( void )
{
  vdistrib_mode.clear();
  vdistrib_mode.push_back("'none'");
  vdistrib_mode.push_back("'plate'");
  vdistrib_mode.push_back("'sphere'");
  idistrib_mode = findmode( vdistrib_mode, distrib_mode_def );

  output_charge = output_charge_def;
  output_wave_function = output_wave_function_def; 
  davidson_flag = davidson_flag_def; 
  davidson_number_diag = davidson_number_diag_def; 
  diag_converge = diag_converge_def; 
  distrib_band_lower = distrib_band_lower_def; 
  distrib_band_upper = distrib_band_upper_def; 
  distrib_number_sphere = distrib_number_sphere_def; 
  distrib_number_plate = distrib_number_plate_def; 
  number_band = number_band_def; 
  iaxis = iaxis_def;
  rzero = Position(rzero_def,rzero_def,rzero_def);
  rmin  = rmin_def;
  rmax  = rmin_def;
  ndiv  = ndiv_def;

  /*
  vband.clear();
  vband.push_back( band("'G'", Position(1.000,0.000,0.000), 10 ) );
  vband.push_back( band("'X'", Position(0.000,0.500,0.500),  5 ) );
  vband.push_back( band("'K'", Position(0.750,0.375,0.375), 10 ) );
  vband.push_back( band("'G'", Position(0.000,0.000,0.000), 10 ) );
  vband.push_back( band("'L'", Position(0.500,0.500,0.500), 10 ) );
  vband.push_back( band("'K'", Position(0.750,0.375,0.375),  5 ) );
  vband.push_back( band("'W'", Position(0.750,0.250,0.500),  5 ) );
  vband.push_back( band("'X'", Position(0.500,0.000,0.500),  0 ) );
  index_shown = 1;
  band_shown = vband.front();
  */
}


void DTXTapp::TraceBand::update( void )
{
}


bool DTXTapp::TraceBand::load( DTCell& cell, NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];

  int number_band_traced = 0;
  int number_trace_block = 0;
  cell.vsymmLselected.clear();

  // this is un-neccessary tag
  if( !nlb.readList("&trace_band","# trace band data") ) return true;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"distrib_mode") ){
      idistrib_mode = findmode( vdistrib_mode, value );
      distrib_mode_manual=true;;
    }
    else if( !strcasecmp(name,"output_charge") ){
      if( 1 != sscanf(value,"%d", &output_charge ) ){
	MyException::critical("broken output_charge.");
	return false;
      }
      output_charge_manual=true;;
    }
    else if( !strcasecmp(name,"output_wave_function") ){
      if( 1 != sscanf(value,"%d", &output_wave_function ) ){
	MyException::critical("broken output_wave_function.");
	return false;
      }
      output_wave_function_manual=true;;
    }
    else if( !strcasecmp(name,"davidson_flag") ){
      if( 1 != sscanf(value,"%d", &davidson_flag ) ){
	MyException::critical("broken davidson_flag.");
	return false;
      }
      davidson_flag_manual=true;;
    }
    else if( !strcasecmp(name,"davidson_number_diag") ){
      if( 1 != sscanf(value,"%d", &davidson_number_diag ) ){
	MyException::critical("broken davidson_number_diag.");
	return false;
      }
      davidson_number_diag_manual=true;;
    }
    else if( !strcasecmp(name,"diag_converge") ){
      if( 1 != sscanf(value,"%lf", &diag_converge ) ){
	MyException::critical("broken diag_converge.");
	return false;
      }
      diag_converge_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_band_lower") ){
      if( 1 != sscanf(value,"%d", &distrib_band_lower ) ){
	MyException::critical("broken distrib_band_lower.");
	return false;
      }
      distrib_band_lower_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_band_upper") ){
      if( 1 != sscanf(value,"%d", &distrib_band_upper ) ){
	MyException::critical("broken distrib_band_upper.");
	return false;
      }
      distrib_band_upper_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_number_sphere") ){
      if( 1 != sscanf(value,"%d", &distrib_number_sphere ) ){
	MyException::critical("broken distrib_number_sphere.");
	return false;
      }
      distrib_number_sphere_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_number_plate") ){
      if( 1 != sscanf(value,"%d", &distrib_number_plate ) ){
	MyException::critical("broken distrib_number_plate.");
	return false;
      }
      distrib_number_plate_manual=true;;
    }
    else if( !strcasecmp(name,"number_band") ){
      if( 1 != sscanf(value,"%d", &number_band ) ){
	MyException::critical("broken number_band.");
	return false;
      }
      number_band_manual=true;;
    }
    else if( !strcasecmp(name,"number_band_traced") ){
      if( 1 != sscanf(value,"%d", &number_band_traced ) ){
	MyException::critical("broken number_band_traced.");
	return false;
      }
      else{
	if( number_trace_block == 0 ){
	  number_trace_block = number_band_traced - 1;
	}
	else{
	  if( number_trace_block != number_band_traced - 1 ){
	    MyException::critical("broken number_band_traced.");
	    return false;
	  }
	}
      }
    }
    else if( !strcasecmp(name,"number_trace_block") ){
      if( 1 != sscanf(value,"%d", &number_trace_block ) ){
	MyException::critical("broken number_trace_block.");
	return false;
      }
      else{
	if( number_band_traced == 0 ){
	  number_band_traced = number_trace_block + 1;
	}
	else{
	  if( number_band_traced != number_trace_block + 1 ){
	    MyException::critical("broken number_trace_block.");
	    return false;
	  }
	}
      }
    }
    else{
      MyException::warning("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  if( number_band_traced>0 && number_band_traced != number_trace_block+1 ){
    MyException::critical("broken number_band_traced and number_trace_block.");
    return false;
  }
  cell.vsymmLselected.resize(number_trace_block);
  cell.vsymmLselected_loaded = true;

  if( nlb.readExtra(buf) ){
    char* ptr = buf;
    int   offset;
    char svalue[32];

    for( int i=0; i<number_band_traced; i++ ){
      if( 1 == sscanf(ptr, " '%[^']'%n", svalue, &offset ) ||
	  1 == sscanf(ptr, " %s%n", svalue, &offset ) ){
	ptr += offset;
	if( i+1<number_band_traced ){
	  cell.vsymmLselected[i].labelPs = svalue;
	}
	if( i>0 ){
	  cell.vsymmLselected[i-1].labelPe = svalue;
	}
      }
      else{
	MyException::critical("broken vband nkpt.");
	return false;
      }
    }
  }
  else{
    return false;
  }

  if( nlb.readExtra(buf) && change_exp_format(buf) ){
    char* ptr = buf;
    int   offset;
    double x;

    for( int i=0; i<number_band_traced; i++ ){
      if( 1 == sscanf(ptr, "%le%n", &x, &offset ) ){
	ptr += offset;
	if( i+1<number_band_traced ){
	  cell.vsymmLselected[i].positions.x = x;
	}
	if( i>0 ){
	  cell.vsymmLselected[i-1].positione.x = x;
	}
      }
      else{
	MyException::critical("broken vband ak x.");
	return false;
      }
    }
  }
  else{
    return false;
  }

  if( nlb.readExtra(buf) && change_exp_format(buf) ){
    char* ptr = buf;
    int   offset;
    double y;

    for( int i=0; i<number_band_traced; i++ ){
      if( 1 == sscanf(ptr, "%le%n", &y, &offset ) ){
	ptr += offset;
	if( i+1<number_band_traced ){
	  cell.vsymmLselected[i].positions.y = y;
	}
	if( i>0 ){
	  cell.vsymmLselected[i-1].positione.y = y;
	}
      }
      else{
	MyException::critical("broken vband ak y.");
	return false;
      }
    }
  }
  else{
    return false;
  }



  if( nlb.readExtra(buf) && change_exp_format(buf) ){
    char* ptr = buf;
    int   offset;
    double z;

    for( int i=0; i<number_band_traced; i++ ){
      if( 1 == sscanf(ptr, "%le%n", &z, &offset ) ){
	ptr += offset;
	if( i+1<number_band_traced ){
	  cell.vsymmLselected[i].positions.z = z;
	}
	if( i>0 ){
	  cell.vsymmLselected[i-1].positione.z = z;
	}
      }
      else{
	MyException::critical("broken vband ak z.");
	return false;
      }
    }
  }
  else{
    return false;
  }

  if( nlb.readExtra(buf) && change_exp_format(buf) ){
    char* ptr = buf;
    int   offset;
    int   npoint;

    for( int i=0; i<number_trace_block; i++ ){
      if( 1 == sscanf(ptr, "%d%n", &npoint, &offset ) ){
	ptr += offset;
	cell.vsymmLselected[i].npoint = npoint;
	if( i+1==number_trace_block ){
	  cell.vsymmLselected[i+1].npoint = 0;
	}
      }
      else{
	MyException::critical("broken vband ak nkfi.");
	return false;
      }
    }
  }
  else{
    return false;
  }

  // delete jump
  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    if( cell.vsymmLselected[i].labelPs 
	== cell.vsymmLselected[i].labelPe ){
      cell.vsymmLselected.erase( cell.vsymmLselected.begin()+i );
    } 
  }

  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	4 == sscanf(buf, "%d %le %le %d",
		    &iaxis, &rmin, &rmax, &ndiv ) ){
    }
    else{
      MyException::critical("broken iaxis rmin rmax ndiv.");
      return false;
    }
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	6 == sscanf(buf, "%le %le %le %le %le %d",
		    &rzero.x, &rzero.y, &rzero.z,
		    &rmin, &rmax, &ndiv ) ){
    }
    else{
      MyException::critical("broken rzero_x rzero_y rzero_z rmin rmax ndiv.");
      return false;
    }
  }
  else{
    return false;
  }

  return true;
}

bool DTXTapp::TraceBand::save( const DTCell& cell, FILE* fptr )
{
  fprintf(fptr, "# trace band data\n");
  fprintf(fptr, "&trace_band\n");
  if( TraceBand::distrib_mode_manual ){
    fprintf(fptr, "  distrib_mode = %s\n", qPrintable(vdistrib_mode[idistrib_mode]) );
  }
  if( TraceBand::output_charge_manual ){
    fprintf(fptr, "  output_charge = %d\n", output_charge );
  }
  if( TraceBand::output_wave_function_manual ){
    fprintf(fptr, "  output_wave_function = %d\n", output_wave_function );
  }
  if( TraceBand::davidson_flag_manual ){
    fprintf(fptr, "  davidson_flag = %d\n", davidson_flag );
  }
  if( TraceBand::davidson_number_diag_manual ){
    fprintf(fptr, "  davidson_number_diag = %d\n", davidson_number_diag );
  }
  if( TraceBand::diag_converge_manual ){
    fprintf(fptr, "  diag_converge = %e\n", diag_converge );
  }
  if( TraceBand::distrib_band_lower_manual ){
    fprintf(fptr, "  distrib_band_lower = %d\n", distrib_band_lower );
  }
  if( TraceBand::distrib_band_upper_manual ){
    fprintf(fptr, "  distrib_band_upper = %d\n", distrib_band_upper );
  }

  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    if( TraceBand::distrib_number_plate_manual ){
      fprintf(fptr, "  distrib_number_plate = %d\n", distrib_number_plate );
    }
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    if( TraceBand::distrib_number_sphere_manual ){
      fprintf(fptr, "  distrib_number_sphere = %d\n", distrib_number_sphere );
    }
  }

  if( TraceBand::number_band_manual ){
    fprintf(fptr, "  number_band = %d\n", number_band );
  }

  Position last;
  int number_band_traced;
  int number_trace_block;
  {
    number_band_traced = 0;
    for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
      const BrillouinSegment& symmL = cell.vsymmLselected[i];

      if( i==0 ){
	number_band_traced++;
	number_band_traced++;
      }
      else{
	if( last != symmL.positions ){
	  number_band_traced++;
	}
	number_band_traced++;
      }
      last = symmL.positione;
    }
    number_trace_block = number_band_traced-1;
    if( number_trace_block>0 ){
      fprintf(fptr, "  number_band_traced = %d\n", number_band_traced );
      fprintf(fptr, "  number_trace_block = %d\n", number_trace_block );
    }
  }
  fprintf(fptr, "/\n");


  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = cell.vsymmLselected[i];

    if( i==0 ){
      fprintf(fptr, "%-5s ", qPrintable(("'"+symmL.labelPs+"'")) ); 
      fprintf(fptr, "%-5s ", qPrintable(("'"+symmL.labelPe+"'")) ); 
    }
    else{
      if( last != symmL.positions ){
	fprintf(fptr, "%-5s ", qPrintable(("'"+symmL.labelPs+"'")) ); 
      }
      fprintf(fptr, "%-5s ", qPrintable(("'"+symmL.labelPe+"'")) ); 
    }
    last = symmL.positione;
  }
  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, "# nkpt(1:nbk+1)\n");
  }

  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = cell.vsymmLselected[i];

    if( i==0 ){
      fprintf(fptr, "%5.3f ", symmL.positions.x ); 
      fprintf(fptr, "%5.3f ", symmL.positione.x ); 
    }
    else{
      if( last != symmL.positions ){
	fprintf(fptr, "%5.3f ", symmL.positions.x ); 
      }
      fprintf(fptr, "%5.3f ", symmL.positione.x ); 
    }
    last = symmL.positione;
  }
  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, "# ak(1,1:nbk+1)\n");
  }

  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = cell.vsymmLselected[i];

    if( i==0 ){
      fprintf(fptr, "%5.3f ", symmL.positions.y ); 
      fprintf(fptr, "%5.3f ", symmL.positione.y ); 
    }
    else{
      if( last != symmL.positions ){
	fprintf(fptr, "%5.3f ", symmL.positions.y ); 
      }
      fprintf(fptr, "%5.3f ", symmL.positione.y ); 
    }
    last = symmL.positione;
  }
  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, "# ak(2,1:nbk+1)\n");
  }

  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = cell.vsymmLselected[i];

    if( i==0 ){
      fprintf(fptr, "%5.3f ", symmL.positions.z ); 
      fprintf(fptr, "%5.3f ", symmL.positione.z ); 
    }
    else{
      if( last != symmL.positions ){
	fprintf(fptr, "%5.3f ", symmL.positions.z ); 
      }
      fprintf(fptr, "%5.3f ", symmL.positione.z ); 
    }
    last = symmL.positione;
  }
  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, "# ak(3,1:nbk+1)\n");
  }


  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, "     ");
  }
  for( int i=0; i<(int)cell.vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = cell.vsymmLselected[i];

    if( i==0 ){
      fprintf(fptr, "%-5d ", symmL.npoint ); 
    }
    else{
      if( last != symmL.positions ){
	fprintf(fptr, "%-5d ", 0 );
      }
      fprintf(fptr, "%-5d ", symmL.npoint );
    }
    last = symmL.positione;
  }
  if( !cell.vsymmLselected.empty() ){
    fprintf(fptr, " # nkfi(1:nbk)\n");
  }


  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    fprintf(fptr, "%d %f %f %d # iaxis, rmin, rmax, ndiv\n",
	    iaxis, rmin, rmax, ndiv );
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    fprintf(fptr, "%f %f %f %f %f %d "
	    "# rzero(1:3) rmin rmax ndiv\n",
	    rzero.x, rzero.y, rzero.z, rmin, rmax, ndiv );
  }

  return true;
}



DTXTapp::InspectWfn::InspectWfn( void )
{
  clear();
}

void DTXTapp::InspectWfn::clear( void )
{
  vdistrib_mode.clear();
  vdistrib_mode.push_back("'none'");
  vdistrib_mode.push_back("'pdos'");
  vdistrib_mode.push_back("'plate'");
  vdistrib_mode.push_back("'sphere'");
  idistrib_mode = findmode( vdistrib_mode, distrib_mode_def );

  output_charge = output_charge_def;
  distrib_band_lower = distrib_band_lower_def; 
  distrib_band_upper = distrib_band_upper_def; 
  distrib_number_sphere = distrib_number_sphere_def; 
  distrib_number_plate = distrib_number_plate_def; 
  pdos_target_atom = pdos_target_atom_def;
  iaxis = iaxis_def;
  rzero = Position(rzero_def,rzero_def,rzero_def);
  rmin  = rmin_def;
  rmax  = rmin_def;
  ndiv  = ndiv_def;
}


void DTXTapp::InspectWfn::update( void )
{
}


bool DTXTapp::InspectWfn::load( NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];

  // this is un-neccessary tag
  if( !nlb.readList("&inspect_wfn","# inspect wfn data") ) return true;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"distrib_mode") ){
      idistrib_mode = findmode( vdistrib_mode, value );
      distrib_mode_manual=true;;
    }
    else if( !strcasecmp(name,"output_charge") ){
      if( 1 != sscanf(value,"%d", &output_charge ) ){
	MyException::critical("broken output_charge.");
	return false;
      }
      output_charge_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_band_lower") ){
      if( 1 != sscanf(value,"%d", &distrib_band_lower ) ){
	MyException::critical("broken distrib_band_lower.");
	return false;
      }
      distrib_band_lower_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_band_upper") ){
      if( 1 != sscanf(value,"%d", &distrib_band_upper ) ){
	MyException::critical("broken distrib_band_upper.");
	return false;
      }
      distrib_band_upper_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_number_sphere") ){
      if( 1 != sscanf(value,"%d", &distrib_number_sphere ) ){
	MyException::critical("broken distrib_number_sphere.");
	return false;
      }
      distrib_number_sphere_manual=true;;
    }
    else if( !strcasecmp(name,"distrib_number_plate") ){
      if( 1 != sscanf(value,"%d", &distrib_number_plate ) ){
	MyException::critical("broken distrib_number_plate.");
	return false;
      }
      distrib_number_plate_manual=true;;
    }
    else if( !strcasecmp(name,"pdos_target_atom") ){
      if( 1 != sscanf(value,"%d", &pdos_target_atom ) ){
	MyException::critical("broken pdos_target_atom.");
	return false;
      }
      pdos_target_atom_manual=true;;
    }
    else{
      MyException::warning("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'pdos'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	4 == sscanf(buf, "%d %le %le %d",
		    &iaxis, &rmin, &rmax, &ndiv ) ){
    }
    else{
      return false;
    }
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	6 == sscanf(buf, "%le %le %le %le %le %d",
		    &rzero.x, &rzero.y, &rzero.z,
		    &rmin, &rmax, &ndiv ) ){
    }
    else{
      return false;
    }
  }
  else{
    return false;
  }

  return true;
}

bool DTXTapp::InspectWfn::save( FILE* fptr )
{
  fprintf(fptr, "# inspect wfn data\n");
  fprintf(fptr, "&inspect_wfn\n");
  if( InspectWfn::distrib_mode_manual ){
    fprintf(fptr, "  distrib_mode = %s\n", qPrintable(vdistrib_mode[idistrib_mode]) );
  }
  if( InspectWfn::output_charge_manual ){
    fprintf(fptr, "  output_charge = %d\n", output_charge );
  }
  if( InspectWfn::distrib_band_lower_manual ){
    fprintf(fptr, "  distrib_band_lower = %d\n", distrib_band_lower );
  }
  if( InspectWfn::distrib_band_upper_manual ){
    fprintf(fptr, "  distrib_band_upper = %d\n", distrib_band_upper );
  }

  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    if( InspectWfn::distrib_number_plate_manual ){
      fprintf(fptr, "  distrib_number_plate = %d\n", distrib_number_plate );
    }
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    if( InspectWfn::distrib_number_sphere_manual ){
      fprintf(fptr, "  distrib_number_sphere = %d\n", distrib_number_sphere );
    }
  }

  if( InspectWfn::pdos_target_atom_manual ){
    fprintf(fptr, "  pdos_target_atom = %d\n", pdos_target_atom );
  }
  fprintf(fptr, "/\n");

  if( false );
  else if( vdistrib_mode[idistrib_mode] == "'none'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'pdos'" ){
  }
  else if( vdistrib_mode[idistrib_mode] == "'plate'" ){
    fprintf(fptr, "%d %f %f %d # iaxis, rmin, rmax, ndiv\n",
	    iaxis, rmin, rmax, ndiv );
  }
  else if( vdistrib_mode[idistrib_mode] == "'sphere'" ){
    fprintf(fptr, "%f %f %f %f %f %d "
	    "# rzero(1:3) rmin rmax ndiv\n",
	    rzero.x, rzero.y, rzero.z, rmin, rmax, ndiv );
  }

  return true;
}

DTXTapp::StmInput::StmInput( void )
{
  clear();
}

void DTXTapp::StmInput::clear( void )
{
  stm_fermi_energy = stm_fermi_energy_def;
  vs.clear();
  vs.push_back( vs_def );
  index_shown = 1;
  vs_shown = vs.front();
}


void DTXTapp::StmInput::update( void )
{
}

bool DTXTapp::StmInput::load( NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];
  int number_bias;

  // this is un-neccessary tag
  if( !nlb.readList("&stminput","# stm data") ) return true;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"number_bias") ){
      if( 1 != sscanf(value,"%d", &number_bias ) ){
	MyException::critical("broken number_bias.");
	return false;
      }
    }
    else if( !strcasecmp(name,"stm_fermi_energy") ){
      if( 1 != sscanf(value,"%lf", &stm_fermi_energy ) ){
	MyException::critical("broken stm_fermi_energy.");
	return false;
      }
      stm_fermi_energy_manual=true;;
    }
    else{
      MyException::critical("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  vs.resize(number_bias);
  for( int i=0; i<number_bias; i++ ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	1 == sscanf(buf, "%le", &vs[i] ) ){
    }
    else{
      return false;
    }
  }

  return true;
}

bool DTXTapp::StmInput::save( FILE* fptr )
{
  fprintf(fptr, "# stm data\n");
  fprintf(fptr, "&stminput\n");
  fprintf(fptr, "  number_bias = %d\n", (int)vs.size() );
  if( StmInput::stm_fermi_energy_manual ){
    fprintf(fptr, "  stm_fermi_energy = %20.15e\n", stm_fermi_energy );
  }
  fprintf(fptr, "/\n");

  for( int i=0; i<(int)vs.size(); i++ ){
    fprintf(fptr,"%f\n", vs[i] );
  }

  return true;
}

void DTXTapp::StmInput::add( void )
{
  vs.push_back( vs.back() );
  index_shown = (int)vs.size();
  update_shown();
}

void DTXTapp::StmInput::del( void )
{
  if( (int)vs.size()<=1 ) return;
  if( index_shown > (int)vs.size() ) index_shown = 1;
  vs.erase( vs.begin()+index_shown-1 );
  update_shown();
}

void DTXTapp::StmInput::change_shown( void )
{
  if( vs.empty() ) return;
  if( index_shown > (int)vs.size() ) index_shown = 1;

  vs[index_shown-1] = vs_shown;
}

void DTXTapp::StmInput::update_shown( void )
{
  if( vs.empty() ) return;
  if( index_shown > (int)vs.size() ) index_shown = 1;
    
  vs_shown  = vs[index_shown-1];
}

int DTXTapp::StmInput::size_shown( void )
{
  return (int)vs.size();
}




DTXTapp::MolDyn::MolDyn( void )
{
  clear();
}

void DTXTapp::MolDyn::clear( void )
{
  vmd_mode.clear();
  vmd_mode.push_back("'NVE'");
  vmd_mode.push_back("'NPT_ST'");
  vmd_mode.push_back("'MBMT_ST'");
  imd_mode = findmode( vmd_mode, md_mode_def );

  delta_time = delta_time_def;
  init_md_step = init_md_step_def;
  end_md_step = end_md_step_def;
  mode_xtrap_rho_wfn = mode_xtrap_rho_wfn_def;
  message_cycle = message_cycle_def;
  system_volume = system_volume_def;
  system_kbt = system_kbt_def;
  system_pressure = system_pressure_def;
  stern_omega_zeta = stern_omega_zeta_def;
  stern_omega_eta = stern_omega_eta_def;
  stern_zeta = stern_zeta_def;
  stern_eta = stern_eta_def;
  stern_sigma = stern_sigma_def;
  abinitio_cycle = abinitio_cycle_def;
}


void DTXTapp::MolDyn::update( void )
{
}

bool DTXTapp::MolDyn::load( DTAtoms& atoms, NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];

  // this is un-neccessary tag
  if( !nlb.readList("&mol_dyn","# md data") ) return true;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"mdmode") ){
      imd_mode = findmode( vmd_mode, value );
      md_mode_manual=true;;
    }
    else if( !strcasecmp(name,"delta_time") ){
      if( 1 != sscanf(value,"%lf", &delta_time ) ){
	MyException::critical("broken delta_time.");
	return false;
      }
      delta_time_manual=true;;
    }
    else if( !strcasecmp(name,"init_md_step") ){
      if( 1 != sscanf(value,"%d", &init_md_step ) ){
	MyException::critical("broken init_md_step.");
	return false;
      }
      init_md_step_manual=true;;
    }
    else if( !strcasecmp(name,"end_md_step") ){
      if( 1 != sscanf(value,"%d", &end_md_step ) ){
	MyException::critical("broken end_md_step.");
	return false;
      }
      end_md_step_manual=true;;
    }
    else if( !strcasecmp(name,"mode_xtrap_rho_wfn") ){
      if( 1 != sscanf(value,"%d", &mode_xtrap_rho_wfn ) ){
	MyException::critical("broken mode_xtrap_rho_wfn.");
	return false;
      }
      mode_xtrap_rho_wfn_manual=true;;
    }
    else if( !strcasecmp(name,"message_cycle") ){
      if( 1 != sscanf(value,"%d", &message_cycle ) ){
	MyException::critical("broken message_cycle.");
	return false;
      }
      message_cycle_manual=true;;
    }
    else if( !strcasecmp(name,"system_volume") ){
      if( 1 != sscanf(value,"%lf", &system_volume ) ){
	MyException::critical("broken system_volume.");
	return false;
      }
      system_volume_manual=true;;
    }
    else if( !strcasecmp(name,"system_kbt") ){
      if( 1 != sscanf(value,"%lf", &system_kbt ) ){
	MyException::critical("broken system_kbt.");
	return false;
      }
      system_kbt_manual=true;;
    }
    else if( !strcasecmp(name,"system_pressure") ){
      if( 1 != sscanf(value,"%lf", &system_pressure ) ){
	MyException::critical("broken system_pressure.");
	return false;
      }
      system_pressure_manual=true;;
    }
    else if( !strcasecmp(name,"stern_omega_zeta") ){
      if( 1 != sscanf(value,"%lf", &stern_omega_zeta ) ){
	MyException::critical("broken stern_omega_zeta.");
	return false;
      }
      stern_omega_zeta_manual=true;;
    }
    else if( !strcasecmp(name,"stern_omega_eta") ){
      if( 1 != sscanf(value,"%lf", &stern_omega_eta ) ){
	MyException::critical("broken stern_omega_eta.");
	return false;
      }
      stern_omega_eta_manual=true;;
    }
    else if( !strcasecmp(name,"stern_zeta") ){
      if( 1 != sscanf(value,"%lf", &stern_zeta ) ){
	MyException::critical("broken stern_zeta.");
	return false;
      }
      stern_zeta_manual=true;;
    }
    else if( !strcasecmp(name,"stern_eta") ){
      if( 1 != sscanf(value,"%lf", &stern_eta ) ){
	MyException::critical("broken stern_eta.");
	return false;
      }
      stern_eta_manual=true;;
    }
    else if( !strcasecmp(name,"stern_sigma") ){
      if( 1 != sscanf(value,"%lf", &stern_sigma ) ){
	MyException::critical("broken stern_sigma.");
	return false;
      }
      stern_sigma_manual=true;;
    }
    else if( !strcasecmp(name,"abinitio_cycle") ){
      if( 1 != sscanf(value,"%d", &abinitio_cycle ) ){
	MyException::critical("broken abinitio_cycle.");
	return false;
      }
      abinitio_cycle_manual=true;;
    }
  }

  for( int i=0; i<(int)atoms.velement.size(); i++ ){
    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	1 == sscanf(buf, "%le", &atoms.velement[i].mass ) ){
    }
    else{
      MyException::critical("broken atomic mass.");
      return false;
    }
  }

  for( int i=0; i<(int)atoms.vatom.size(); i++ ){
    if( atoms.vatom[i].isCopy() ) continue; // Rs[q
    //    if( atoms.vatom[i].element == 0 ) continue; // _~[q

    if( nlb.readExtra(buf) && change_exp_format(buf) &&
	3 == sscanf(buf, "%le %le %le",
		    &atoms.vatom[i].velocity.x,
		    &atoms.vatom[i].velocity.y,
		    &atoms.vatom[i].velocity.z ) ){
    }
    else{
      MyException::critical("broken atomic velocity.");
      return false;
    }
  }

  return true;
}


bool DTXTapp::MolDyn::save( const DTAtoms& atoms, FILE* fptr )
{
  fprintf(fptr, "# md data\n");
  fprintf(fptr, "&mol_dyn\n");
  if( MolDyn::md_mode_manual ){
    fprintf(fptr, "  mdmode = %s\n", qPrintable(vmd_mode[imd_mode]) );
  }
  if( MolDyn::delta_time_manual ){
    fprintf(fptr, "  delta_time = %f\n", delta_time );
  }
  if( MolDyn::init_md_step_manual ){
    fprintf(fptr, "  init_md_step = %d\n", init_md_step );
  }
  if( MolDyn::end_md_step_manual ){
    fprintf(fptr, "  end_md_step = %d\n", end_md_step );
  }
  if( MolDyn::mode_xtrap_rho_wfn_manual ){
    fprintf(fptr, "  mode_xtrap_rho_wfn = %d\n", mode_xtrap_rho_wfn );
  }
  if( MolDyn::message_cycle_manual ){
    fprintf(fptr, "  message_cycle = %d\n", message_cycle );
  }
  if( MolDyn::system_volume_manual ){
    fprintf(fptr, "  system_volume = %f\n", system_volume );
  }
  if( MolDyn::system_kbt_manual ){
    fprintf(fptr, "  system_kbt = %20.15e\n", system_kbt );
  }
  if( MolDyn::system_pressure_manual ){
    fprintf(fptr, "  system_pressure = %e\n", system_pressure );
  }
  if( MolDyn::stern_omega_zeta_manual ){
    fprintf(fptr, "  stern_omega_zeta = %e\n", stern_omega_zeta );
  }
  if( MolDyn::stern_omega_eta_manual ){
    fprintf(fptr, "  stern_omega_eta = %e\n", stern_omega_eta );
  }
  if( MolDyn::stern_zeta_manual ){
    fprintf(fptr, "  stern_zeta = %e\n", stern_zeta );
  }
  if( MolDyn::stern_eta_manual ){
    fprintf(fptr, "  stern_eta = %e\n", stern_eta );
  }
  if( MolDyn::stern_sigma_manual ){
    fprintf(fptr, "  stern_sigma = %e\n", stern_sigma );
  }
  if( MolDyn::abinitio_cycle_manual ){
    fprintf(fptr, "  abinitio_cycle = %d\n", abinitio_cycle );
  }
  fprintf(fptr, "/\n");

  for( int i=0; i<(int)atoms.velement.size(); i++ ){
    fprintf(fptr,"%f\n", atoms.velement[i].mass );
  }

  for( int i=0; i<(int)atoms.vatom.size(); i++ ){
    if( atoms.vatom[i].isCopy() ) continue; // Rs[q
    //    if( atoms.vatom[i].element == 0 ) continue; // _~[q

    fprintf(fptr,"%e %e %e\n",
	    atoms.vatom[i].velocity.x,
	    atoms.vatom[i].velocity.y,
	    atoms.vatom[i].velocity.z );
  }

  return true;
}

//----------------------------------------------------
DTXTapp::Filemap::Filemap( void )
{
  clear();
}

void DTXTapp::Filemap::clear( void )
{
  basename = basename_def;
}

void DTXTapp::Filemap::update( void )
{
}

bool DTXTapp::Filemap::load( DTLattice& lattice, NameListBuffer& nlb )
{
  char name[1024], value[1024];
  char buf[1024];
  char svalue[32];
  char svalue1[32], svalue2[32];
  int  ivalue;

  // this is un-neccessary tag
  if( !nlb.readList("&filemap","# file map data") ) return true;

  while( nlb.getVariable(name,value) ){
    if( false );
    else if( !strcasecmp(name,"basename") ){
      if( 1 == sscanf(value,"%*[']%[^']", svalue ) ){
	basename = QString(svalue);
      }
      else if( 1 == sscanf(value,"%s", svalue ) ){
	basename = QString(svalue);
      }
      else{
	MyException::critical("broken basename.");
	return false;
      }
    }
    else if( !strcasecmp( name,"number_PP_file") ){
      if( 1 != sscanf(value,"%d", &ivalue ) ){
	MyException::critical("broken number_PP_file.");
	return false;
      }
    }
    else{
      MyException::critical("unknown parameter:"+QString(name) );
      //      return true;
    }
  }

  vector<DTElement>& velement = lattice.getData().velement;

  if( (int)velement.size() != ivalue ){
    MyException::critical("broken number_PP_file.");
  }

  for( int e=0; e<(int)velement.size(); e++ ){
    if( nlb.readExtra(buf) &&
	2 == sscanf(buf, " %s %s", svalue1, svalue2 ) ){
      velement[e].file_pseudo = QString(svalue1);
      velement[e].file_charge = QString(svalue2);
    }
    else{
      MyException::critical("broken pseudo/charge file in bandmap.");
    }
  }

  return true;
}

bool DTXTapp::Filemap::save( const DTLattice& lattice, FILE* fptr )
{
  const vector<DTElement>& velement = lattice.getData().velement;

  fprintf(fptr, "# file map data\n");
  fprintf(fptr, "&filemap\n");
  fprintf(fptr, "  basename = '%s'\n", qPrintable(basename) );
  fprintf(fptr, "  number_PP_file = %d\n", (int)velement.size() );
  fprintf(fptr, "/\n");
  for( int e=0; e<(int)velement.size(); e++ ){
    fprintf(fptr, " %s %s\n",
	    qPrintable(velement[e].file_pseudo),
	    qPrintable(velement[e].file_charge) );
  }

  return true;
}

//----------------------------------------------------
DTXTapp::DTXTapp( void )
{
  loadDefaults();
  clear();
}

void DTXTapp::update( void )
{
  tappinput.update();
  atoms.update();
  symmetry.update();
  smplkpt.update();
  structopt.update();
  stroptconstr.update();
  traceband.update();
  inspectwfn.update();
  stminput.update();
  moldyn.update();
  filemap.update();
}

void DTXTapp::clear( void )
{
  tappinput.clear();
  atoms.clear();
  symmetry.clear();
  smplkpt.clear();
  structopt.clear();
  stroptconstr.clear();
  traceband.clear();
  inspectwfn.clear();
  stminput.clear();
  moldyn.clear();
  filemap.clear();
}

bool DTXTapp::loadDefaults( void )
{
  QDomDocument doc;

  if( !XML::load( doc, "defaults.qtml") ) return false;

  QDomNode root = XML::getRoot(doc);
  root = XML::getFirstElementByTagName(root,"xTAPP");

  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"TappInput");

    node  = XML::getFirstElementByTagName(group,"number_spin");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::number_spin_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::number_spin_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::number_spin_max );
    TappInput::number_spin_bal = XML::getAttribute(node,"balloon");
    TappInput::number_spin_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::number_spin_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"spin_mode");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::spin_mode_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::spin_mode_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::spin_mode_max );
    TappInput::spin_mode_bal = XML::getAttribute(node,"balloon");
    TappInput::spin_mode_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::spin_mode_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_local_potential");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_local_potential_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_local_potential_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_local_potential_max );
    TappInput::cutoff_local_potential_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_local_potential_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_local_potential_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_wave_function");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_wave_function_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_wave_function_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_wave_function_max );
    TappInput::cutoff_wave_function_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_wave_function_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_wave_function_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_uspp_q");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_uspp_q_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_uspp_q_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_uspp_q_max );
    TappInput::cutoff_uspp_q_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_uspp_q_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_uspp_q_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"xtrap_beta");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::xtrap_beta_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::xtrap_beta_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::xtrap_beta_max );
    TappInput::xtrap_beta_bal = XML::getAttribute(node,"balloon");
    TappInput::xtrap_beta_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::xtrap_beta_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_btp_a");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_btp_a_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_btp_a_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_btp_a_max );
    TappInput::cutoff_btp_a_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_btp_a_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_btp_a_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_btp_gc");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_btp_gc_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_btp_gc_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_btp_gc_max );
    TappInput::cutoff_btp_gc_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_btp_gc_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_btp_gc_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_btp_sigma");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_btp_sigma_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_btp_sigma_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_btp_sigma_max );
    TappInput::cutoff_btp_sigma_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_btp_sigma_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_btp_sigma_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"number_band");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::number_band_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::number_band_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::number_band_max );
    TappInput::number_band_bal = XML::getAttribute(node,"balloon");
    TappInput::number_band_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::number_band_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"extra_charge");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::extra_charge_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::extra_charge_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::extra_charge_max );
    TappInput::extra_charge_bal = XML::getAttribute(node,"balloon");
    TappInput::extra_charge_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::extra_charge_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"diff_spin");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::diff_spin_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::diff_spin_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::diff_spin_max );
    TappInput::diff_spin_bal = XML::getAttribute(node,"balloon");
    TappInput::diff_spin_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::diff_spin_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"elec_kbt");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::elec_kbt_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::elec_kbt_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::elec_kbt_max );
    TappInput::elec_kbt_bal = XML::getAttribute(node,"balloon");
    TappInput::elec_kbt_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::elec_kbt_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"number_xtrap_stage");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::number_xtrap_stage_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::number_xtrap_stage_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::number_xtrap_stage_max );
    TappInput::number_xtrap_stage_bal = XML::getAttribute(node,"balloon");
    TappInput::number_xtrap_stage_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::number_xtrap_stage_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"initial_wfn");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::initial_wfn_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::initial_wfn_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::initial_wfn_max );
    TappInput::initial_wfn_bal = XML::getAttribute(node,"balloon");
    TappInput::initial_wfn_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::initial_wfn_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"initial_lpt");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::initial_lpt_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::initial_lpt_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::initial_lpt_max );
    TappInput::initial_lpt_bal = XML::getAttribute(node,"balloon");
    TappInput::initial_lpt_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::initial_lpt_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"store_wfn");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::store_wfn_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::store_wfn_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::store_wfn_max );
    TappInput::store_wfn_bal = XML::getAttribute(node,"balloon");
    TappInput::store_wfn_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::store_wfn_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"chain_calc");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::chain_calc_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::chain_calc_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::chain_calc_max );
    TappInput::chain_calc_bal = XML::getAttribute(node,"balloon");
    TappInput::chain_calc_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::chain_calc_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"scf_converge");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::scf_converge_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::scf_converge_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::scf_converge_max );
    TappInput::scf_converge_bal = XML::getAttribute(node,"balloon");
    TappInput::scf_converge_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::scf_converge_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"scf_converge_energy");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::scf_converge_energy_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::scf_converge_energy_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::scf_converge_energy_max );
    TappInput::scf_converge_energy_bal = XML::getAttribute(node,"balloon");
    TappInput::scf_converge_energy_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::scf_converge_energy_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"scf_number_iter_1st");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::scf_number_iter_1st_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::scf_number_iter_1st_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::scf_number_iter_1st_max );
    TappInput::scf_number_iter_1st_bal = XML::getAttribute(node,"balloon");
    TappInput::scf_number_iter_1st_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::scf_number_iter_1st_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"scf_number_iter");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::scf_number_iter_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::scf_number_iter_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::scf_number_iter_max );
    TappInput::scf_number_iter_bal = XML::getAttribute(node,"balloon");
    TappInput::scf_number_iter_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::scf_number_iter_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"davidson_flag");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::davidson_flag_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::davidson_flag_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::davidson_flag_max );
    TappInput::davidson_flag_bal = XML::getAttribute(node,"balloon");
    TappInput::davidson_flag_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::davidson_flag_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"davidson_number_diag_1st");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::davidson_number_diag_1st_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::davidson_number_diag_1st_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::davidson_number_diag_1st_max );
    TappInput::davidson_number_diag_1st_bal = XML::getAttribute(node,"balloon");
    TappInput::davidson_number_diag_1st_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::davidson_number_diag_1st_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"davidson_number_diag");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::davidson_number_diag_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::davidson_number_diag_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::davidson_number_diag_max );
    TappInput::davidson_number_diag_bal = XML::getAttribute(node,"balloon");
    TappInput::davidson_number_diag_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::davidson_number_diag_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"control_uptime");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::control_uptime_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::control_uptime_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::control_uptime_max );
    TappInput::control_uptime_bal = XML::getAttribute(node,"balloon");
    TappInput::control_uptime_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::control_uptime_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_bspl_fit");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_bspl_fit_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_bspl_fit_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_bspl_fit_max );
    TappInput::cutoff_bspl_fit_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_bspl_fit_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_bspl_fit_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"control_q_han_win_fac");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::control_q_han_win_fac_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::control_q_han_win_fac_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::control_q_han_win_fac_max );
    TappInput::control_q_han_win_fac_bal = XML::getAttribute(node,"balloon");
    TappInput::control_q_han_win_fac_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::control_q_han_win_fac_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"control_nbsf");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::control_nbsf_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::control_nbsf_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::control_nbsf_max );
    TappInput::control_nbsf_bal = XML::getAttribute(node,"balloon");
    TappInput::control_nbsf_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::control_nbsf_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"xc_type");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &TappInput::xc_type_def );
    TappInput::xc_type_bal = XML::getAttribute(node,"balloon");
    TappInput::xc_type_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::xc_type_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_exch_att_rc");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_exch_att_rc_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_exch_att_rc_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_exch_att_rc_max );
    TappInput::cutoff_exch_att_rc_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_exch_att_rc_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_exch_att_rc_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_exch_att_rd");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::cutoff_exch_att_rd_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::cutoff_exch_att_rd_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::cutoff_exch_att_rd_max );
    TappInput::cutoff_exch_att_rd_bal = XML::getAttribute(node,"balloon");
    TappInput::cutoff_exch_att_rd_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::cutoff_exch_att_rd_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"scf_threshold_hybrid");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TappInput::scf_threshold_hybrid_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TappInput::scf_threshold_hybrid_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TappInput::scf_threshold_hybrid_max );
    TappInput::scf_threshold_hybrid_bal = XML::getAttribute(node,"balloon");
    TappInput::scf_threshold_hybrid_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::scf_threshold_hybrid_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"compat_old_squ_norm");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TappInput::compat_old_squ_norm_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TappInput::compat_old_squ_norm_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TappInput::compat_old_squ_norm_max );
    TappInput::compat_old_squ_norm_bal = XML::getAttribute(node,"balloon");
    TappInput::compat_old_squ_norm_expert = XML::getAttribute(node,"expert") == "enable";
    TappInput::compat_old_squ_norm_manual = XML::getAttribute(node,"auto") == "enable";
  }

  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"Symmetry");

    node  = XML::getFirstElementByTagName(group,"symmetry_format");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &Symmetry::symmetry_format_def );
    Symmetry::symmetry_format_bal = XML::getAttribute(node,"balloon");
    Symmetry::symmetry_format_expert = XML::getAttribute(node,"expert") == "enable";
    Symmetry::symmetry_format_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"SmplKpt");

    node  = XML::getFirstElementByTagName(group,"dos_mode");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &SmplKpt::dos_mode_def );
    SmplKpt::dos_mode_bal = XML::getAttribute(node,"balloon");
    SmplKpt::dos_mode_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::dos_mode_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"dos_band_lower");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::dos_band_lower_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::dos_band_lower_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::dos_band_lower_max );
    SmplKpt::dos_band_lower_bal = XML::getAttribute(node,"balloon");
    SmplKpt::dos_band_lower_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::dos_band_lower_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"dos_band_upper");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::dos_band_upper_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::dos_band_upper_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::dos_band_upper_max );
    SmplKpt::dos_band_upper_bal = XML::getAttribute(node,"balloon");
    SmplKpt::dos_band_upper_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::dos_band_upper_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"dos_mesh");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::dos_mesh_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::dos_mesh_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::dos_mesh_max );
    SmplKpt::dos_mesh_bal = XML::getAttribute(node,"balloon");
    SmplKpt::dos_mesh_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::dos_mesh_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"bz_mesh");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::bz_mesh_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::bz_mesh_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::bz_mesh_max );
    SmplKpt::bz_mesh_bal = XML::getAttribute(node,"balloon");
    SmplKpt::bz_mesh_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::bz_mesh_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"bz_number_tile");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::bz_number_tile_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::bz_number_tile_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::bz_number_tile_max );
    SmplKpt::bz_number_tile_bal = XML::getAttribute(node,"balloon");
    //    SmplKpt::bz_number_tile_expert = XML::getAttribute(node,"expert") == "enable";
    //    SmplKpt::bz_number_tile_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"cutoff_dos_cos");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &SmplKpt::cutoff_dos_cos_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &SmplKpt::cutoff_dos_cos_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &SmplKpt::cutoff_dos_cos_max );
    SmplKpt::cutoff_dos_cos_bal = XML::getAttribute(node,"balloon");
    SmplKpt::cutoff_dos_cos_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::cutoff_dos_cos_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rmesh_number_shell");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::rmesh_number_shell_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::rmesh_number_shell_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::rmesh_number_shell_max );
    SmplKpt::rmesh_number_shell_bal = XML::getAttribute(node,"balloon");
    SmplKpt::rmesh_number_shell_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::rmesh_number_shell_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rmesh_range");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &SmplKpt::rmesh_range_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &SmplKpt::rmesh_range_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &SmplKpt::rmesh_range_max );
    SmplKpt::rmesh_range_bal = XML::getAttribute(node,"balloon");
    SmplKpt::rmesh_range_expert = XML::getAttribute(node,"expert") == "enable";
    SmplKpt::rmesh_range_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"mmm_outline");
    SmplKpt::mmm_outline_bal = XML::getAttribute(node,"balloon");
    //    SmplKpt::mmm_outline_expert = XML::getAttribute(node,"expert") == "enable";
    //    SmplKpt::mmm_outline_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"mmm_detail");
    SmplKpt::mmm_detail_bal = XML::getAttribute(node,"balloon");
    //    SmplKpt::mmm_detail_expert = XML::getAttribute(node,"expert") == "enable";
    //    SmplKpt::mmm_detail_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"StructOpt");

    node  = XML::getFirstElementByTagName(group,"converge_energy");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::converge_energy_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::converge_energy_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::converge_energy_max );
    StructOpt::converge_energy_bal = XML::getAttribute(node,"balloon");
    StructOpt::converge_energy_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::converge_energy_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"converge_force");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::converge_force_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::converge_force_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::converge_force_max );
    StructOpt::converge_force_bal = XML::getAttribute(node,"balloon");
    StructOpt::converge_force_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::converge_force_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"search_1d_fratio");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::search_1d_fratio_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::search_1d_fratio_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::search_1d_fratio_max );
    StructOpt::search_1d_fratio_bal = XML::getAttribute(node,"balloon");
    StructOpt::search_1d_fratio_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::search_1d_fratio_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"displacement_max");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::displacement_max_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::displacement_max_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::displacement_max_max );
    StructOpt::displacement_max_bal = XML::getAttribute(node,"balloon");
    StructOpt::displacement_max_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::displacement_max_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"number_cycle");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &StructOpt::number_cycle_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &StructOpt::number_cycle_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &StructOpt::number_cycle_max );
    StructOpt::number_cycle_bal = XML::getAttribute(node,"balloon");
    StructOpt::number_cycle_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::number_cycle_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"refresh_cycle");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &StructOpt::refresh_cycle_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &StructOpt::refresh_cycle_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &StructOpt::refresh_cycle_max );
    StructOpt::refresh_cycle_bal = XML::getAttribute(node,"balloon");
    StructOpt::refresh_cycle_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::refresh_cycle_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"search_1d_max_step");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &StructOpt::search_1d_max_step_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &StructOpt::search_1d_max_step_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &StructOpt::search_1d_max_step_max );
    StructOpt::search_1d_max_step_bal = XML::getAttribute(node,"balloon");
    StructOpt::search_1d_max_step_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::search_1d_max_step_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"extern_pressure");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::extern_pressure_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::extern_pressure_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::extern_pressure_max );
    StructOpt::extern_pressure_bal = XML::getAttribute(node,"balloon");
    StructOpt::extern_pressure_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::extern_pressure_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stress_scale");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StructOpt::stress_scale_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StructOpt::stress_scale_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StructOpt::stress_scale_max );
    StructOpt::stress_scale_bal = XML::getAttribute(node,"balloon");
    StructOpt::stress_scale_expert = XML::getAttribute(node,"expert") == "enable";
    StructOpt::stress_scale_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"StrOptConstr");

    node  = XML::getFirstElementByTagName(group,"tim");
    StrOptConstr::tim_bal = XML::getAttribute(node,"balloon");
    StrOptConstr::tim_expert = XML::getAttribute(node,"expert") == "enable";
    StrOptConstr::tim_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"set");
    StrOptConstr::set_bal = XML::getAttribute(node,"balloon");
    StrOptConstr::set_expert = XML::getAttribute(node,"expert") == "enable";
    StrOptConstr::set_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"TraceBand");

    node  = XML::getFirstElementByTagName(group,"distrib_mode");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &TraceBand::distrib_mode_def );
    TraceBand::distrib_mode_bal = XML::getAttribute(node,"balloon");
    TraceBand::distrib_mode_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::distrib_mode_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"output_charge");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::output_charge_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::output_charge_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::output_charge_max );
    TraceBand::output_charge_bal = XML::getAttribute(node,"balloon");
    TraceBand::output_charge_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::output_charge_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"output_wave_function");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::output_wave_function_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::output_wave_function_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::output_wave_function_max );
    TraceBand::output_wave_function_bal = XML::getAttribute(node,"balloon");
    TraceBand::output_wave_function_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::output_wave_function_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"davidson_flag");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::davidson_flag_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::davidson_flag_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::davidson_flag_max );
    TraceBand::davidson_flag_bal = XML::getAttribute(node,"balloon");
    TraceBand::davidson_flag_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::davidson_flag_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"davidson_number_diag");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::davidson_number_diag_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::davidson_number_diag_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::davidson_number_diag_max );
    TraceBand::davidson_number_diag_bal = XML::getAttribute(node,"balloon");
    TraceBand::davidson_number_diag_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::davidson_number_diag_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"diag_converge");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TraceBand::diag_converge_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TraceBand::diag_converge_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TraceBand::diag_converge_max );
    TraceBand::diag_converge_bal = XML::getAttribute(node,"balloon");
    TraceBand::diag_converge_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::diag_converge_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_band_lower");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::distrib_band_lower_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::distrib_band_lower_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::distrib_band_lower_max );
    TraceBand::distrib_band_lower_bal = XML::getAttribute(node,"balloon");
    TraceBand::distrib_band_lower_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::distrib_band_lower_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_band_upper");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::distrib_band_upper_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::distrib_band_upper_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::distrib_band_upper_max );
    TraceBand::distrib_band_upper_bal = XML::getAttribute(node,"balloon");
    TraceBand::distrib_band_upper_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::distrib_band_upper_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_number_sphere");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::distrib_number_sphere_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::distrib_number_sphere_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::distrib_number_sphere_max );
    TraceBand::distrib_number_sphere_bal = XML::getAttribute(node,"balloon");
    TraceBand::distrib_number_sphere_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::distrib_number_sphere_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_number_plate");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::distrib_number_plate_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::distrib_number_plate_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::distrib_number_plate_max );
    TraceBand::distrib_number_plate_bal = XML::getAttribute(node,"balloon");
    TraceBand::distrib_number_plate_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::distrib_number_plate_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"number_band");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::number_band_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::number_band_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::number_band_max );
    TraceBand::number_band_bal = XML::getAttribute(node,"balloon");
    TraceBand::number_band_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::number_band_manual = XML::getAttribute(node,"auto") == "enable";

    /*
    node  = XML::getFirstElementByTagName(group,"number_band_traced");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::number_band_traced_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::number_band_traced_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::number_band_traced_max );
    TraceBand::number_band_traced_bal = XML::getAttribute(node,"balloon");
    TraceBand::number_band_traced_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::number_band_traced_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"number_trace_block");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::number_trace_block_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::number_trace_block_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::number_trace_block_max );
    TraceBand::number_trace_block_bal = XML::getAttribute(node,"balloon");
    TraceBand::number_trace_block_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::number_trace_block_manual = XML::getAttribute(node,"auto") == "enable";
    */

    node  = XML::getFirstElementByTagName(group,"iaxis");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::iaxis_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::iaxis_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::iaxis_max );
    TraceBand::iaxis_bal = XML::getAttribute(node,"balloon");
    TraceBand::iaxis_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::iaxis_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rzero");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TraceBand::rzero_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TraceBand::rzero_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TraceBand::rzero_max );
    TraceBand::rzero_bal = XML::getAttribute(node,"balloon");
    TraceBand::rzero_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::rzero_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rmin");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &TraceBand::rmin_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &TraceBand::rmin_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &TraceBand::rmin_max );
    TraceBand::rmin_bal = XML::getAttribute(node,"balloon");
    TraceBand::rmin_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::rmin_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"ndiv");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &TraceBand::ndiv_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &TraceBand::ndiv_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &TraceBand::ndiv_max );
    TraceBand::ndiv_bal = XML::getAttribute(node,"balloon");
    TraceBand::ndiv_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::ndiv_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"kpoint");
    TraceBand::kpoint_bal = XML::getAttribute(node,"balloon");
    TraceBand::kpoint_expert = XML::getAttribute(node,"expert") == "enable";
    TraceBand::kpoint_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"InspectWfn");

    node  = XML::getFirstElementByTagName(group,"distrib_mode");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &InspectWfn::distrib_mode_def );
    InspectWfn::distrib_mode_bal = XML::getAttribute(node,"balloon");
    InspectWfn::distrib_mode_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::distrib_mode_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"output_charge");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::output_charge_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::output_charge_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::output_charge_max );
    InspectWfn::output_charge_bal = XML::getAttribute(node,"balloon");
    InspectWfn::output_charge_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::output_charge_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_band_lower");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::distrib_band_lower_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::distrib_band_lower_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::distrib_band_lower_max );
    InspectWfn::distrib_band_lower_bal = XML::getAttribute(node,"balloon");
    InspectWfn::distrib_band_lower_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::distrib_band_lower_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_band_upper");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::distrib_band_upper_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::distrib_band_upper_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::distrib_band_upper_max );
    InspectWfn::distrib_band_upper_bal = XML::getAttribute(node,"balloon");
    InspectWfn::distrib_band_upper_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::distrib_band_upper_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_number_sphere");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::distrib_number_sphere_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::distrib_number_sphere_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::distrib_number_sphere_max );
    InspectWfn::distrib_number_sphere_bal = XML::getAttribute(node,"balloon");
    InspectWfn::distrib_number_sphere_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::distrib_number_sphere_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"distrib_number_plate");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::distrib_number_plate_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::distrib_number_plate_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::distrib_number_plate_max );
    InspectWfn::distrib_number_plate_bal = XML::getAttribute(node,"balloon");
    InspectWfn::distrib_number_plate_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::distrib_number_plate_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"pdos_target_atom");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::pdos_target_atom_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::pdos_target_atom_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::pdos_target_atom_max );
    InspectWfn::pdos_target_atom_bal = XML::getAttribute(node,"balloon");
    InspectWfn::pdos_target_atom_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::pdos_target_atom_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"iaxis");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::iaxis_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::iaxis_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::iaxis_max );
    InspectWfn::iaxis_bal = XML::getAttribute(node,"balloon");
    InspectWfn::iaxis_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::iaxis_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rzero");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &InspectWfn::rzero_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &InspectWfn::rzero_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &InspectWfn::rzero_max );
    InspectWfn::rzero_bal = XML::getAttribute(node,"balloon");
    InspectWfn::rzero_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::rzero_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"rmin");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &InspectWfn::rmin_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &InspectWfn::rmin_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &InspectWfn::rmin_max );
    InspectWfn::rmin_bal = XML::getAttribute(node,"balloon");
    InspectWfn::rmin_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::rmin_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"ndiv");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &InspectWfn::ndiv_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &InspectWfn::ndiv_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &InspectWfn::ndiv_max );
    InspectWfn::ndiv_bal = XML::getAttribute(node,"balloon");
    InspectWfn::ndiv_expert = XML::getAttribute(node,"expert") == "enable";
    InspectWfn::ndiv_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"StmInput");

    node  = XML::getFirstElementByTagName(group,"stm_fermi_energy");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StmInput::stm_fermi_energy_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StmInput::stm_fermi_energy_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StmInput::stm_fermi_energy_max );
    StmInput::stm_fermi_energy_bal = XML::getAttribute(node,"balloon");
    StmInput::stm_fermi_energy_expert = XML::getAttribute(node,"expert") == "enable";
    StmInput::stm_fermi_energy_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"vs");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &StmInput::vs_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &StmInput::vs_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &StmInput::vs_max );
    StmInput::vs_bal = XML::getAttribute(node,"balloon");
    StmInput::vs_expert = XML::getAttribute(node,"expert") == "enable";
    StmInput::vs_manual = XML::getAttribute(node,"auto") == "enable";
  }
  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"MolDyn");

    node  = XML::getFirstElementByTagName(group,"mdmode");
    XML::sscanf( XML::getAttribute(node,"default"), "%s", &MolDyn::md_mode_def );
    MolDyn::md_mode_bal = XML::getAttribute(node,"balloon");
    MolDyn::md_mode_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::md_mode_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"delta_time");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::delta_time_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::delta_time_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::delta_time_max );
    MolDyn::delta_time_bal = XML::getAttribute(node,"balloon");
    MolDyn::delta_time_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::delta_time_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"init_md_step");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &MolDyn::init_md_step_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &MolDyn::init_md_step_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &MolDyn::init_md_step_max );
    MolDyn::init_md_step_bal = XML::getAttribute(node,"balloon");
    MolDyn::init_md_step_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::init_md_step_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"end_md_step");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &MolDyn::end_md_step_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &MolDyn::end_md_step_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &MolDyn::end_md_step_max );
    MolDyn::end_md_step_bal = XML::getAttribute(node,"balloon");
    MolDyn::end_md_step_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::end_md_step_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"mode_xtrap_rho_wfn");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &MolDyn::mode_xtrap_rho_wfn_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &MolDyn::mode_xtrap_rho_wfn_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &MolDyn::mode_xtrap_rho_wfn_max );
    MolDyn::mode_xtrap_rho_wfn_bal = XML::getAttribute(node,"balloon");
    MolDyn::mode_xtrap_rho_wfn_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::mode_xtrap_rho_wfn_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"message_cycle");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &MolDyn::message_cycle_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &MolDyn::message_cycle_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &MolDyn::message_cycle_max );
    MolDyn::message_cycle_bal = XML::getAttribute(node,"balloon");
    MolDyn::message_cycle_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::message_cycle_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"system_volume");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::system_volume_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::system_volume_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::system_volume_max );
    MolDyn::system_volume_bal = XML::getAttribute(node,"balloon");
    MolDyn::system_volume_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::system_volume_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"system_kbt");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::system_kbt_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::system_kbt_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::system_kbt_max );
    MolDyn::system_kbt_bal = XML::getAttribute(node,"balloon");
    MolDyn::system_kbt_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::system_kbt_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"system_pressure");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::system_pressure_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::system_pressure_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::system_pressure_max );
    MolDyn::system_pressure_bal = XML::getAttribute(node,"balloon");
    MolDyn::system_pressure_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::system_pressure_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stern_omega_zeta");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::stern_omega_zeta_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::stern_omega_zeta_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::stern_omega_zeta_max );
    MolDyn::stern_omega_zeta_bal = XML::getAttribute(node,"balloon");
    MolDyn::stern_omega_zeta_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::stern_omega_zeta_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stern_omega_eta");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::stern_omega_eta_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::stern_omega_eta_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::stern_omega_eta_max );
    MolDyn::stern_omega_eta_bal = XML::getAttribute(node,"balloon");
    MolDyn::stern_omega_eta_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::stern_omega_eta_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stern_zeta");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::stern_zeta_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::stern_zeta_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::stern_zeta_max );
    MolDyn::stern_zeta_bal = XML::getAttribute(node,"balloon");
    MolDyn::stern_zeta_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::stern_zeta_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stern_eta");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::stern_eta_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::stern_eta_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::stern_eta_max );
    MolDyn::stern_eta_bal = XML::getAttribute(node,"balloon");
    MolDyn::stern_eta_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::stern_eta_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"stern_sigma");
    XML::sscanf( XML::getAttribute(node,"default"), "%lf", &MolDyn::stern_sigma_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%lf", &MolDyn::stern_sigma_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%lf", &MolDyn::stern_sigma_max );
    MolDyn::stern_sigma_bal = XML::getAttribute(node,"balloon");
    MolDyn::stern_sigma_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::stern_sigma_manual = XML::getAttribute(node,"auto") == "enable";

    node  = XML::getFirstElementByTagName(group,"abinitio_cycle");
    XML::sscanf( XML::getAttribute(node,"default"), "%d", &MolDyn::abinitio_cycle_def );
    XML::sscanf( XML::getAttribute(node,"min"), "%d", &MolDyn::abinitio_cycle_min );
    XML::sscanf( XML::getAttribute(node,"max"), "%d", &MolDyn::abinitio_cycle_max );
    MolDyn::abinitio_cycle_bal = XML::getAttribute(node,"balloon");
    MolDyn::abinitio_cycle_expert = XML::getAttribute(node,"expert") == "enable";
    MolDyn::abinitio_cycle_manual = XML::getAttribute(node,"auto") == "enable";
  }

  {
    QDomElement group, node;
    group = XML::getFirstElementByTagName(root,"Filemap");

    node  = XML::getFirstElementByTagName(group,"basename");
    if( XML::getAttribute(node,"default") != "" ){
      XML::sscanf( XML::getAttribute(node,"default"), "%s", &Filemap::basename_def );
    }
    Filemap::basename_bal = XML::getAttribute(node,"balloon");
    Filemap::basename_expert = XML::getAttribute(node,"expert") == "enable";
    Filemap::basename_manual = XML::getAttribute(node,"auto") == "enable";
  }

  return true;
}

bool DTXTapp::load( DTLattice& lattice, const QString& fname )
{
  if( !fname.endsWith( ".cg"  ) &&
      !fname.endsWith( ".pef" ) &&
      !fname.endsWith( ".w2c" ) &&
      !fname.endsWith( ".str" ) ){
    throw MyException("Unknow xTAPP suffix.",fname);
  }

  const char* error_msg = NULL;
  NameListBuffer nlb(qPrintable(fname));

  if( !nlb.isValid() ){
    throw MyException("xTAPP input file is not found.",fname);
  }

  clear();

  // reset all manual flags to false
  TappInput::number_spin_manual=false;
  TappInput::spin_mode_manual=false;
  TappInput::cutoff_local_potential_manual=false;
  TappInput::cutoff_wave_function_manual=false;
  TappInput::cutoff_uspp_q_manual=false;
  TappInput::xtrap_beta_manual=false;
  TappInput::cutoff_btp_a_manual=false;
  TappInput::cutoff_btp_gc_manual=false;
  TappInput::cutoff_btp_sigma_manual=false;
  TappInput::number_band_manual=false;
  TappInput::extra_charge_manual=false;
  TappInput::diff_spin_manual=false;
  TappInput::elec_kbt_manual=false;
  TappInput::number_xtrap_stage_manual=false;
  TappInput::initial_wfn_manual=false;
  TappInput::initial_lpt_manual=false;
  TappInput::store_wfn_manual=false;
  TappInput::chain_calc_manual=false;
  TappInput::scf_converge_manual=false;
  TappInput::scf_converge_energy_manual=false;
  TappInput::scf_number_iter_1st_manual=false;
  TappInput::scf_number_iter_manual=false;
  TappInput::davidson_flag_manual=false;
  TappInput::davidson_number_diag_1st_manual=false;
  TappInput::davidson_number_diag_manual=false;
  TappInput::control_uptime_manual=false;
  TappInput::cutoff_bspl_fit_manual=false;
  TappInput::control_q_han_win_fac_manual=false;
  TappInput::control_nbsf_manual=false;
  TappInput::xc_type_manual=false;
  TappInput::cutoff_exch_att_rc_manual=false;
  TappInput::cutoff_exch_att_rd_manual=false;
  TappInput::scf_threshold_hybrid_manual=false;
  TappInput::compat_old_squ_norm_manual=false;
  Symmetry::symmetry_format_manual=false;
  SmplKpt::dos_mode_manual=false;
  SmplKpt::dos_band_lower_manual=false;
  SmplKpt::dos_band_upper_manual=false;
  SmplKpt::dos_mesh_manual=false;
  SmplKpt::bz_mesh_manual=false;
  SmplKpt::bz_number_tile_manual=false;
  SmplKpt::cutoff_dos_cos_manual=false;
  SmplKpt::rmesh_number_shell_manual=false;
  SmplKpt::rmesh_range_manual=false;
  SmplKpt::mmm_outline_manual=false;
  SmplKpt::mmm_detail_manual=false;
  StructOpt::converge_energy_manual=false;
  StructOpt::converge_force_manual=false;
  StructOpt::search_1d_fratio_manual=false;
  StructOpt::displacement_max_manual=false;
  StructOpt::number_cycle_manual=false;
  StructOpt::refresh_cycle_manual=false;
  StructOpt::search_1d_max_step_manual=false;
  StructOpt::extern_pressure_manual=false;
  StructOpt::stress_scale_manual=false;
  StrOptConstr::tim_manual=false;
  StrOptConstr::set_manual=false;
  TraceBand::distrib_mode_manual=false;
  TraceBand::output_charge_manual=false;
  TraceBand::output_wave_function_manual=false;
  TraceBand::davidson_flag_manual=false;
  TraceBand::davidson_number_diag_manual=false;
  TraceBand::diag_converge_manual=false;
  TraceBand::distrib_band_lower_manual=false;
  TraceBand::distrib_band_upper_manual=false;
  TraceBand::distrib_number_sphere_manual=false;
  TraceBand::distrib_number_plate_manual=false;
  TraceBand::number_band_manual=false;
  //    TraceBand::number_band_traced_manual=false;//DEBUG
  //    TraceBand::number_trace_block_manual=false;//DEBUG
  TraceBand::iaxis_manual=false;
  TraceBand::rzero_manual=false;
  TraceBand::rmin_manual=false;
  TraceBand::ndiv_manual=false;
  TraceBand::kpoint_manual=false;
  InspectWfn::distrib_mode_manual=false;
  InspectWfn::output_charge_manual=false;
  InspectWfn::distrib_band_lower_manual=false;
  InspectWfn::distrib_band_upper_manual=false;
  InspectWfn::distrib_number_sphere_manual=false;
  InspectWfn::distrib_number_plate_manual=false;
  InspectWfn::pdos_target_atom_manual=false;
  InspectWfn::iaxis_manual=false;
  InspectWfn::rzero_manual=false;
  InspectWfn::rmin_manual=false;
  InspectWfn::ndiv_manual=false;
  StmInput::stm_fermi_energy_manual=false;
  StmInput::vs_manual=false;
  MolDyn::md_mode_manual=false;
  MolDyn::delta_time_manual=false;
  MolDyn::init_md_step_manual=false;
  MolDyn::end_md_step_manual=false;
  MolDyn::mode_xtrap_rho_wfn_manual=false;
  MolDyn::message_cycle_manual=false;
  MolDyn::system_volume_manual=false;
  MolDyn::system_kbt_manual=false;
  MolDyn::system_pressure_manual=false;
  MolDyn::stern_omega_zeta_manual=false;
  MolDyn::stern_omega_eta_manual=false;
  MolDyn::stern_zeta_manual=false;
  MolDyn::stern_eta_manual=false;
  MolDyn::stern_sigma_manual=false;
  MolDyn::abinitio_cycle_manual=false;
  Filemap::basename_manual=false;

  // for str file
  if( fname.endsWith( ".str" ) ){
    if( !tappinput.load(lattice,nlb) ){
      error_msg = "broken &tappinput group.";
      goto error_block;
    }
    if( !atoms.load(lattice.getData(),nlb) ){
      error_msg = "broken &atom group.";
      goto error_block;
    }

    update();
    return true;
  }

  // for normal cg file
  if( !tappinput.load(lattice,nlb) ){
    error_msg = "broken &tappinput group.";
    goto error_block;
  }
  if( !symmetry.load(lattice.symmetry,nlb) ){
    error_msg = "broken &symmetry group.";
    goto error_block;
  }
  if( !atoms.load(lattice.getData(),nlb) ){
    error_msg = "broken &atom group.";
    goto error_block;
  }
  if( !smplkpt.load(nlb) ){
    error_msg = "broken &smpl_kpt group.";
    goto error_block;
  }
  if( !structopt.load(nlb) ){
    error_msg = "broken &struct_opt group.";
    goto error_block;
  }
  if( !stroptconstr.load(lattice.getData(),nlb) ){
    error_msg = "broken &str_opt_constr group.";
    goto error_block;
  }
  if( !traceband.load(lattice.cell,nlb) ){
    error_msg = "broken &trace_band group.";
    goto error_block;
  }
  if( !inspectwfn.load(nlb) ){
    error_msg = "broken &inspect_wfn group.";
    goto error_block;
  }
  if( !stminput.load(nlb) ){
    error_msg = "broken &stminput group.";
    goto error_block;
  }
  if( !moldyn.load(lattice.getData(),nlb) ){
    error_msg = "broken &mol_dyn group.";
    goto error_block;
  }
  if( !filemap.load(lattice,nlb) ){
    error_msg = "broken &filemap group.";
    goto error_block;
  }


  update();

  return true;

 error_block:
  clear();

  throw MyException(error_msg,fname);
  return false; // dummy statement
}



bool DTXTapp::guess( const QString& fname )
{
  FILE* fptr = fopen( fname, "rb" );
  if( fptr == NULL ){
    throw MyException("can not open a file.",fname);
  }

  char buf[256];
  char svalue[32];

  bool match = false;
  while( fgets(buf,sizeof(buf),fptr) ){
    if( 1 == sscanf(buf,"%s", svalue ) &&
	strcasecmp(svalue,"&tappinput")==0 ){
      match = true;
      break;
    }
    if( 1 == sscanf(buf,"%s", svalue ) &&
	strcasecmp(svalue,"&struct_data")==0 ){
      match = true;
      break;
    }
  }

  fclose(fptr);

  return match;
}


bool DTXTapp::convert( const DTTapp& tapp )
{
  clear();

  tappinput.number_spin = tapp.lsda.nspin;
  tappinput.spin_mode = tapp.lsda.spinmode;

  tappinput.cutoff_local_potential = tapp.cutoff.qf;
  tappinput.cutoff_wave_function = tapp.cutoff.qm;
  tappinput.cutoff_uspp_q = tapp.cutoff.qc;
  tappinput.xtrap_beta = tapp.cutoff.beta;
  tappinput.cutoff_btp_a = tapp.cutoff.qbtp1;
  tappinput.cutoff_btp_gc = tapp.cutoff.qbtp2;
  tappinput.cutoff_btp_sigma = tapp.cutoff.qbtp3;
  tappinput.number_band = tapp.mesh.nw;
  tappinput.extra_charge = tapp.mesh.znext;
  tappinput.diff_spin = tapp.mesh.dspin;
  tappinput.elec_kbt = tapp.parameter.ekbt;
  tappinput.number_xtrap_stage = tapp.file.iopt1;
  tappinput.initial_wfn = tapp.file.iopt2;
  tappinput.initial_lpt = tapp.file.iopt3;
  tappinput.store_wfn = tapp.file.iopt4;
  tappinput.scf_converge = tapp.parameter.eps;
  tappinput.scf_converge_energy = tapp.parameter.eepsa;
  tappinput.scf_number_iter_1st = tapp.parameter.niter0;
  tappinput.scf_number_iter = tapp.parameter.niter1;
  tappinput.davidson_flag = tapp.parameter.itsb;
  tappinput.davidson_number_diag_1st = tapp.parameter.ndiag0;
  tappinput.davidson_number_diag = tapp.parameter.ndiag1;
  tappinput.control_uptime = tapp.parameter.uptime;

  if( false );
  else if( tapp.lsda.vxctype[tapp.lsda.ixctype] == "'LDAPZ81'" ){
    tappinput.ixc_type = findmode( tappinput.vxc_type, "'CAPZ'" );
  }
  else if( tapp.lsda.vxctype[tapp.lsda.ixctype] == "'GGAPW91'" ){
    tappinput.ixc_type = findmode( tappinput.vxc_type, "'PW91'" );
  }
  else if( tapp.lsda.vxctype[tapp.lsda.ixctype] == "'GGAPBE96'" ){
    tappinput.ixc_type = findmode( tappinput.vxc_type, "'PBE'" );
  }
  else{
    tappinput.ixc_type = findmode( tappinput.vxc_type, "'PBE'" );
  }


  smplkpt.dos_band_lower = tapp.mesh.nb1;
  smplkpt.dos_band_upper = tapp.mesh.nb2;
  smplkpt.dos_mesh[0] = tapp.mesh.ndx;
  smplkpt.dos_mesh[1] = tapp.mesh.ndy;
  smplkpt.dos_mesh[2] = tapp.mesh.ndz;
  smplkpt.bz_mesh = tapp.mesh.nk;
  smplkpt.cutoff_dos_cos = tapp.cutoff.rf;
  smplkpt.rmesh_number_shell = tapp.sampling.nkrnew;
  smplkpt.rmesh_range[0] = tapp.sampling.ll1;
  smplkpt.rmesh_range[1] = tapp.sampling.ll2;
  smplkpt.rmesh_range[2] = tapp.sampling.ll3;

  smplkpt.mmm1.resize( tapp.sampling.mmm1.size() );
  for( int i=0; i<(int)tapp.sampling.mmm1.size(); i++ ){
    const DTTapp::Sampling::int3& i3 = tapp.sampling.mmm1[i];
    smplkpt.mmm1[i] = SmplKpt::int3( i3.a[0], i3.a[1], i3.a[2] );
  }
  smplkpt.mmm2.resize( tapp.sampling.mmm2.size() );
  for( int i=0; i<(int)tapp.sampling.mmm2.size(); i++ ){
    const DTTapp::Sampling::int3& i3 = tapp.sampling.mmm2[i];
    smplkpt.mmm2[i] = SmplKpt::int3( i3.a[0], i3.a[1], i3.a[2] );
  }
  smplkpt.setByDetail();

  structopt.converge_energy = tapp.parameter.eepsa;
  structopt.converge_force = tapp.parameter.feps;
  structopt.search_1d_fratio = tapp.parameter.decr;
  structopt.displacement_max = tapp.parameter.okatom;
  structopt.number_cycle = tapp.parameter.ncycl;
  structopt.refresh_cycle = tapp.parameter.mrfr;
  structopt.search_1d_max_step = tapp.parameter.most;

  stroptconstr.tim.clear();
  for( int i=1; i<(int)tapp.mass.tim.size(); i++ ){
    stroptconstr.tim.push_back( tapp.mass.tim[i] );
  }

  if( false );
  else if( tapp.vbpef.ifbunp == 0 ){
    traceband.idistrib_mode =
      findmode( traceband.vdistrib_mode, "'none'" );
  }
  else if( tapp.vbpef.ifbunp == 1 ){
    traceband.idistrib_mode =
      findmode( traceband.vdistrib_mode, "'plate'" );
  }
  else if( tapp.vbpef.ifbunp == 2 ){
    traceband.idistrib_mode =
      findmode( traceband.vdistrib_mode, "'sphere'" );
  }

  traceband.davidson_flag = tapp.vbpef.itsb;
  traceband.davidson_number_diag = tapp.vbpef.ndiag;
  traceband.diag_converge = tapp.vbpef.eps;
  traceband.distrib_band_lower = tapp.vbpef.nbba1;
  traceband.distrib_band_upper = tapp.vbpef.nbba2;
  traceband.distrib_number_sphere = tapp.vbpef.nsph;
  traceband.distrib_number_plate = tapp.vbpef.nsph;

  traceband.number_band = tapp.vbpef.nw;

  traceband.rzero = tapp.vbpef.rzero;
  traceband.rmin = tapp.vbpef.rmin;
  traceband.rmax = tapp.vbpef.rmax;
  traceband.ndiv = tapp.vbpef.ndiv;


  if( false );
  else if( tapp.vbpef.ifbunp == 0 ){
    inspectwfn.idistrib_mode =
      findmode( inspectwfn.vdistrib_mode, "'none'" );
  }
  else if( tapp.vbpef.ifbunp == 1 ){
    inspectwfn.idistrib_mode =
      findmode( inspectwfn.vdistrib_mode, "'plate'" );
  }
  else if( tapp.vbpef.ifbunp == 2 ){
    inspectwfn.idistrib_mode =
      findmode( inspectwfn.vdistrib_mode, "'sphere'" );
  }
  inspectwfn.distrib_band_lower = tapp.vbpef.nbba1;
  inspectwfn.distrib_band_upper = tapp.vbpef.nbba2;
  inspectwfn.distrib_number_sphere = tapp.vbpef.nsph;
  inspectwfn.distrib_number_plate = tapp.vbpef.nsph;

  inspectwfn.rzero = tapp.vbpef.rzero;
  inspectwfn.rmin = tapp.vbpef.rmin;
  inspectwfn.rmax = tapp.vbpef.rmax;
  inspectwfn.ndiv = tapp.vbpef.ndiv;

  return true;
}

extern QString getFileName( const QString& path ); // defined in dtmodel.cc

bool DTXTapp::save( const DTLattice& lattice, const QString& fname )
{
  FILE* fptr = fopen( fname, "wb" );
  if( fptr == NULL ){
    throw MyException("can not create a config file.",fname);
    //    return false;
  }
  tappinput.save( lattice, fptr );
  symmetry.save( lattice.symmetry, fptr );
  atoms.save( lattice.getData(), fptr );
  smplkpt.save( fptr );
  structopt.save( fptr );
  stroptconstr.save( lattice.getData(), fptr );
  traceband.save( lattice.cell, fptr );
  inspectwfn.save( fptr );
  stminput.save( fptr );
  moldyn.save( lattice.getData(), fptr );
  if( filemap.basename=="" ){
    filemap.basename = getFileName(fname);
    int len = filemap.basename.lastIndexOf(".");
    if( len!=-1 ){
      filemap.basename = filemap.basename.left(len);
    }
  }
  filemap.save( lattice, fptr );

  fclose(fptr);
 
  return true;
}

