/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
  \file dtxtapp.h
  \brief xTAPPݒf[^̃NX
*/

#ifndef __DTXTAPP_H_INCLUDED
#define __DTXTAPP_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "matrix.h"
#include "position.h"
#include "namelist.h"

class DTLattice;
class DTCell;
class DTSymmetry;
class DTAtoms;

class DTTapp;

class DTXTapp
{
 public:
  DTXTapp( void );

 public:
  void update( void );
  void clear( void );

 public:
  bool guess( const QString& fname );
  bool load( DTLattice& lattice, const QString& fname );
  bool convert( const DTTapp& tapp );
  bool save( const DTLattice& lattice, const QString& fname );
  static bool loadDefaults( void );

 public:
  struct TappInput {// &tappinput
    //    double lattice_factor; // cell.length
    //    double lattice_list[3][3]; // cell.Ea,Eb,Ec
    int    number_spin;
    int    spin_mode;
    double cutoff_local_potential;
    double cutoff_wave_function;
    double cutoff_uspp_q;
    double xtrap_beta;
    double cutoff_btp_a;
    double cutoff_btp_gc;
    double cutoff_btp_sigma;
    // int number_element; // atoms.psfile.size();
    // int number_atom; // atoms.vatom.size();
    int    number_band;
    double extra_charge;
    double diff_spin;
    double elec_kbt;
    int    number_xtrap_stage;
    int    initial_wfn;
    int    initial_lpt;
    int    store_wfn;
    int    chain_calc;
    double scf_converge;
    double scf_converge_energy;
    int    scf_number_iter_1st;
    int    scf_number_iter;
    int    davidson_flag;
    int    davidson_number_diag_1st;
    int    davidson_number_diag;
    double control_uptime;
    double cutoff_bspl_fit;
    double control_q_han_win_fac;
    int    control_nbsf;
    vector<QString> vxc_type;
    int            ixc_type;
    double cutoff_exch_att_rc;
    double cutoff_exch_att_rd;
    double scf_threshold_hybrid;
    int    compat_old_squ_norm;

    static int    number_spin_def, number_spin_min, number_spin_max;
    static int    spin_mode_def, spin_mode_min, spin_mode_max;
    static double cutoff_local_potential_def, cutoff_local_potential_min, cutoff_local_potential_max;
    static double cutoff_wave_function_def, cutoff_wave_function_min, cutoff_wave_function_max;
    static double cutoff_uspp_q_def, cutoff_uspp_q_min, cutoff_uspp_q_max;
    static double xtrap_beta_def, xtrap_beta_min, xtrap_beta_max;
    static double cutoff_btp_a_def, cutoff_btp_a_min, cutoff_btp_a_max;
    static double cutoff_btp_gc_def, cutoff_btp_gc_min, cutoff_btp_gc_max;
    static double cutoff_btp_sigma_def, cutoff_btp_sigma_min, cutoff_btp_sigma_max;
    static int    number_band_def, number_band_min, number_band_max;
    static double extra_charge_def, extra_charge_min, extra_charge_max;
    static double diff_spin_def, diff_spin_min, diff_spin_max;
    static double elec_kbt_def, elec_kbt_min, elec_kbt_max;
    static int    number_xtrap_stage_def, number_xtrap_stage_min, number_xtrap_stage_max;
    static int    initial_wfn_def, initial_wfn_min, initial_wfn_max;
    static int    initial_lpt_def, initial_lpt_min, initial_lpt_max;
    static int    store_wfn_def, store_wfn_min, store_wfn_max;
    static int    chain_calc_def, chain_calc_min, chain_calc_max;
    static double scf_converge_def, scf_converge_min, scf_converge_max;
    static double scf_converge_energy_def, scf_converge_energy_min, scf_converge_energy_max;
    static int    scf_number_iter_1st_def, scf_number_iter_1st_min, scf_number_iter_1st_max;
    static int    scf_number_iter_def, scf_number_iter_min, scf_number_iter_max;
    static int    davidson_flag_def, davidson_flag_min, davidson_flag_max;
    static int    davidson_number_diag_1st_def, davidson_number_diag_1st_min, davidson_number_diag_1st_max;
    static int    davidson_number_diag_def, davidson_number_diag_min, davidson_number_diag_max;
    static double control_uptime_def, control_uptime_min, control_uptime_max;
    static double cutoff_bspl_fit_def, cutoff_bspl_fit_min, cutoff_bspl_fit_max;
    static double control_q_han_win_fac_def, control_q_han_win_fac_min, control_q_han_win_fac_max;
    static int    control_nbsf_def, control_nbsf_min, control_nbsf_max;
    static QString xc_type_def;
    static double cutoff_exch_att_rc_def, cutoff_exch_att_rc_min, cutoff_exch_att_rc_max;
    static double cutoff_exch_att_rd_def, cutoff_exch_att_rd_min, cutoff_exch_att_rd_max;
    static double scf_threshold_hybrid_def, scf_threshold_hybrid_min, scf_threshold_hybrid_max;
    static int    compat_old_squ_norm_def, compat_old_squ_norm_min, compat_old_squ_norm_max;

    static bool number_spin_expert, number_spin_manual;
    static bool spin_mode_expert, spin_mode_manual;
    static bool cutoff_local_potential_expert, cutoff_local_potential_manual;
    static bool cutoff_wave_function_expert, cutoff_wave_function_manual;
    static bool cutoff_uspp_q_expert, cutoff_uspp_q_manual;
    static bool xtrap_beta_expert, xtrap_beta_manual;
    static bool cutoff_btp_a_expert, cutoff_btp_a_manual;
    static bool cutoff_btp_gc_expert, cutoff_btp_gc_manual;
    static bool cutoff_btp_sigma_expert, cutoff_btp_sigma_manual;
    static bool number_band_expert, number_band_manual;
    static bool extra_charge_expert, extra_charge_manual;
    static bool diff_spin_expert, diff_spin_manual;
    static bool elec_kbt_expert, elec_kbt_manual;
    static bool number_xtrap_stage_expert, number_xtrap_stage_manual;
    static bool initial_wfn_expert, initial_wfn_manual;
    static bool initial_lpt_expert, initial_lpt_manual;
    static bool store_wfn_expert, store_wfn_manual;
    static bool chain_calc_expert, chain_calc_manual;
    static bool scf_converge_expert, scf_converge_manual;
    static bool scf_converge_energy_expert, scf_converge_energy_manual;
    static bool scf_number_iter_1st_expert, scf_number_iter_1st_manual;
    static bool scf_number_iter_expert, scf_number_iter_manual;
    static bool davidson_flag_expert, davidson_flag_manual;
    static bool davidson_number_diag_1st_expert, davidson_number_diag_1st_manual;
    static bool davidson_number_diag_expert, davidson_number_diag_manual;
    static bool control_uptime_expert, control_uptime_manual;
    static bool cutoff_bspl_fit_expert, cutoff_bspl_fit_manual;
    static bool control_q_han_win_fac_expert, control_q_han_win_fac_manual;
    static bool control_nbsf_expert, control_nbsf_manual;
    static bool xc_type_expert, xc_type_manual;
    static bool cutoff_exch_att_rc_expert, cutoff_exch_att_rc_manual;
    static bool cutoff_exch_att_rd_expert, cutoff_exch_att_rd_manual;
    static bool scf_threshold_hybrid_expert, scf_threshold_hybrid_manual;
    static bool compat_old_squ_norm_expert, compat_old_squ_norm_manual;

    static QString number_spin_bal;
    static QString spin_mode_bal;
    static QString cutoff_local_potential_bal;
    static QString cutoff_wave_function_bal;
    static QString cutoff_uspp_q_bal;
    static QString xtrap_beta_bal;
    static QString cutoff_btp_a_bal;
    static QString cutoff_btp_gc_bal;
    static QString cutoff_btp_sigma_bal;
    static QString number_band_bal;
    static QString extra_charge_bal;
    static QString diff_spin_bal;
    static QString elec_kbt_bal;
    static QString number_xtrap_stage_bal;
    static QString initial_wfn_bal;
    static QString initial_lpt_bal;
    static QString store_wfn_bal;
    static QString chain_calc_bal;
    static QString scf_converge_bal;
    static QString scf_converge_energy_bal;
    static QString scf_number_iter_1st_bal;
    static QString scf_number_iter_bal;
    static QString davidson_flag_bal;
    static QString davidson_number_diag_1st_bal;
    static QString davidson_number_diag_bal;
    static QString control_uptime_bal;
    static QString cutoff_bspl_fit_bal;
    static QString control_q_han_win_fac_bal;
    static QString control_nbsf_bal;
    static QString xc_type_bal;
    static QString cutoff_exch_att_rc_bal;
    static QString cutoff_exch_att_rd_bal;
    static QString scf_threshold_hybrid_bal;
    static QString compat_old_squ_norm_bal;

    TappInput( void );
    void clear( void );
    void update( void );
    bool load( DTLattice& lattice, NameListBuffer& nlb );
    bool save( const DTLattice& lattice, FILE* fptr );
  } tappinput;

  struct Symmetry{ // &symmetry
    vector<QString> vsymmetry_format;
    int            isymmetry_format;
    int number_sym_op;
    int has_inversion;
    int denom_trans;

    static QString symmetry_format_def;
    static int    has_inversion_def,has_inversion_min,has_inversion_max;

    static bool   symmetry_format_expert,symmetry_format_manual;
    static bool   has_inversion_expert,has_inversion_manual;

    static QString symmetry_format_bal;
    static QString has_inversion_bal;

    Symmetry( void );
    void clear( void );
    void update( void );
    bool load( DTSymmetry& symmetry, NameListBuffer& nlb );
    bool save( const DTSymmetry& symmetry, FILE* fptr );

  } symmetry;

  struct Atoms {
    Atoms( void );
    void clear( void );
    void update( void );
    bool load( DTAtoms& atoms, NameListBuffer& nlb );
    bool save( const DTAtoms& atoms, FILE* fptr );
  } atoms;

  struct SmplKpt{ // &smpl_kpt
    vector<QString> vdos_mode;
    int            idos_mode;
    int    dos_band_lower;
    int    dos_band_upper;
    int    dos_mesh[3];
    int    bz_mesh;
    int    bz_number_tile;
    double cutoff_dos_cos;
    int    rmesh_number_shell;
    int    rmesh_range[3];

    static QString dos_mode_def;
    static int    dos_band_lower_def,dos_band_lower_min,dos_band_lower_max;
    static int    dos_band_upper_def,dos_band_upper_min,dos_band_upper_max;
    static int    dos_mesh_def,dos_mesh_min,dos_mesh_max;
    static int    bz_mesh_def,bz_mesh_min,bz_mesh_max;
    static int    bz_number_tile_def,bz_number_tile_min,bz_number_tile_max;
    static double cutoff_dos_cos_def,cutoff_dos_cos_min,cutoff_dos_cos_max;
    static int    rmesh_number_shell_def,rmesh_number_shell_min,rmesh_number_shell_max;
    static int    rmesh_range_def,rmesh_range_min,rmesh_range_max;

    static bool dos_mode_expert, dos_mode_manual;
    static bool dos_band_lower_expert, dos_band_lower_manual;
    static bool dos_band_upper_expert, dos_band_upper_manual;
    static bool dos_mesh_expert, dos_mesh_manual;
    static bool bz_mesh_expert, bz_mesh_manual;
    static bool bz_number_tile_expert, bz_number_tile_manual;
    static bool cutoff_dos_cos_expert, cutoff_dos_cos_manual;
    static bool rmesh_number_shell_expert, rmesh_number_shell_manual;
    static bool rmesh_range_expert, rmesh_range_manual;
    static bool mmm_outline_expert, mmm_outline_manual;
    static bool mmm_detail_expert, mmm_detail_manual;

    static QString dos_mode_bal;
    static QString dos_band_lower_bal;
    static QString dos_band_upper_bal;
    static QString dos_mesh_bal;
    static QString bz_mesh_bal;
    static QString bz_number_tile_bal;
    static QString cutoff_dos_cos_bal;
    static QString rmesh_number_shell_bal;
    static QString rmesh_range_bal;
    static QString mmm_outline_bal;
    static QString mmm_detail_bal;

    SmplKpt( void );
    void clear( void );
    void update( void );
    bool load( NameListBuffer& nlb );
    bool save( FILE* fptr );

    struct int3 {
      int a[3];
      int3( void ){}
      int3( const int a0, const int a1, const int a2 ){
	a[0] = a0, a[1] = a1, a[2] = a2;
      }
      int& operator [] ( const int j ){
	return a[j];
      }
      const int& operator [] ( const int j ) const {
	return a[j];
      }
    };

    int3 mesh;
    vector<QString> vmesh;
    int            imesh;
    bool           gamma;

    vector<int3> mmm1;
    vector<int3> mmm2;

    int3 mmm1_shown;
    int3 mmm2_shown;
    int  index_shown;

    void change_shown( void );
    void update_shown( void );
    int size_shown( void );

    void setByOutline( void );
    void setByDetail( void );
    void addMMM( void );
    void delMMM( void );
  } smplkpt;

  struct StructOpt{ // &struct_opt
    double converge_energy;
    double converge_force;
    double search_1d_fratio;
    double displacement_max;
    int    number_cycle;
    int    refresh_cycle;
    int    search_1d_max_step;
    double extern_pressure;
    double stress_scale[6];

    static double converge_energy_def,converge_energy_min,converge_energy_max;
    static double converge_force_def,converge_force_min,converge_force_max;
    static double search_1d_fratio_def,search_1d_fratio_min,search_1d_fratio_max;
    static double displacement_max_def,displacement_max_min,displacement_max_max;
    static int    number_cycle_def,number_cycle_min,number_cycle_max;
    static int    refresh_cycle_def,refresh_cycle_min,refresh_cycle_max;
    static int    search_1d_max_step_def,search_1d_max_step_min,search_1d_max_step_max;
    static double extern_pressure_def,extern_pressure_min,extern_pressure_max;
    static double stress_scale_def,stress_scale_min,stress_scale_max;

    static bool converge_energy_expert, converge_energy_manual;
    static bool converge_force_expert, converge_force_manual;
    static bool search_1d_fratio_expert, search_1d_fratio_manual;
    static bool displacement_max_expert, displacement_max_manual;
    static bool number_cycle_expert, number_cycle_manual;
    static bool refresh_cycle_expert, refresh_cycle_manual;
    static bool search_1d_max_step_expert, search_1d_max_step_manual;
    static bool extern_pressure_expert, extern_pressure_manual;
    static bool stress_scale_expert, stress_scale_manual;

    static QString converge_energy_bal;
    static QString converge_force_bal;
    static QString search_1d_fratio_bal;
    static QString displacement_max_bal;
    static QString number_cycle_bal;
    static QString refresh_cycle_bal;
    static QString search_1d_max_step_bal;
    static QString extern_pressure_bal;
    static QString stress_scale_bal;

    StructOpt( void );
    void clear( void );
    void update( void );
    bool load( NameListBuffer& nlb );
    bool save( FILE* fptr );
  } structopt;

  struct StrOptConstr{ // &str_opt_constr
    //    int nmkd; // number of inverse mass tensors
    vector<Matrix> tim; // inverse mass tensors

    Matrix   tim_shown;
    int      tim_index_shown;

    //    int nset;
    struct Target{
      int    imkd;
      QString tatm; // (0:nmsi-1)
      Target( void ){
	imkd=0; tatm="";
      }
    };
    vector<Target> set; // (0:nset)

    Target   set_shown;
    int      set_index_shown;

    static bool tim_expert, tim_manual;
    static bool set_expert, set_manual;
    static QString tim_bal;
    static QString set_bal;

    StrOptConstr( void );
    void clear( void );
    void update( void );
    bool load( DTAtoms& atoms, NameListBuffer& nlb );
    bool save( const DTAtoms& atoms, FILE* fptr );

    void tim_change_shown( void );
    void tim_update_shown( void );
    int  tim_size_shown( void );
    void tim_add( void );
    void tim_del( void );
    void set_change_shown( void );
    void set_update_shown( void );
    int  set_size_shown( void );
    void set_add( void );
    void set_del( void );
  } stroptconstr;

  struct TraceBand{ // &trace_band
    vector<QString> vdistrib_mode;
    int            idistrib_mode;

    int    output_charge;
    int    output_wave_function;
    int    davidson_flag;
    int    davidson_number_diag;
    double diag_converge;
    int    distrib_band_lower;
    int    distrib_band_upper;
    int    distrib_number_sphere;
    int    distrib_number_plate;
    int    number_band;
    //    int    number_band_traced;//DEBUG
    //    int    number_trace_block;//DEBUG

    int      iaxis; // for dist_mode=plate
    Position rzero;
    double   rmin, rmax; // for dist_mode=sphere
    int      ndiv; // for dist_mode=plate and sphere

    static QString distrib_mode_def;
    static int    output_charge_def,output_charge_min,output_charge_max;
    static int    output_wave_function_def,output_wave_function_min,output_wave_function_max;
    static int    davidson_flag_def,davidson_flag_min,davidson_flag_max;
    static int    davidson_number_diag_def,davidson_number_diag_min,davidson_number_diag_max;
    static double diag_converge_def,diag_converge_min,diag_converge_max;
    static int    distrib_band_lower_def,distrib_band_lower_min,distrib_band_lower_max;
    static int    distrib_band_upper_def,distrib_band_upper_min,distrib_band_upper_max;
    static int    distrib_number_sphere_def,distrib_number_sphere_min,distrib_number_sphere_max;
    static int    distrib_number_plate_def,distrib_number_plate_min,distrib_number_plate_max;
    static int    number_band_def,number_band_min,number_band_max;
    //    static int    number_band_traced_def,number_band_traced_min,number_band_traced_max;
    //    static int    number_trace_block_def,number_trace_block_min,number_trace_block_max;
    static int    iaxis_def,iaxis_min,iaxis_max;
    static double rzero_def,rzero_min,rzero_max;
    static double rmin_def,rmin_min,rmin_max;
    static int    ndiv_def,ndiv_min,ndiv_max;

    static bool distrib_mode_expert, distrib_mode_manual;
    static bool output_charge_expert, output_charge_manual;
    static bool output_wave_function_expert, output_wave_function_manual;
    static bool davidson_flag_expert, davidson_flag_manual;
    static bool davidson_number_diag_expert, davidson_number_diag_manual;
    static bool diag_converge_expert, diag_converge_manual;
    static bool distrib_band_lower_expert, distrib_band_lower_manual;
    static bool distrib_band_upper_expert, distrib_band_upper_manual;
    static bool distrib_number_sphere_expert, distrib_number_sphere_manual;
    static bool distrib_number_plate_expert, distrib_number_plate_manual;
    static bool number_band_expert, number_band_manual;
    //    static bool number_band_traced_expert, number_band_traced_manual;
    //    static bool number_trace_block_expert, number_trace_block_manual;
    static bool iaxis_expert,iaxis_manual;
    static bool rzero_expert,rzero_manual;
    static bool rmin_expert,rmin_manual;
    static bool ndiv_expert,ndiv_manual;
    static bool kpoint_expert, kpoint_manual;

    static QString distrib_mode_bal;
    static QString output_charge_bal;
    static QString output_wave_function_bal;
    static QString davidson_flag_bal;
    static QString davidson_number_diag_bal;
    static QString diag_converge_bal;
    static QString distrib_band_lower_bal;
    static QString distrib_band_upper_bal;
    static QString distrib_number_sphere_bal;
    static QString distrib_number_plate_bal;
    static QString number_band_bal;
    //    static QString number_band_traced_bal;
    //    static QString number_trace_block_bal;
    static QString iaxis_bal;
    static QString rzero_bal;
    static QString rmin_bal;
    static QString ndiv_bal;
    static QString kpoint_bal;

    TraceBand( void );
    void clear( void );
    void update( void );
    bool load( DTCell& cell, NameListBuffer& nlb );
    bool save( const DTCell& cell, FILE* fptr );
  } traceband;

  struct InspectWfn{ // &inspect_wfn
    vector<QString> vdistrib_mode;
    int            idistrib_mode;

    int    output_charge;
    int    distrib_band_lower;
    int    distrib_band_upper;
    int    distrib_number_sphere;
    int    distrib_number_plate;
    int    pdos_target_atom;

    int iaxis; // for dist_mode=plate
    Position rzero;
    double rmin, rmax; // for dist_mode=sphere
    int ndiv; // for dist_mode=plate and sphere

    static QString distrib_mode_def;
    static int    output_charge_def,output_charge_min,output_charge_max;
    static int    distrib_band_lower_def,distrib_band_lower_min,distrib_band_lower_max;
    static int    distrib_band_upper_def,distrib_band_upper_min,distrib_band_upper_max;
    static int    distrib_number_sphere_def,distrib_number_sphere_min,distrib_number_sphere_max;
    static int    distrib_number_plate_def,distrib_number_plate_min,distrib_number_plate_max;
    static int    pdos_target_atom_def,pdos_target_atom_min,pdos_target_atom_max;
    static int    iaxis_def,iaxis_min,iaxis_max;
    static double rzero_def,rzero_min,rzero_max;
    static double rmin_def,rmin_min,rmin_max;
    static int    ndiv_def,ndiv_min,ndiv_max;

    static bool distrib_mode_expert, distrib_mode_manual;
    static bool output_charge_expert, output_charge_manual;
    static bool distrib_band_lower_expert, distrib_band_lower_manual;
    static bool distrib_band_upper_expert, distrib_band_upper_manual;
    static bool distrib_number_sphere_expert, distrib_number_sphere_manual;
    static bool distrib_number_plate_expert, distrib_number_plate_manual;
    static bool pdos_target_atom_expert, pdos_target_atom_manual;
    static bool iaxis_expert,iaxis_manual;
    static bool rzero_expert,rzero_manual;
    static bool rmanual_expert,rmanual_manual;
    static bool rmin_expert,rmin_manual;
    static bool ndiv_expert,ndiv_manual;

    static QString distrib_mode_bal;
    static QString output_charge_bal;
    static QString distrib_band_lower_bal;
    static QString distrib_band_upper_bal;
    static QString distrib_number_sphere_bal;
    static QString distrib_number_plate_bal;
    static QString pdos_target_atom_bal;
    static QString iaxis_bal;
    static QString rzero_bal;
    static QString rmanual_bal;
    static QString rmin_bal;
    static QString ndiv_bal;

    InspectWfn( void );
    void clear( void );
    void update( void );
    bool load( NameListBuffer& nlb );
    bool save( FILE* fptr );

  } inspectwfn;

  struct StmInput{ // &stminput
    double stm_fermi_energy;
    vector<double> vs; // [0:number_bias-1]

    static double stm_fermi_energy_def,stm_fermi_energy_min,stm_fermi_energy_max;
    static double vs_def, vs_min, vs_max;

    static bool stm_fermi_energy_expert, stm_fermi_energy_manual;
    static bool vs_expert, vs_manual;

    static QString stm_fermi_energy_bal;
    static QString vs_bal;

    StmInput( void );
    void clear( void );
    void update( void );
    bool load( NameListBuffer& nlb );
    bool save( FILE* fptr );

    bool isset( void ) const {
      return !vs.empty();
    }

    double vs_shown;
    int  index_shown;
    void add( void );
    void del( void );
    void change_shown( void );
    void update_shown( void );
    int  size_shown( void );
  } stminput;

  struct MolDyn{ // &mol_dyn
    vector<QString> vmd_mode;
    int            imd_mode;

    double delta_time;
    int    init_md_step;
    int    end_md_step;
    int    mode_xtrap_rho_wfn;
    int    message_cycle;
    double system_volume;
    double system_kbt;
    double system_pressure;
    double stern_omega_zeta;
    double stern_omega_eta;
    double stern_zeta;
    double stern_eta;
    double stern_sigma;
    int    abinitio_cycle;

    static QString md_mode_def;
    static double delta_time_def,delta_time_min,delta_time_max;
    static int    init_md_step_def,init_md_step_min,init_md_step_max;
    static int    end_md_step_def,end_md_step_min,end_md_step_max;
    static int    mode_xtrap_rho_wfn_def,mode_xtrap_rho_wfn_min,mode_xtrap_rho_wfn_max;
    static int    message_cycle_def,message_cycle_min,message_cycle_max;
    static double system_volume_def,system_volume_min,system_volume_max;
    static double system_kbt_def,system_kbt_min,system_kbt_max;
    static double system_pressure_def,system_pressure_min,system_pressure_max;
    static double stern_omega_zeta_def,stern_omega_zeta_min,stern_omega_zeta_max;
    static double stern_omega_eta_def,stern_omega_eta_min,stern_omega_eta_max;
    static double stern_zeta_def,stern_zeta_min,stern_zeta_max;
    static double stern_eta_def,stern_eta_min,stern_eta_max;
    static double stern_sigma_def,stern_sigma_min,stern_sigma_max;
    static int    abinitio_cycle_def,abinitio_cycle_min,abinitio_cycle_max;

    static bool md_mode_expert, md_mode_manual;
    static bool delta_time_expert, delta_time_manual;
    static bool init_md_step_expert, init_md_step_manual;
    static bool end_md_step_expert, end_md_step_manual;
    static bool mode_xtrap_rho_wfn_expert, mode_xtrap_rho_wfn_manual;
    static bool message_cycle_expert, message_cycle_manual;
    static bool system_volume_expert, system_volume_manual;
    static bool system_kbt_expert, system_kbt_manual;
    static bool system_pressure_expert, system_pressure_manual;
    static bool stern_omega_zeta_expert, stern_omega_zeta_manual;
    static bool stern_omega_eta_expert, stern_omega_eta_manual;
    static bool stern_zeta_expert, stern_zeta_manual;
    static bool stern_eta_expert, stern_eta_manual;
    static bool stern_sigma_expert, stern_sigma_manual;
    static bool abinitio_cycle_expert, abinitio_cycle_manual;

    static QString md_mode_bal;
    static QString delta_time_bal;
    static QString init_md_step_bal;
    static QString end_md_step_bal;
    static QString mode_xtrap_rho_wfn_bal;
    static QString message_cycle_bal;
    static QString system_volume_bal;
    static QString system_kbt_bal;
    static QString system_pressure_bal;
    static QString stern_omega_zeta_bal;
    static QString stern_omega_eta_bal;
    static QString stern_zeta_bal;
    static QString stern_eta_bal;
    static QString stern_sigma_bal;
    static QString abinitio_cycle_bal;

    MolDyn( void );
    void clear( void );
    void update( void );
    bool load( DTAtoms& atoms, NameListBuffer& nlb );
    bool save( const DTAtoms& atoms, FILE* fptr );

  } moldyn;

  struct Filemap { // &filemap
    QString basename;

    static QString basename_def;
    static bool basename_expert, basename_manual;
    static QString basename_bal;

    Filemap( void );
    void clear( void );
    void update( void );
    bool load( DTLattice& lattice, NameListBuffer& nlb );
    bool save( const DTLattice& lattice, FILE* fptr );
  } filemap;


};

#endif // __DTXTAPP_H_INCLUDED
