/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file fraction.h
 \brief LNX
*/

#ifndef __FRACTION_H_INCLUDED
#define __FRACTION_H_INCLUDED

// Ln/d̉Z@\tϐ̃NX
class fraction
{
public:
  int numerator;
  int denominator;
public:
  fraction( void ){}
  fraction( const double d ){
    const double eps = 1.0e-6;

    for( denominator=1; denominator<=10; denominator++ ){
      for( numerator=-denominator; numerator<=+denominator; numerator++ ){
	double d0 = double(numerator)/double(denominator);
	if( fabs(d-d0)<eps ){
	  return;
	}
      }
    }
    // not found
    numerator   =  0;
    denominator =  0;
  }

  fraction( const int num, const int den=1 ){
    numerator   = num;
    denominator = den;
    cancel();
  }

private:
  fraction cancel( void ){
    int a = numerator   >= 0 ? numerator   : (-1)*numerator;
    int b = denominator >= 0 ? denominator : (-1)*denominator;

    int m;
    while( (m=a%b) != 0 ){
      a = b;
      b = m;
    }
    numerator   /= b;
    denominator /= b;

    return *this;
  }

public:
  static int common_denominator( const int d1, const int d2 ){
    int a = d1 >= 0 ? d1 : (-1)*d1;
    int b = d2 >= 0 ? d2 : (-1)*d2;

    int m;
    while( (m=a%b) != 0 ){
      a = b;
      b = m;
    }

    return (d1/b)*(d2/b)*b;
  }

public:
  bool isvalid( void ) const {
    return denominator > 0;
  }
  int toInteger( void ) const {
    return denominator == 1 ? numerator : numerator/denominator;
  }
  double toDouble( void ) const {
    return (double)numerator/(double)denominator;
  }

  bool operator == ( const fraction& that ) const {
    return 
      this->numerator   == that.numerator &&
      this->denominator == that.denominator;
  }

  bool operator != ( const fraction& that ) const {
    return 
      this->numerator   != that.numerator ||
      this->denominator != that.denominator;
  }

  fraction operator += ( const fraction& that ){
    this->numerator =
      + this->numerator *  that.denominator
      +  that.numerator * this->denominator;
    this->denominator =
      this->denominator * that.denominator;
    cancel();

    return *this;
  }

  friend fraction operator * ( int i, const fraction& that ){
    fraction result;

    result.numerator   = i*that.numerator;
    result.denominator =   that.denominator;

    return result.cancel();
  }

  friend fraction operator * ( const fraction& that, int i ){
    fraction result;

    result.numerator   = that.numerator*i;
    result.denominator = that.denominator;

    return result.cancel();
  }
};

#endif // __FRACTION_H_INCLUDED
