/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glatoms.h
 \brief iq̌qGL\̃NX
*/

#ifndef __GLATOMS_H_INCLUDED
#define __GLATOMS_H_INCLUDED

#include "glbase.h"

class DTModel;
class DTAtom;
class Position;
class QGLWidget;

class GLAtoms : public GLBase
{
private:
  DTModel& model;
  QGLWidget* qglwidget;

public:
  GLAtoms( DTModel& _model, QGLWidget* _qglwidget ) :
    model(_model), qglwidget(_qglwidget) {}

private:
  void makeAtom( const DTAtom& atom );
  void makeAtom( const DTAtom& atom, const Position& L );
  void makeAtomSelected( const DTAtom& atom, const int selected );

public:
  void draw( void );
  void select( void );
  void update( void );
  void updateClustering( void );
};

#endif // __GLATOMS_H_INCLUDED
