/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glband.h
 \brief ohGL\̃NX
*/

#ifndef __GLBAND_H_INCLUDED
#define __GLBAND_H_INCLUDED

#include <QtGui/QtGui>
#include <QtOpenGL/QGLWidget>

class DTModel;

class GLBand : public QGLWidget
{
  Q_OBJECT

private:
  int marginL;
  int marginR;
  int marginT;
  int marginB;
  int win_width, win_height;
  int grp_width, grp_height;

private:
  DTModel& model;

  QAction* action_both_spin;
  QAction* action_up_spin;
  QAction* action_dw_spin;
  QAction* action_def_ord;
  QAction* action_asc_ord;
  QAction* action_nat_ord;
  QAction* action_colorful;
  QAction* action_lines;
  QAction* action_points;

  bool show_up, show_dw;

  QString path;
  
public:
  GLBand( DTModel& _model );

signals:
  void changed( void );
public slots:
  void update( void );
public:
  void draw( void );

protected:
  void initializeGL( void );
  void paintGL( void );
  bool paintEPS( const QString& fname );
  void resizeGL( int width, int height );

  int  x_down, y_down;
  void mousePressEvent( QMouseEvent* ev );
  void mouseReleaseEvent( QMouseEvent* ev );
  void mouseMoveEvent ( QMouseEvent* ev );
  void mouseDoubleClickEvent( QMouseEvent* ev );
  void keyPressEvent( QKeyEvent* ev );
  void keyReleaseEvent( QKeyEvent* ev );
  void wheelEvent( QWheelEvent* ev );

  QMenu*    popupmenu;
  void contextMenuEvent( QContextMenuEvent* ev );
private slots:
  void menuEvent( QAction* action );

private:
  void scroll( int dx, int dy );
};

#endif // __GLBAND_H_INCLUDED
