/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#include <GL/gl.h>
#include "dtmodel.h"
#include "glmisc.h"
#include "glbar.h"
#include <QtOpenGL/QGLWidget>

void GLBar::update( void )
{
  const int win_width  = glGetWindowWidth();
  const int win_height = glGetWindowHeight();

  int xo = 8;
  int yo = win_height - 32;
  const int bar_width = 16;
  const int bar_height = 128;

  GLBase::beginNewList();

  glDisable( GL_DEPTH_TEST );
  glDisable( GL_LIGHTING );
  glColor4dv( GLcolor::white );

  glMatrixMode( GL_MODELVIEW );
  glPushMatrix();
  glLoadIdentity();
  
  glMatrixMode( GL_PROJECTION );
  glPushMatrix();
  glLoadIdentity();
  gluOrtho2D( 0.0, (GLfloat)win_width, (GLfloat)win_height, 0.0 );

  // NbsÖꎞIȉ
  bool clipping[6];
  for( int p=0; p<6; p++ ){
    clipping[p] = glIsEnabled( GL_CLIP_PLANE0+p );
    glDisable( GL_CLIP_PLANE0+p );
  }
  
  glBegin( GL_QUAD_STRIP );
  for( double f=0.0; f<=1.0; f+=1.0/16 ){
    glColor4dv( model.gloption.field.gradation(f) );
    glVertex2d( xo, yo-f*bar_height );
    glVertex2d( xo+bar_width, yo-f*bar_height );
  }
  glEnd();
  glColor4dv( GLcolor::white );
  glBegin( GL_LINE_LOOP );
  glVertex2d( xo, yo );
  glVertex2d( xo, yo-bar_height );
  glVertex2d( xo+bar_width, yo-bar_height );
  glVertex2d( xo+bar_width, yo );
  glEnd();

  // NbsO̕
  for( int p=0; p<6; p++ ){
    if( clipping[p] ){
      glEnable( GL_CLIP_PLANE0+p );
    }
  }
  
  glPopMatrix();
  glMatrixMode( GL_MODELVIEW );
  glPopMatrix();
  
  glEnable( GL_LIGHTING );
  glEnable( GL_DEPTH_TEST );

  GLBase::endNewList();
}


void GLBar::draw( void )
{
  GLBase::draw();

  const int win_width  = glGetWindowWidth();
  const int win_height = glGetWindowHeight();

  int xo = 8;
  int yo = win_height - 32;
  const int bar_height = 128;

  glDisable( GL_DEPTH_TEST );
  glDisable( GL_LIGHTING );
  glColor4dv( GLcolor::white );

  glMatrixMode( GL_MODELVIEW );
  glPushMatrix();
  glLoadIdentity();
  
  glMatrixMode( GL_PROJECTION );
  glPushMatrix();
  glLoadIdentity();
  gluOrtho2D( 0.0, (GLfloat)win_width, (GLfloat)win_height, 0.0 );

  // NbsÖꎞIȉ
  bool clipping[6];
  for( int p=0; p<6; p++ ){
    clipping[p] = glIsEnabled( GL_CLIP_PLANE0+p );
    glDisable( GL_CLIP_PLANE0+p );
  }
  
  if( model.gloption.field.range_manual ){
    char text[32];
    glColor4dv( GLcolor::red );

    snprintf( text, sizeof(text), "%+9.1e",
	      model.gloption.field.data_min );
    qglwidget->renderText( double(xo-8), double(yo+16), 0.0, QString(text));

    snprintf( text, sizeof(text), "%+9.1e",
	      model.gloption.field.data_max );
    qglwidget->renderText( double(xo-8), double(yo-bar_height-8), 0.0, QString(text));
  }
  else{
    char text[32];
    glColor4dv( model.gloption.window.foreground );
    snprintf( text, sizeof(text), "%+9.1e",
	      model.field.data_min() );
    qglwidget->renderText( double(xo-8), double(yo+16), 0.0, QString(text));

    snprintf( text, sizeof(text), "%+9.1e",
	      model.field.data_max() );
    qglwidget->renderText( double(xo-8), double(yo-bar_height-8), 0.0, QString(text));
  }

  // NbsO̕
  for( int p=0; p<6; p++ ){
    if( clipping[p] ){
      glEnable( GL_CLIP_PLANE0+p );
    }
  }
  
  glPopMatrix();
  glMatrixMode( GL_MODELVIEW );
  glPopMatrix();
  
  glEnable( GL_LIGHTING );
  glEnable( GL_DEPTH_TEST );
}
