/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glbase.cc
 \brief GLIuWFNg̕`{NX
*/

#include "glbase.h"

GLBase::GLBase( void )
{
  list = 0;
  changed = true;
}

GLBase::~GLBase( void )
{
  if( !list ) glDeleteLists(list,1);
  list = 0;
  changed = true;
}

void GLBase::beginNewList( void )
{
  if( !list ) list = glGenLists(1);
  glNewList( list, GL_COMPILE );
}

void GLBase::endNewList( void )
{
  glEndList();
  changed = false;
}

bool GLBase::isChanged( void ) const
{
  return changed;
}

void GLBase::change( void )
{
  changed = true;
}

void GLBase::draw( void )
{
  if( isChanged() ) this->update();
  if( list ) glCallList( list );
}
