/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glbonds.h
 \brief iq̌GL\̃NX
*/

#ifndef __GLBONDS_H_INCLUDED
#define __GLBONDS_H_INCLUDED

#include "glbase.h"

class DTModel;
class DTAtom;
class Position;

class GLBonds : public GLBase
{
private:
  DTModel& model;

public:
  GLBonds( DTModel& _model ) : model(_model) {}

private:
  void makeBond( const DTAtom& atom1, const DTAtom& atom2 );
  void makeBond( const DTAtom& atom1, const DTAtom& atom2, const Position& L );
public:
  void update( void );
};

#endif // __GLBONDS_H_INCLUDED
