/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glbrillouin.h
 \brief uA][GL\̃NX
*/

#ifndef __GLBRILLOUIN_H_INCLUDED
#define __GLBRILLOUIN_H_INCLUDED

#include <QtGui/QtGui>
#include <QtOpenGL/QGLWidget>
#include "glbase.h"

class DTModel;

class GLBrillouin : public QGLWidget
{
  Q_OBJECT

private:
  DTModel& model;

public:
  GLBrillouin( DTModel& _model );

signals:
  void changed( void );
public slots:
  void update( void );

protected:
  void initializeGL( void );
  void paintGL( void );
  void resizeGL( int width, int height );

  bool perspective;
  int  x_down, y_down;
  void mousePressEvent( QMouseEvent* ev );
  void mouseReleaseEvent( QMouseEvent* ev );
  void mouseMoveEvent ( QMouseEvent* ev );
  void mouseDoubleClickEvent( QMouseEvent* ev );
  void keyPressEvent( QKeyEvent* ev );
  void keyReleaseEvent( QKeyEvent* ev );
  void wheelEvent( QWheelEvent* ev );
  QMenu*    popupmenu;
  void contextMenuEvent( QContextMenuEvent* ev );

private slots:
  void menuEvent( QAction* action );

public:
  void draw( void );
  void select( void );
  bool save( void ); 
  void clear( void );

private:
  void gluProjection( int width, int height, bool perspective );
};

#endif // __GLBRILLOUIN_H_INCLUDED
