/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glcell.cc
 \brief iq̒PʖEGL\̃NX
*/

#include <GL/gl.h>
#include "dtmodel.h"
#include "glcell.h"
#include <QtOpenGL/QGLWidget>

void GLCell::updateClustering( void )
{
  /*
  const double&  L  = model.lattice.cell.length;
  const Position La = model.lattice.cluster.Ea*L;
  const Position Lb = model.lattice.cluster.Eb*L;
  const Position Lc = model.lattice.cluster.Ec*L;
  */
  const Position La = model.lattice.cluster.La;
  const Position Lb = model.lattice.cluster.Lb;
  const Position Lc = model.lattice.cluster.Lc;
  const Position Lo = model.lattice.cell.Lo;

  glPushMatrix(); {
    double mat[4][4];
  
    mat[0][0] = La.x, mat[0][1] = La.y, mat[0][2] = La.z, mat[0][3] = 0.0;
    mat[1][0] = Lb.x, mat[1][1] = Lb.y, mat[1][2] = Lb.z, mat[1][3] = 0.0;
    mat[2][0] = Lc.x, mat[2][1] = Lc.y, mat[2][2] = Lc.z, mat[2][3] = 0.0;
    mat[3][0] = Lo.x, mat[3][1] = Lo.y, mat[3][2] = Lo.z, mat[3][3] = 1.0;
    glMultMatrixd((double*)mat);
  }

  glColor4dv(  model.gloption.lattice.cell.color_selected );

  // PʖE̘g̕\
  glBegin( GL_LINE_LOOP );
  glVertex3d( 0.0, 0.0, 0.0 );
  glVertex3d( 1.0, 0.0, 0.0 );
  glVertex3d( 1.0, 1.0, 0.0 );
  glVertex3d( 0.0, 1.0, 0.0 );
  glEnd();

  glBegin( GL_LINE_LOOP );
  glVertex3d( 0.0, 0.0, 1.0 );
  glVertex3d( 1.0, 0.0, 1.0 );
  glVertex3d( 1.0, 1.0, 1.0 );
  glVertex3d( 0.0, 1.0, 1.0 );
  glEnd();

  glBegin( GL_LINES );
  glVertex3d( 0.0, 0.0, 0.0 );
  glVertex3d( 0.0, 0.0, 1.0 );
  glVertex3d( 1.0, 0.0, 0.0 );
  glVertex3d( 1.0, 0.0, 1.0 );
  glVertex3d( 0.0, 1.0, 0.0 );
  glVertex3d( 0.0, 1.0, 1.0 );
  glVertex3d( 1.0, 1.0, 0.0 );
  glVertex3d( 1.0, 1.0, 1.0 );
  glEnd();

  glPopMatrix();
}

void GLCell::update( void )
{
  const Position& La = model.lattice.cell.La;
  const Position& Lb = model.lattice.cell.Lb;
  const Position& Lc = model.lattice.cell.Lc;
  const Position& Lo = model.lattice.cell.Lo;

  GLcolor color = model.gloption.lattice.cell.color;

  GLBase::beginNewList();
  glDisable( GL_LIGHTING );

  if( model.lattice.isclustering() ){
    updateClustering();
  }


  glPushMatrix(); {
    double mat[4][4];
  
    mat[0][0] = La.x, mat[0][1] = La.y, mat[0][2] = La.z, mat[0][3] = 0.0;
    mat[1][0] = Lb.x, mat[1][1] = Lb.y, mat[1][2] = Lb.z, mat[1][3] = 0.0;
    mat[2][0] = Lc.x, mat[2][1] = Lc.y, mat[2][2] = Lc.z, mat[2][3] = 0.0;
    mat[3][0] = Lo.x, mat[3][1] = Lo.y, mat[3][2] = Lo.z, mat[3][3] = 1.0;
    glMultMatrixd((double*)mat);
  }

  glColor4dv( color );

  // PʖE̘g̕\
  {
    glBegin( GL_LINE_LOOP );
    glVertex3d( 0.0, 0.0, 0.0 );
    glVertex3d( 1.0, 0.0, 0.0 );
    glVertex3d( 1.0, 1.0, 0.0 );
    glVertex3d( 0.0, 1.0, 0.0 );
    glEnd();

    glBegin( GL_LINE_LOOP );
    glVertex3d( 0.0, 0.0, 1.0 );
    glVertex3d( 1.0, 0.0, 1.0 );
    glVertex3d( 1.0, 1.0, 1.0 );
    glVertex3d( 0.0, 1.0, 1.0 );
    glEnd();

    glBegin( GL_LINES );
    glVertex3d( 0.0, 0.0, 0.0 );
    glVertex3d( 0.0, 0.0, 1.0 );
    glVertex3d( 1.0, 0.0, 0.0 );
    glVertex3d( 1.0, 0.0, 1.0 );
    glVertex3d( 0.0, 1.0, 0.0 );
    glVertex3d( 0.0, 1.0, 1.0 );
    glVertex3d( 1.0, 1.0, 0.0 );
    glVertex3d( 1.0, 1.0, 1.0 );
    glEnd();
  }

  // _ʂW̕\
  {
    const Coordinates origin =
      model.gloption.location.scroll(Coordinates(0.0,0.0,0.0));
    glBegin( GL_LINE_LOOP );
    glVertex3d( origin.a, 0.0, 0.0 );
    glVertex3d( origin.a, 1.0, 0.0 );
    glVertex3d( origin.a, 1.0, 1.0 );
    glVertex3d( origin.a, 0.0, 1.0 );
    glEnd();
    glBegin( GL_LINE_LOOP );
    glVertex3d( 0.0, origin.b, 0.0 );
    glVertex3d( 1.0, origin.b, 0.0 );
    glVertex3d( 1.0, origin.b, 1.0 );
    glVertex3d( 0.0, origin.b, 1.0 );
    glEnd();
    glBegin( GL_LINE_LOOP );
    glVertex3d( 0.0, 0.0, origin.c );
    glVertex3d( 1.0, 0.0, origin.c );
    glVertex3d( 1.0, 1.0, origin.c );
    glVertex3d( 0.0, 1.0, origin.c );
    glEnd();
    glBegin( GL_LINES );
    glVertex3d( 0.0, origin.b, origin.c );
    glVertex3d( 1.0, origin.b, origin.c );
    glVertex3d( origin.a, 0.0, origin.c );
    glVertex3d( origin.a, 1.0, origin.c );
    glVertex3d( origin.a, origin.b, 0.0 );
    glVertex3d( origin.a, origin.b, 1.0 );
    glEnd();
  }


  glPopMatrix();

  glEnable( GL_LIGHTING );

  // XYZ̖`
  if( model.gloption.lattice.axis.show &&
      !model.gloption.location.wigner &&
      model.gloption.location.extendA == 0 && 
      model.gloption.location.extendB == 0 && 
      model.gloption.location.extendC == 0 ){
    glPushMatrix();

    const double L = Position::length(La + Lb + Lc)*(1.0/8);
    glTranslated( Lo.x-L, Lo.y-L, Lo.z-L );

    const double   radius = L*(1.0/32);
    const Position O = Position( 0.0, 0.0, 0.0 );
    const Position X = Position(   L, 0.0, 0.0 );
    const Position Y = Position( 0.0,   L, 0.0 );
    const Position Z = Position( 0.0, 0.0,   L );

    glMaterialdv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, GLcolor::red );
    gluSolidStick( radius, O, X*0.75, 16 );
    gluSolidCone( radius*2.0, X*0.75, X, 16 );

    glMaterialdv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, GLcolor::green );
    gluSolidStick( radius, O, Y*0.75, 16 );
    gluSolidCone( radius*2.0, Y*0.75, Y, 16 );

    glMaterialdv( GL_FRONT, GL_AMBIENT_AND_DIFFUSE, GLcolor::blue );
    gluSolidStick( radius, O, Z*0.75, 16 );
    gluSolidCone( radius*2.0, Z*0.75, Z, 16 );

    glPopMatrix();
  }

  GLBase::endNewList();
}



void GLCell::draw( void )
{
  GLBase::draw();

  const Position& La = model.lattice.cell.La;
  const Position& Lb = model.lattice.cell.Lb;
  const Position& Lc = model.lattice.cell.Lc;
  const Position& Lo = model.lattice.cell.Lo;

  GLcolor color = model.gloption.window.foreground;

  glDisable( GL_LIGHTING );

  glPushMatrix(); {
    double mat[4][4];
  
    mat[0][0] = La.x, mat[0][1] = La.y, mat[0][2] = La.z, mat[0][3] = 0.0;
    mat[1][0] = Lb.x, mat[1][1] = Lb.y, mat[1][2] = Lb.z, mat[1][3] = 0.0;
    mat[2][0] = Lc.x, mat[2][1] = Lc.y, mat[2][2] = Lc.z, mat[2][3] = 0.0;
    mat[3][0] = Lo.x, mat[3][1] = Lo.y, mat[3][2] = Lo.z, mat[3][3] = 1.0;
    glMultMatrixd((double*)mat);
  }

  glColor4dv( color );

  // \Ȃꍇ͎̃x\B
  if( !model.gloption.location.wigner &&
      model.gloption.location.extendA == 0 && 
      model.gloption.location.extendB == 0 && 
      model.gloption.location.extendC == 0 ){
    const Coordinates origin =
      model.gloption.location.scroll(Coordinates(0.0,0.0,0.0));

    const Coordinates coordA = origin+Coordinates(0.5,-1.0/16,-1.0/16);
    qglwidget->renderText( coordA.x, coordA.y, coordA.z, QString("A"));

    const Coordinates coordB = origin+Coordinates(-1.0/16,+0.5,-1.0/16);
    qglwidget->renderText( coordB.x, coordB.y, coordB.z, QString("B"));

    const Coordinates coordC = origin+Coordinates(-1.0/16,-1.0/16,+0.5);
    qglwidget->renderText( coordC.x, coordC.y, coordC.z, QString("C"));

    const Coordinates coordO = origin+Coordinates(-1.0/16,-1.0/16,-1.0/16);
    qglwidget->renderText( coordO.x, coordO.y, coordO.z, QString("O"));
  }

  glPopMatrix();

  glEnable( GL_LIGHTING );

  // XYZ̖`
  if( model.gloption.lattice.axis.show &&
      !model.gloption.location.wigner &&
      model.gloption.location.extendA == 0 && 
      model.gloption.location.extendB == 0 && 
      model.gloption.location.extendC == 0 ){
    glPushMatrix();

    const double L = Position::length(La + Lb + Lc)*(1.0/8);
    glTranslated( Lo.x-L, Lo.y-L, Lo.z-L );

    const Position O = Position( 0.0, 0.0, 0.0 );
    const Position X = Position(   L, 0.0, 0.0 );
    const Position Y = Position( 0.0,   L, 0.0 );
    const Position Z = Position( 0.0, 0.0,   L );

    qglwidget->renderText( X.x, X.y, X.z, QString("X"));
    qglwidget->renderText( Y.x, Y.y, Y.z, QString("Y"));
    qglwidget->renderText( Z.x, Z.y, Z.z, QString("Z"));

    glPopMatrix();
  }
}
