/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glcrosec.h
 \brief OtB[h̒fʐ}GL\̃NX
*/

#ifndef __GLCROSEC_H_INCLUDED
#define __GLCROSEC_H_INCLUDED

#include <QtGui/QtGui>
#include "glbase.h"
#include "vector2d.h"
#include "vector3d.h"
#include "position.h"

class DTModel;

class GLCroSec
{
protected:
  DTModel& model;

private:
  struct Node{
    bool     flag;
    Position vertex;
    
    static double distance( const Node& n1, const Node& n2 ){
      return
	+fabs(n1.vertex.x-n2.vertex.x)
	+fabs(n1.vertex.y-n2.vertex.y);
    }
  };
  vector2d<Node> nodex;
  vector2d<Node> nodey;

public:
  GLCroSec( DTModel& _model ) : model(_model) {}

protected:
  // f[^[0:1]Ki
  double data_normalized
    ( const vector3d<double>& data,
      const int ix, const int iy, const int iz );

  void makeFrame( const vector2d<double>& data,
		  const Coordinates& scroll );
  void makePlaneR( const vector2d<double>& data,
		  const Coordinates& scroll );
  void makePlaneC( const vector2d<double>& data_abs,
		   const vector2d<double>& data_arg,
		  const Coordinates& scroll );
  void makeIsolines( const vector2d<double>& data,
		  const Coordinates& scroll );
  void makeGradients( const vector2d<double>& data,
		  const Coordinates& scroll );
  void makeIsoline( const vector2d<double>& data, const double iso_level,
		  const Coordinates& scroll );
  int  indexSelected
    ( const Node& node0, const Node& node1,
      const Node& node2, const Node& node3 );
  void makeElement( int ix, int iy, double dx, double dy );
};


class GLCroSecA : public GLCroSec, public GLBase
{
public:
  GLCroSecA( DTModel& _model ) : GLCroSec(_model) {}

public:
  void update( void );
};

class GLCroSecB : public GLCroSec,  public GLBase
{
public:
  GLCroSecB( DTModel& _model ) : GLCroSec(_model) {}

public:
  void update( void );
};

class GLCroSecC : public GLCroSec,  public GLBase
{
public:
  GLCroSecC( DTModel& _model ) : GLCroSec(_model) {}

public:
  void update( void );
};

#endif // __GLCROSEC_H_INCLUDED
