/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gldos.cc
 \brief ԖxGL\̃NX
*/

#include "dtmodel.h"
#include "glmisc.h"
#include "qtmisc.h"
#include "gldos.h"
#include "gleps.h"
#include "qtexception.h"

GLDos::GLDos( DTModel& _model ) : model(_model)
{
  setFocusPolicy( Qt::ClickFocus );
  setMinimumSize( model.gloption.window.width-256, model.gloption.window.height-32 );
  setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );

  popupmenu = new QMenu(this);
  popupmenu->addSeparator();
  popupmenu->addAction( new QAction(tr("zoom energy in"),this) );
  popupmenu->addAction( new QAction(tr("zoom density in"),this) );
  popupmenu->addAction( new QAction(tr("zoom energy out"),this) );
  popupmenu->addAction( new QAction(tr("zoom density out"),this) );
  popupmenu->addAction( new QAction(tr("zoom reset"),this) );
  popupmenu->addSeparator();
  popupmenu->addAction( new QAction(tr("save image"),this) );
  connect(popupmenu, SIGNAL(triggered(QAction*)), this, SLOT(menuEvent(QAction*)));
}

void GLDos::update( void )
{
  makeCurrent();
  updateGL();
}

void GLDos::initializeGL( void )
{
}

void GLDos::resizeGL(int width, int height)
{
  glViewport( 0, 0, width, height );

  glMatrixMode( GL_PROJECTION );
  glLoadIdentity();

  gluOrtho2D( 0.0, (GLfloat)width, 0.0, (GLfloat)height );

  glMatrixMode( GL_MODELVIEW );

  glClear( GL_COLOR_BUFFER_BIT );

  // E㉺̗]̍Œx
  marginL = 80;
  marginR = 150;
  marginT = 36;
  marginB = 36;

  // EBhẼTCY
  win_width  = glGetWindowWidth();
  win_height = glGetWindowHeight();
  // Ot͈
  grp_width  = win_width  - marginL - marginR;
  grp_height = win_height - marginT - marginB;
}

static double round( double& a, double& b )
{
  double d = a-b;
  double u = pow( 10.0, rint(log10(d))-1.0 );

  while( d/u >= 8.0 ){
    u *= 2.0;
  }

  a = ceil (a/u+1.0e-8)*u;
  b = floor(b/u)*u;

  return u;
}

void GLDos::paintGL( void )
{
  char label[32];

  glClearColor( model.gloption.dos.background );
  glClear( GL_COLOR_BUFFER_BIT );

  if( !model.dos.isset() ) return;

  const double emin = model.gloption.dos.emin;
  const double emax = model.gloption.dos.emax;
  const double dmin = model.gloption.dos.dmin;
  const double dmax = model.gloption.dos.dmax;

  //Ot_`W_Ɉړ
  glPushMatrix();
  glLoadIdentity();
  glTranslated( (double)marginL, (double)marginB, 0.0 );

  // Otg̕`
  {
    glColor4dv( model.gloption.dos.foreground );
    glBegin( GL_LINE_LOOP );
    glVertex2d( 0, -1 );
    glVertex2d( grp_width, -1 );
    glVertex2d( grp_width, grp_height+1 );
    glVertex2d( 0, grp_height+1 );
    glEnd();

    if( model.dos.dmin<0.0 ){ // nspin=2
      glBegin( GL_LINES );
      glVertex2d( 0, grp_height/2 );
      glVertex2d( grp_width, grp_height/2 );
      glEnd();
    }
  }

  // }̕`
  {
    glPushMatrix();
    glTranslated( grp_width+5, grp_height-20, 0.0 );

    // }̐
    glBegin( GL_LINES );

    for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
      double f = 
	model.dos.sizeData1() == 0 ? 0.0 :
	(double)i/(model.dos.sizeData1()-1);
      glColor4dv(model.gloption.dos.gradation(f));
      glVertex2d(  0, -(i)*16 );
      glVertex2d( 50, -(i)*16 );
    }
    glEnd();

    // }̃x
    for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
      double f =
	model.dos.sizeData1() == 0 ? 0.0 :
	(double)i/(model.dos.sizeData1()-1);
      glColor4dv(model.gloption.dos.gradation(f));
      renderText( +55, -5-(i)*16, 0.0,
		  model.dos.vdata[0][i].title );
    }

    glPopMatrix();
  }

  // ̖O̕`
  {
    glColor4dv( model.gloption.dos.foreground );
    // 
    renderText( grp_width/2, -24, 0.0, QString("energy"));

    // c
    if( model.dos.dmin<0.0 ){ // nspin=2
      renderText( -50, grp_height+5, 0.0, QString("dos up"));
      renderText( -50, 0, 0.0, QString("dos down"));
    }
    else{
      renderText( -40, grp_height+5, 0.0, QString("dos"));
    }
  }



  // Wn̕ύXAf[^̂̂vbgŏ̍Wɕ`ł
  {
    glPushMatrix();
    glScaled( double(grp_width)/(emax-emin),
	      double(grp_height)/(dmax-dmin), 0.0 );
    glTranslated( -emin, -dmin, 0.0 );

    // ڐ胉x̕`
    {
      const int N = 8;

      // c
      {
	glPushMatrix();
	glTranslateR( -70, -10, 0.0 );

	double dD = dmax - dmin;
	double D0 = 0.0;
	round( dD, D0 );
	dD = dD/N;

	const int is=(int)ceil (dmin/dD);
	const int ie=(int)floor(dmax/dD);

	glColor4dv( model.gloption.dos.foreground );
	for( int i=is; i<=ie; i++ ){
	  double D = dD*i;
	  sprintf( label, "%+.*e", 1, D );
	  renderText( emin, D, 0.0, QString(label));
	}
	glPopMatrix();
      }

      // 
      {
	glPushMatrix();
	glTranslateR( -16, -12, 0.0 );

	double dE = emax - emin;
	double E0 = 0.0;
	round( dE, E0 );
	dE = dE/N;

	const int is=(int)ceil (emin/dE);
	const int ie=(int)floor(emax/dE);

	glColor4dv( model.gloption.dos.foreground );
	for( int i=is; i<=ie; i++ ){
	  double E = dE*i;
	  sprintf( label, "%+5.1f", E );
	  renderText( E, dmin, 0.0, QString(label));
	}
	glPopMatrix();
      }
    }
    
    // Obh̕`
    {
      const int N = 8;

      // Obh
      {      
	double dD = dmax - dmin;
	double D0 = 0.0;
	round( dD, D0 );
	dD = dD/N;
      
	const int is=(int)ceil (dmin/dD);
	const int ie=(int)floor(dmax/dD);
	
	glColor4dv( model.gloption.dos.background*0.75
		    +model.gloption.dos.foreground*0.25 );
	glBegin( GL_LINES );
	for( int i=is; i<=ie; i++ ){
	  double D = dD*i;
	  glVertex2d( emin, D );
	  glVertex2d( emax, D );
	}
	glEnd();
      }

      // Obhc
      {      
	double dE = emax - emin;
	double E0 = 0.0;
	round( dE, E0 );
	dE = dE/N;
      
	const int is=(int)ceil (emin/dE);
	const int ie=(int)floor(emax/dE);
      

	glColor4dv( model.gloption.dos.background*0.75
		    +model.gloption.dos.foreground*0.25 );
	glBegin( GL_LINES );
	for( int i=is; i<=ie; i++ ){
	  double E = dE*i;
	  glVertex2d( E, dmin );
	  glVertex2d( E, dmax );
	}
	glEnd();
      }
    }
    
    // f[^̕`
    {
      // DOS
      for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
	double f =
	  model.dos.sizeData1() == 0 ? 0.0 :
	  (double)i/(model.dos.sizeData1()-1);
	glColor4dv(model.gloption.dos.gradation(f));
	int n=0;
	double Epre=0.0,Dpre=0.0;
	bool   Fpre=false;
	for( int ie=0; ie<model.dos.sizeEnergy(); ie++ ){
	  double E = model.dos.vdata[0][i].energy[ie];
	  double D = model.dos.vdata[0][i].dos[ie];
	  // ͈͊O
	  if( E<emin || emax<E ){
	    // ͈͓Oɏoꍇ
	    if( n>0 ){
	      // Ԃ_܂Ő`
	      if( Fpre && E>emax ){
		glVertex2d( emax, (D-Dpre)/(E-Epre)*(emax-Epre)+Dpre );
		glEnd();
		n=0;
	      }
	    }
	    Epre=E;
	    Dpre=D;
	    Fpre=true;
	    continue;
	  }

	  // c͈͓
	  if( dmin<=D && D<=dmax ){
	    // ߂Ă͈͓̔
	    if( n==0 ){
	      glBegin( GL_LINE_STRIP );
	      if( false );
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre>dmax && E>=emin ){
		glVertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	      }
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre<dmin && E>=emin ){
		glVertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	      }
	      // O_͈͊ȌꍇɕԂ_`
	      else if( Fpre && Epre<emin ){
		glVertex2d( emin, (D-Dpre)/(E-Epre)*(emin-Epre)+Dpre );
	      }
	    }
	    // `
	    glVertex2d( E, D );
	    n++;
	  }
	  // c͈͊O
	  else if(n>0){
	    if( false );
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D>dmax){
	      glVertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	    }
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D<dmin){
	      glVertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	    }
	    glEnd();
	    n=0;
	  }
	  Epre=E;
	  Dpre=D;
	  Fpre=true;
	}
	if(n>0) glEnd(),n=0;
      }
    }
    if( model.dos.dmin<0.0 ){ // nspin=2
      // DOS
      for( int i=0; i<(int)model.dos.sizeData2(); i++ ){
	double f = 
	  model.dos.sizeData2() == 0 ? 0.0 :
	  (double)i/(model.dos.sizeData2()-1);
	glColor4dv(model.gloption.dos.gradation(f));
	int n=0;
	double Epre=0.0,Dpre=0.0;
	bool   Fpre=false;
	for( int ie=0; ie<model.dos.sizeEnergy(); ie++ ){
	  double E = model.dos.vdata[0][i].energy[ie];
	  double D = model.dos.vdata[1][i].dos[ie];
	  // ͈͊O
	  if( E<emin || emax<E ){
	    // ͈͓Oɏoꍇ
	    if( n>0 ){
	      // Ԃ_܂Ő`
	      if( Fpre && E>emax ){
		glVertex2d( emax, (D-Dpre)/(E-Epre)*(emax-Epre)+Dpre );
		glEnd();
		n=0;
	      }
	    }
	    Epre=E;
	    Dpre=D;
	    Fpre=true;
	    continue;
	  }

	  // c͈͓
	  if( dmin<=D && D<=dmax ){
	    // ߂Ă͈͓̔
	    if( n==0 ){
	      glBegin( GL_LINE_STRIP );
	      if( false );
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre>dmax && E>=emin ){
		glVertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	      }
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre<dmin && E>=emin ){
		glVertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	      }
	      // O_͈͊ȌꍇɕԂ_`
	      else if( Fpre && Epre<emin ){
		glVertex2d( emin, (D-Dpre)/(E-Epre)*(emin-Epre)+Dpre );
	      }
	    }
	    // `
	    glVertex2d( E, D );
	    n++;
	  }
	  // c͈͊O
	  else if(n>0){
	    if( false );
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D>dmax){
	      glVertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	    }
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D<dmin){
	      glVertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	    }
	    glEnd();
	    n=0;
	  }
	  Epre=E;
	  Dpre=D;
	  Fpre=true;
	}
	if(n>0) glEnd(),n=0;
      }
    }
    glPopMatrix();
  }

  glPopMatrix();
}

bool GLDos::paintEPS( const QString& fname )
{
  char label[32];

  if( !model.dos.isset() ) return false;

  const double emin = model.gloption.dos.emin;
  const double emax = model.gloption.dos.emax;
  const double dmin = model.gloption.dos.dmin;
  const double dmax = model.gloption.dos.dmax;

  GLEPS eps;
  if( !eps.open( qPrintable(fname),
		 win_width, win_height, 100.0, 100.0*win_height/win_width ) ){
    return false;
  }

  eps.font( "/Times-Roman", 20.0 );

  eps.pushMatrix();
  eps.loadIdentity();
  eps.translated( (double)marginL, (double)marginB, 0.0 );

  // Otg̕`
  {
    eps.color4dv( model.gloption.dos.foreground );
    eps.lineWidth(1.0);
    eps.begin( GL_LINE_LOOP );
    eps.vertex2d( 0, -1 );
    eps.vertex2d( grp_width, -1 );
    eps.vertex2d( grp_width, grp_height+1 );
    eps.vertex2d( 0, grp_height+1 );
    eps.end();

    if( model.dos.dmin<0.0 ){ // nspin=2
      eps.begin( GL_LINES );
      eps.vertex2d( 0, grp_height/2 );
      eps.vertex2d( grp_width, grp_height/2 );
      eps.end();
    }
  }

  // }̕`
  {
    eps.pushMatrix();
    eps.translated( grp_width+5, grp_height-20, 0.0 );

    // }̐

    for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
      double f =
	model.dos.sizeData1() == 0 ? 0.0 :
	(double)i/(model.dos.sizeData1()-1);
      eps.color4dv(model.gloption.dos.gradation(f));
      eps.begin( GL_LINES );
      eps.vertex2d(  0, -(i)*16 );
      eps.vertex2d( 50, -(i)*16 );
      eps.end();
    }

    // }̃x
    for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
      double f =
	model.dos.sizeData1() == 0 ? 0.0 :
	(double)i/(model.dos.sizeData1()-1);
      eps.color4dv(model.gloption.dos.gradation(f));
      eps.renderText( +55, -5-(i)*16, 0.0,
		      model.dos.vdata[0][i].title );
    }
    eps.popMatrix();
  }

  // ̖O̕`
  {
    eps.color4dv( model.gloption.dos.foreground );
    // 
    eps.renderText( grp_width/2, -30, 0.0, QString("energy") );

    // c
    if( model.dos.dmin<0.0 ){ // nspin=2
      eps.renderText( -60, grp_height, 0.0, QString("dos up"));
      eps.renderText( -60, 0, 0.0, QString("dos down"));
    }
    else{
      eps.renderText( -40, grp_height-5, 0.0, QString("dos") );
    }
  }

  // Wn̕ύXAf[^̂̂vbgŏ̍Wɕ`ł
  {
    eps.pushMatrix();
    eps.scaled( double(grp_width)/(emax-emin),
	      double(grp_height)/(dmax-dmin), 0.0 );
    eps.translated( -emin, -dmin, 0.0 );

    // ڐ胉x̕`
    {
      const int N = 8;

      // c
      {
	eps.pushMatrix();
	eps.translateR( -90, -5, 0.0 );

	double dD = dmax - dmin;
	double D0 = 0.0;
	round( dD, D0 );
	dD = dD/N;

	const int is=(int)ceil (dmin/dD);
	const int ie=(int)floor(dmax/dD);

	eps.color4dv( model.gloption.dos.foreground );
	for( int i=is; i<=ie; i++ ){
	  double D = dD*i;
	  sprintf( label, "%+.*e", 1, D );
	  eps.renderText( emin, D, 0.0, QString(label));
	}
	eps.popMatrix();
      }

      // 
      {
	eps.pushMatrix();
	eps.translateR( -30, -16, 0 );

	double dE = emax - emin;
	double E0 = 0.0;
	round( dE, E0 );
	dE = dE/N;

	const int is=(int)ceil (emin/dE);
	const int ie=(int)floor(emax/dE);

	eps.color4dv( model.gloption.dos.foreground );
	for( int i=is; i<=ie; i++ ){
	  double E = dE*i;
	  sprintf( label, "%+5.1f", E );
	  eps.renderText( E, dmin, 0.0, QString(label) );
	}
	eps.popMatrix();
      }
    }
    
    // Obh̕`
    {
      const int N = 8;

      // Obh
      {      
	double dD = dmax - dmin;
	double D0 = 0.0;
	round( dD, D0 );
	dD = dD/N;
      
	const int is=(int)ceil (dmin/dD);
	const int ie=(int)floor(dmax/dD);
	
	eps.color4dv( model.gloption.dos.background*0.75
		    +model.gloption.dos.foreground*0.25 );
	eps.begin( GL_LINES );
	for( int i=is; i<=ie; i++ ){
	  double D = dD*i;
	  eps.vertex2d( emin, D );
	  eps.vertex2d( emax, D );
	}
	eps.end();
      }

      // Obhc
      {      
	double dE = emax - emin;
	double E0 = 0.0;
	round( dE, E0 );
	dE = dE/N;
      
	const int is=(int)ceil (emin/dE);
	const int ie=(int)floor(emax/dE);

	eps.color4dv( model.gloption.dos.background*0.75
		      +model.gloption.dos.foreground*0.25 );
	eps.begin( GL_LINES );
	for( int i=is; i<=ie; i++ ){
	  double E = dE*i;
	  eps.vertex2d( E, dmin );
	  eps.vertex2d( E, dmax );
	}
	eps.end();
      }
    }
    
    // f[^̕`
    {
      // DOS
      for( int i=0; i<(int)model.dos.sizeData1(); i++ ){
	double f =
	  model.dos.sizeData1() == 0 ? 0.0 :
	  (double)i/(model.dos.sizeData1()-1);
	eps.color4dv(model.gloption.dos.gradation(f));
	int n=0;
	double Epre=0.0,Dpre=0.0;
	bool   Fpre=false;
	for( int ie=0; ie<model.dos.sizeEnergy(); ie++ ){
	  double E = model.dos.vdata[0][i].energy[ie];
	  double D = model.dos.vdata[0][i].dos[ie];
	  // ͈͊O
	  if( E<emin || emax<E ){
	    // ͈͓Oɏoꍇ
	    if( n>0 ){
	      // Ԃ_܂Ő`
	      if( Fpre && E>emax ){
		eps.vertex2d( emax, (D-Dpre)/(E-Epre)*(emax-Epre)+Dpre );
		eps.end();
		n=0;
	      }
	    }
	    Epre=E;
	    Dpre=D;
	    Fpre=true;
	    continue;
	  }

	  // c͈͓
	  if( dmin<=D && D<=dmax ){
	    // ߂Ă͈͓̔
	    if( n==0 ){
	      eps.begin( GL_LINE_STRIP );
	      if( false );
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre>dmax && E>=emin ){
		eps.vertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	      }
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre<dmin && E>=emin ){
		eps.vertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	      }
	      // O_͈͊ȌꍇɕԂ_`
	      else if( Fpre && Epre<emin ){
		eps.vertex2d( emin, (D-Dpre)/(E-Epre)*(emin-Epre)+Dpre );
	      }
	    }
	    // `
	    eps.vertex2d( E, D );
	    n++;
	  }
	  // c͈͊O
	  else if(n>0){
	    if( false );
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D>dmax){
	      eps.vertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	    }
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D<dmin){
	      eps.vertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	    }
	    eps.end();
	    n=0;
	  }
	  Epre=E;
	  Dpre=D;
	  Fpre=true;
	}
	if(n>0) eps.end(),n=0;
      }
    }
    if( model.dos.dmin<0.0 ){ // nspin=2
      // DOS
      for( int i=0; i<(int)model.dos.sizeData2(); i++ ){
	double f =
	  model.dos.sizeData2() == 0 ? 0.0 :
	  (double)i/(model.dos.sizeData2()-1);
	eps.color4dv(model.gloption.dos.gradation(f));
	int n=0;
	double Epre=0.0,Dpre=0.0;
	bool   Fpre=false;
	for( int ie=0; ie<model.dos.sizeEnergy(); ie++ ){
	  double E = model.dos.vdata[0][i].energy[ie];
	  double D = model.dos.vdata[1][i].dos[ie];
	  // ͈͊O
	  if( E<emin || emax<E ){
	    // ͈͓Oɏoꍇ
	    if( n>0 ){
	      // Ԃ_܂Ő`
	      if( Fpre && E>emax ){
		eps.vertex2d( emax, (D-Dpre)/(E-Epre)*(emax-Epre)+Dpre );
		eps.end();
		n=0;
	      }
	    }
	    Epre=E;
	    Dpre=D;
	    Fpre=true;
	    continue;
	  }

	  // c͈͓
	  if( dmin<=D && D<=dmax ){
	    // ߂Ă͈͓̔
	    if( n==0 ){
	      eps.begin( GL_LINE_STRIP );
	      if( false );
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre>dmax && E>=emin ){
		eps.vertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	      }
	      // O_c͈͊OȀ͈͓ꍇɕԂ_`
	      else if( Fpre && Dpre<dmin && E>=emin ){
		eps.vertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	      }
	      // O_͈͊ȌꍇɕԂ_`
	      else if( Fpre && Epre<emin ){
		eps.vertex2d( emin, (D-Dpre)/(E-Epre)*(emin-Epre)+Dpre );
	      }
	    }
	    // `
	    eps.vertex2d( E, D );
	    n++;
	  }
	  // c͈͊O
	  else if(n>0){
	    if( false );
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D>dmax){
	      eps.vertex2d( (E-Epre)/(D-Dpre)*(dmax-Dpre)+Epre, dmax );
	    }
	    // ͈͊ȌꍇɕԂ_܂Ő`
	    else if(Fpre && D<dmin){
	      eps.vertex2d( (E-Epre)/(D-Dpre)*(dmin-Dpre)+Epre, dmin );
	    }
	    eps.end();
	    n=0;
	  }
	  Epre=E;
	  Dpre=D;
	  Fpre=true;
	}
	if(n>0) eps.end(),n=0;
      }
    }
    eps.popMatrix();
  }

  eps.popMatrix();

  eps.close();

  return true;
}


void GLDos::mousePressEvent( QMouseEvent* ev )
{
  x_down = ev->x();
  y_down = ev->y();
}
void GLDos::mouseReleaseEvent( QMouseEvent* ev )
{
}


void GLDos::mouseMoveEvent( QMouseEvent* ev )
{
  int x = ev->x();
  //  int y = ev->y();

  int dx = x - x_down;

  if( abs(dx)<4 ) return;

  scroll(-dx);

  x_down = ev->x();
  y_down = ev->y();

  updateGL();
}

void GLDos::mouseDoubleClickEvent( QMouseEvent* ev )
{
}

void GLDos::contextMenuEvent( QContextMenuEvent* ev )
{
  popupmenu->exec(ev->globalPos());
}

void GLDos::menuEvent( QAction* action )
{
  double& emin = model.gloption.dos.emin;
  double& emax = model.gloption.dos.emax;
  double& dmin = model.gloption.dos.dmin;
  double& dmax = model.gloption.dos.dmax;

  static bool first = true;
  if( first ){
    path = QDir::currentPath();
    first = false;
  }

  if( false );
  else if( action->text() == "zoom energy in" ){
    const double xalpha = double(x_down-marginL)/(grp_width);
    const double erange = emax - emin;
    emax = emin + xalpha*erange + 0.5/4*erange;
    emin = emin + xalpha*erange - 0.5/4*erange;
    round( emax, emin );

    updateGL();
  }
  else if( action->text() == "zoom density in" ){
    dmax = dmax*0.5;
    dmin = dmin*0.5;
    round( dmax, dmin );

    updateGL();
  }
  else if( action->text() == "zoom energy out" ){
    const double xalpha = double(x_down-marginL)/(grp_width);
    const double erange = emax - emin;
    emax = emin + xalpha*erange + 0.5*4*erange;
    emin = emin + xalpha*erange - 0.5*4*erange;
    if( emin < model.dos.emin ){
      emin = model.dos.emin;
    }
    if( emax > model.dos.emax ){
      emax = model.dos.emax;
    }
    round( emax, emin );

    updateGL();
  }
  else if( action->text() == "zoom density out" ){
    dmax = dmax*2.0;
    dmin = dmin*2.0;
    round( dmax, dmin );

    updateGL();
  }
  else if( action->text() == "zoom reset" ){
    emin = model.dos.emin;
    emax = model.dos.emax;
    dmin = model.dos.dmin;
    dmax = model.dos.dmax;
    updateGL();
  }

  else if( action->text() == "save image" ){
    const QString fname = QFileDialog::getSaveFileName
      ( this, tr("Save image in file"), path,
	tr("Windows Bitmap file(*.bmp);;"
	   "Encapsulated PostScript file(*.eps);;"
	   "All files(*)"));
    
    if( fname.endsWith( ".bmp" ) ){
      if( glSavePixels( qPrintable(fname) ) ){
	path = getDirName(fname);
      }
      else{
	MyException::critical("can not create a file.",fname);
      }
    }
    else if( fname.endsWith( ".eps" ) ){
      if( paintEPS( qPrintable(fname) ) ){
	path = getDirName(fname);
      }
      else{
	MyException::critical("can not create a file.",fname);
      }
    }
    else if( fname !="" ){
      MyException::critical("unknown suffix.",fname);
    }
  }
}



void GLDos::scroll( int ix )
{
  double& emin = model.gloption.dos.emin;
  double& emax = model.gloption.dos.emax;

  const double dx = double(ix)/(grp_width)*(emax - emin);

  emin += dx;
  emax += dx;
  if( emin<model.dos.emin || model.dos.emax<emax ){
    emin -= dx;
    emax -= dx;
  }
}

void GLDos::wheelEvent( QWheelEvent* ev )
{
}

void GLDos::keyPressEvent( QKeyEvent* ev )
{
  switch( ev->key() ){
  case Qt::Key_Left     :  scroll( +8 ); break;
  case Qt::Key_Right    :  scroll( -8 ); break;
    //  case Qt::Key_Up       :  scroll( +4 ); break;
    //  case Qt::Key_Down     :  scroll( -4 ); break;
    //  case Qt::Key_PageDown : break;
    //  case Qt::Key_PageUp   : break;
  default : break;
  }

  updateGL();
}


void GLDos::keyReleaseEvent( QKeyEvent* ev )
{
  if( ev->isAutoRepeat() ) return;

  switch( ev->key() ){
  case Qt::Key_Left   : break;
  case Qt::Key_Right  : break;
  case Qt::Key_Down   : break;
  case Qt::Key_Up     : break;
    //  case Qt::Key_PageDown : break;
    //  case Qt::Key_PageUp   : break;
  default             : return;
  }
}

