/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gldos.h
 \brief ԖxGL\̃NX
*/

#ifndef __GLDOS_H_INCLUDED
#define __GLDOS_H_INCLUDED

#include <QtGui/QtGui>
#include <QtOpenGL/QGLWidget>

class DTModel;

class GLDos : public QGLWidget
{
  Q_OBJECT

private:
  int marginL;
  int marginR;
  int marginT;
  int marginB;
  int win_width, win_height;
  int grp_width, grp_height;

private:
  DTModel& model;
  QString path;
  
public:
  GLDos( DTModel& _model );

signals:
  void changed( void );
public slots:
  void update( void );
public:
  void draw( void );

protected:
  void initializeGL( void );
  void paintGL( void );
  bool paintEPS( const QString& fname );
  void resizeGL( int width, int height );

  int  x_down, y_down;
  void mousePressEvent( QMouseEvent* ev );
  void mouseReleaseEvent( QMouseEvent* ev );
  void mouseMoveEvent ( QMouseEvent* ev );
  void mouseDoubleClickEvent( QMouseEvent* ev );
  void keyPressEvent( QKeyEvent* ev );
  void keyReleaseEvent( QKeyEvent* ev );
  void wheelEvent( QWheelEvent* ev );

  QMenu*    popupmenu;
  void contextMenuEvent( QContextMenuEvent* ev );

private slots:
  void menuEvent( QAction* action );

private:
  void scroll( int dy );
};

#endif // __GLDOS_H_INCLUDED
