/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gleps.h
 \brief }`EPS`ł̃t@CoNX
*/

#ifndef GLEPS_H_INCLUDED
#define GLEPS_H_INCLUDED

#include <QtGui/QtGui>

#include <stack>
using namespace std;

class GLEPS
{
  double X_TO_PT, Y_TO_PT;
  FILE*  fptr;
  int    mode;
  bool   first;
  double sx, sy;
  double tx, ty;
  double lw;
  stack<double> stack_tx, stack_ty;
  stack<double> stack_sx, stack_sy;

public:
  GLEPS( void ){
    sx = sy = 1.0;
    tx = ty = 0.0;
  }

  bool open ( const char* fname,
	      const int win_w, const int win_h, 
	      const double eps_w, const double eps_h );
  void close( void );

  void begin( const int mode );
  void end( void );

  void loadIdentity( void );
  void translated( const double tx, const double ty, const double tz=0.0 );
  void translateR( const double tx, const double ty, const double tz=0.0 );
  void scaled( const double sx, const double sy, const double sz=0.0 );

  void pushMatrix( void );
  void popMatrix( void );
  void vertex2d( const double x, const double y );

  void color4dv( const double color[4] );
  void color3d( const double R, const double G, const double B );
  void renderText( const double x, const double y, const double z, const QString& str );
  void pointSize( double width );
  void lineWidth( double width );
  void linestipple( double on, double off );
  void font( const char* font, const double size );

private:
  double X( const double x ){
    return (x*sx + tx)*X_TO_PT;
  }
  double Y( const double y ){
    return (y*sy + ty)*Y_TO_PT;
  }
};

#endif // GLEPS_H_INCLUDED
