/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glfield.cc
 \brief OtB[hGL\̓NX
*/

#include "dtmodel.h"
#include "glfield.h"

void GLField::update( void )
{
  if( !model.gloption.field.show ) return;
  if( !model.field.isset() ) return;

  crosecA.change();
  crosecB.change();
  crosecC.change();
  isosurf.change();
  fog.change();
  frame.change();
  bar.change();
}

void GLField::draw( void )
{
  if( !model.gloption.field.show ) return;
  if( !model.field.isset() ) return;

  if( model.gloption.field.crosec.showA ){
    crosecA.draw();
  }
  if( model.gloption.field.crosec.showB ){
    crosecB.draw();
  }
  if( model.gloption.field.crosec.showC ){
    crosecC.draw();
  }
  if( model.gloption.field.isosurf.show ){
    isosurf.draw();
  }
  if( model.gloption.field.fog.show ){
    fog.draw();
  }
  if( model.gloption.field.frame.show ){
    frame.draw();
  }
  if( model.gloption.field.bar.show ){
    bar.draw();
  }
}
