/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glfield.h
 \brief OtB[hGL\̓NX
*/

#ifndef __GLFIELD_H_INCLUDED
#define __GLFIELD_H_INCLUDED

#include <QtGui/QtGui>
#include "glcrosec.h"
#include "glisosurf.h"
#include "glfog.h"
#include "glframe.h"
#include "glbar.h"

class DTModel;
class QGLWidget;

class GLField : public QWidget, public GLBase
{
  Q_OBJECT

private:
  DTModel&  model;
  GLCroSecA crosecA;
  GLCroSecB crosecB;
  GLCroSecC crosecC;
  GLIsosurf isosurf;
  GLFog     fog;
  GLFrame   frame;
  GLBar     bar;
  
public:
  GLField( DTModel& _model, QGLWidget* _qglwidget ) :
    model  (_model),
    crosecA(_model),
    crosecB(_model),
    crosecC(_model),
    isosurf(_model),
    fog    (_model),
    frame  (_model),
    bar    (_model,_qglwidget) {
  }
public slots:
  void update( void );
public:
  void draw( void );
};

#endif // __GLFIELD_H_INCLUDED
