/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glfog.h
 \brief OtB[h̃tHOGL\̃NX
*/

#ifndef __GLFOG_H_INCLUDED
#define __GLFOG_H_INCLUDED

#include "glbase.h"
#include <stdlib.h> // for rand()

class DTModel;

class GLFog : public GLBase
{
private:
  DTModel& model;

public:
  GLFog( DTModel& _model ) : model(_model) {}

public:
  void update( void );

private:
  // [0.0:1.0)̈l
  inline double urand( void ){
    return (double)rand()/RAND_MAX;
  }
private:
  // f[^[0:1]Ki
  double data_normalized
    ( const vector3d<double>& data,
      const int ix, const int iy, const int iz );
};

#endif // __GLFOG_H_INCLUDED
