/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glframe.cc
 \brief OtB[ḧ̗gGL\̃NX
*/

#include <GL/gl.h>
#include "dtmodel.h"
#include "glmisc.h"
#include "glframe.h"


void GLFrame::update( void )
{
  const Position& La = model.field.La;
  const Position& Lb = model.field.Lb;
  const Position& Lc = model.field.Lc;
  const Position& Lo = model.field.Lo;

  GLcolor color = model.gloption.field.frame.color;

  GLBase::beginNewList();
  glDisable( GL_LIGHTING );

  glPushMatrix(); {
    double mat[4][4];
  
    mat[0][0] = La.x, mat[0][1] = La.y, mat[0][2] = La.z, mat[0][3] = 0.0;
    mat[1][0] = Lb.x, mat[1][1] = Lb.y, mat[1][2] = Lb.z, mat[1][3] = 0.0;
    mat[2][0] = Lc.x, mat[2][1] = Lc.y, mat[2][2] = Lc.z, mat[2][3] = 0.0;
    mat[3][0] = Lo.x, mat[3][1] = Lo.y, mat[3][2] = Lo.z, mat[3][3] = 1.0;
    glMultMatrixd((double*)mat);
  }

  glColor4dv( color );

  // PʖE̘g̕\
  {
    glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );

    glBegin( GL_QUADS );
    // x-
    glNormal3d( -1.0, 0.0, 0.0 );
    glVertex3d( 0.0, 0.0, 0.0 );
    glVertex3d( 0.0, 0.0, 1.0 );
    glVertex3d( 0.0, 1.0, 1.0 );
    glVertex3d( 0.0, 1.0, 0.0 );

    // x+
    glNormal3d( +1.0, 0.0, 0.0 );
    glVertex3d( 1.0, 0.0, 0.0 );
    glVertex3d( 1.0, 1.0, 0.0 );
    glVertex3d( 1.0, 1.0, 1.0 );
    glVertex3d( 1.0, 0.0, 1.0 );

    // y-
    glNormal3d( -1.0, 0.0, 0.0 );
    glVertex3d( 0.0, 0.0, 0.0 );
    glVertex3d( 0.0, 0.0, 1.0 );
    glVertex3d( 1.0, 0.0, 1.0 );
    glVertex3d( 1.0, 0.0, 0.0 );

    // y+
    glNormal3d( +1.0, 0.0, 0.0 );
    glVertex3d( 0.0, 1.0, 0.0 );
    glVertex3d( 1.0, 1.0, 0.0 );
    glVertex3d( 1.0, 1.0, 1.0 );
    glVertex3d( 0.0, 1.0, 1.0 );

    // z-
    glNormal3d( 0.0, 0.0, -1.0 );
    glVertex3d( 0.0, 0.0, 0.0 );
    glVertex3d( 1.0, 0.0, 0.0 );
    glVertex3d( 1.0, 1.0, 0.0 );
    glVertex3d( 0.0, 1.0, 0.0 );

    // z+
    glNormal3d( 0.0, 0.0, +1.0 );
    glVertex3d( 0.0, 0.0, 1.0 );
    glVertex3d( 0.0, 1.0, 1.0 );
    glVertex3d( 1.0, 1.0, 1.0 );
    glVertex3d( 1.0, 0.0, 1.0 );

    glEnd();

    glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
  }



  if( model.field.multi.mode == 2 ){
    glDisable( GL_DEPTH_TEST );
    glPointSize(6.0);
    glColor4dv( GLcolor::red );

    glBegin( GL_POINTS );
    const vector<Coordinates>& vcoords = model.field.getSlaterCoords();
    for( int i=0; i<(int)vcoords.size(); i++ ){
      glVertex3dv( vcoords[i] );
    }
    glEnd();
    glPointSize(1.0);
    glEnable( GL_DEPTH_TEST );
  }

  glPopMatrix();

  glEnable( GL_LIGHTING );

  GLBase::endNewList();
}
