/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glisosurf.h
 \brief OtB[h̓lʂGL\̃NX
*/

#ifndef __GLISOSURF_H_INCLUDED
#define __GLISOSURF_H_INCLUDED

#include "glbase.h"
#include "vector3d.h"

class DTModel;

class GLIsosurf : public GLBase
{
private:
  DTModel& model;

public:
  GLIsosurf( DTModel& _model ) : model(_model) {}

public:
  void update( void );

private:
  struct Node{
    bool     flag;
    double   phase;
    Position vertex;
    Position normal;
    
    static double distance( const Node& n1, const Node& n2 ){
      return
	+fabs(n1.vertex.x-n2.vertex.x)
	+fabs(n1.vertex.y-n2.vertex.y)
	+fabs(n1.vertex.z-n2.vertex.z);
    }
  };

  static vector3d<Node> nodex;
  static vector3d<Node> nodey;
  static vector3d<Node> nodez;

private:
  double value, scale;
  bool   icomplex_field;
  void makeIsosurfR
    ( const vector3d<double>& data,
      const double iso_value,
      const double iso_scale,
      const Coordinates& scroll );

  void makeIsosurfC
    ( const vector3d<double>& data_abs,
      const vector3d<double>& data_arg,
      const double iso_value,
      const double iso_scale,
      const Coordinates& scroll );

  int  indexSelected( const Node& node0, const Node& node1, const Node& node2, const Node& node3 );
  Position calcNormal( const vector3d<double>& data, int ix, int iy, int iz );

  void makeElement( int ix, int iy, int iz, const Position& dr );
  void drawElement( int n, Node polygon[], const Position& dr );
};

#endif // __GLISOSURF_H_INCLUDED
