/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gllattice.cc
 \brief iqGL\̓NX
*/

#include <GL/gl.h>
#include "dtmodel.h"
#include "gllattice.h"

void GLLattice::update( void )
{
  atoms.change();
  bonds.change();
  cell .change();
}

void GLLattice::draw( void )
{
  if( !model.gloption.lattice.show ) return;

  int value;
  glGetIntegerv( GL_RENDER_MODE, &value );

  if( value == GL_RENDER ){
    if( model.gloption.lattice.atom.show ){
      atoms.draw();
    }
    if( model.gloption.lattice.bond.show ){
      bonds.draw();
    } 
    if( model.gloption.lattice.cell.show ){
      cell.draw();
    }
  }
  else{
    if( model.gloption.lattice.atom.show ){
      atoms.select();
    }
  }

}
