/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gllattice.h
 \brief iqGL\̓NX
*/

#ifndef __GLLATTICE_H_INCLUDED
#define __GLLATTICE_H_INCLUDED

#include <QtGui/QtGui>
#include "glcell.h"
#include "glatoms.h"
#include "glbonds.h"

class DTModel;
class QGLWidget;

class GLLattice : public QWidget
{
  Q_OBJECT

private:
public:
  DTModel& model;
  GLCell   cell;
  GLAtoms  atoms;
  GLBonds  bonds;
  
public:
  GLLattice( DTModel& _model,
	  QGLWidget* _qglwidget ) :
    model(_model),
    cell (_model,_qglwidget),
    atoms(_model,_qglwidget),
    bonds(_model) {
  }

public slots:
  void update( void );
public:
  void draw( void );
};

#endif // __GLLATTICE_H_INCLUDED
