/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gloption.cc
 \brief GL\̑SĂ̕\w
*/

#include "gloption.h"
#include "qtxml.h"
#include "symbol.h"
#include <QtGui/QColor>

GLOption::GLOption( void )
{
  icolor = 0;
  loadDefaults();
}

GLOption::Window::Window( void )
{
  title      = "TAPIOCA version 1.7.3";
  width      = 768;
  height     = 512;
  background = GLcolor::black;
  foreground = GLcolor::white;
  fullscreen = false;
}

GLOption::Location::Location( void )
{
  world      = 256.0;

  eye      = Position( 0.0, 0.0, world );
  gaze     = Position( 0.0, 0.0, 0.0 );
  up       = Position( 0.0, 1.0, 0.0 );

  pangle   = 30.0;
  pnear    = world/8.0;
  pfar     = world*8.0;

  perspective = false;

  scrollA = 0.0;
  scrollB = 0.0;
  scrollC = 0.0;
  extendA = 0;
  extendB = 0;
  extendC = 0;
  wigner  = false;
}

GLOption::Light::Light( void )
{
  diffuse    = GLcolor( 0.8, 0.8, 0.8 );
  specular   = GLcolor( 1.0, 1.0, 1.0 );
  ambient    = GLcolor( 0.25, 0.25, 0.25 );
  shininess  = 128.0;
  direction_orig = Direction( 1.0, 1.0, 1.0, 0.0 );
  direction  = direction_orig;
  second_direction = Direction( -1.0, -1.0, -1.0, 0.0 );
  second = true;
  fog = false;
}

GLOption::Lattice::Lattice( void )
{
  show = true;

  atom.show      = true;
  atom.show_copy = false;
  atom.points    = false;
  atom.scale     = 0.25;
  atom.slices    = 16.0;

  atom.velement.resize(ElementSymbol::Lr+1);
  atom.velement[ElementSymbol::X ]=Atom::byElement(ElementSymbol::X, 0.75,GLcolor(0.00,0.00,0.00));
  atom.velement[ElementSymbol::H ]=Atom::byElement(ElementSymbol::H, 1.00,GLcolor(1.00,1.00,1.00));
  atom.velement[ElementSymbol::He]=Atom::byElement(ElementSymbol::He,1.00,GLcolor(1.00,0.75,0.80));
  atom.velement[ElementSymbol::Li]=Atom::byElement(ElementSymbol::Li,1.00,GLcolor(0.70,0.13,0.13));
  atom.velement[ElementSymbol::Be]=Atom::byElement(ElementSymbol::Be,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::B ]=Atom::byElement(ElementSymbol::B, 1.00,GLcolor(0.00,1.00,0.00));
  atom.velement[ElementSymbol::C ]=Atom::byElement(ElementSymbol::C, 1.00,GLcolor(0.78,0.78,0.78));
  atom.velement[ElementSymbol::N ]=Atom::byElement(ElementSymbol::N, 1.00,GLcolor(0.56,0.56,1.00));
  atom.velement[ElementSymbol::O ]=Atom::byElement(ElementSymbol::O, 1.00,GLcolor(0.94,0.00,0.00));
  atom.velement[ElementSymbol::F ]=Atom::byElement(ElementSymbol::F, 1.00,GLcolor(0.85,0.65,0.13));
  atom.velement[ElementSymbol::Ne]=Atom::byElement(ElementSymbol::Ne,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Na]=Atom::byElement(ElementSymbol::Na,1.00,GLcolor(0.00,0.00,1.00));
  atom.velement[ElementSymbol::Mg]=Atom::byElement(ElementSymbol::Mg,1.00,GLcolor(0.13,0.55,0.13));
  atom.velement[ElementSymbol::Al]=Atom::byElement(ElementSymbol::Al,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::Si]=Atom::byElement(ElementSymbol::Si,1.00,GLcolor(0.85,0.65,0.13));
  atom.velement[ElementSymbol::P ]=Atom::byElement(ElementSymbol::P, 1.00,GLcolor(1.00,0.65,0.00));
  atom.velement[ElementSymbol::S ]=Atom::byElement(ElementSymbol::S, 1.00,GLcolor(1.00,0.78,0.20));
  atom.velement[ElementSymbol::Cl]=Atom::byElement(ElementSymbol::Cl,1.00,GLcolor(0.00,1.00,0.00));
  atom.velement[ElementSymbol::Ar]=Atom::byElement(ElementSymbol::Ar,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::K ]=Atom::byElement(ElementSymbol::K, 1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ca]=Atom::byElement(ElementSymbol::Ca,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::Sc]=Atom::byElement(ElementSymbol::Sc,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ti]=Atom::byElement(ElementSymbol::Ti,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::V ]=Atom::byElement(ElementSymbol::V, 1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Cr]=Atom::byElement(ElementSymbol::Cr,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::Mn]=Atom::byElement(ElementSymbol::Mn,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::Fe]=Atom::byElement(ElementSymbol::Fe,1.00,GLcolor(1.00,0.65,0.00));
  atom.velement[ElementSymbol::Co]=Atom::byElement(ElementSymbol::Co,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ni]=Atom::byElement(ElementSymbol::Ni,1.00,GLcolor(0.65,0.16,0.16));
  atom.velement[ElementSymbol::Cu]=Atom::byElement(ElementSymbol::Cu,1.00,GLcolor(0.65,0.16,0.16));
  atom.velement[ElementSymbol::Zn]=Atom::byElement(ElementSymbol::Zn,1.00,GLcolor(0.65,0.16,0.16));
  atom.velement[ElementSymbol::Ga]=Atom::byElement(ElementSymbol::Ga,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ge]=Atom::byElement(ElementSymbol::Ge,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::As]=Atom::byElement(ElementSymbol::As,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Se]=Atom::byElement(ElementSymbol::Se,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Br]=Atom::byElement(ElementSymbol::Br,1.00,GLcolor(0.65,0.16,0.16));
  atom.velement[ElementSymbol::Kr]=Atom::byElement(ElementSymbol::Kr,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Rb]=Atom::byElement(ElementSymbol::Rb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Sr]=Atom::byElement(ElementSymbol::Sr,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Y ]=Atom::byElement(ElementSymbol::Y, 1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Zr]=Atom::byElement(ElementSymbol::Zr,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Nb]=Atom::byElement(ElementSymbol::Nb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Mo]=Atom::byElement(ElementSymbol::Mo,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Tc]=Atom::byElement(ElementSymbol::Tc,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ru]=Atom::byElement(ElementSymbol::Ru,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Rh]=Atom::byElement(ElementSymbol::Rh,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pd]=Atom::byElement(ElementSymbol::Pd,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ag]=Atom::byElement(ElementSymbol::Ag,1.00,GLcolor(0.50,0.50,0.56));
  atom.velement[ElementSymbol::Cd]=Atom::byElement(ElementSymbol::Cd,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::In]=Atom::byElement(ElementSymbol::In,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Sn]=Atom::byElement(ElementSymbol::Sn,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Sb]=Atom::byElement(ElementSymbol::Sb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Te]=Atom::byElement(ElementSymbol::Te,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::I ]=Atom::byElement(ElementSymbol::I, 1.00,GLcolor(0.63,0.13,0.94));
  atom.velement[ElementSymbol::Xe]=Atom::byElement(ElementSymbol::Xe,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Cs]=Atom::byElement(ElementSymbol::Cs,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ba]=Atom::byElement(ElementSymbol::Ba,1.00,GLcolor(1.00,0.65,0.00));
  atom.velement[ElementSymbol::La]=Atom::byElement(ElementSymbol::La,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ce]=Atom::byElement(ElementSymbol::Ce,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pr]=Atom::byElement(ElementSymbol::Pr,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Nd]=Atom::byElement(ElementSymbol::Nd,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pm]=Atom::byElement(ElementSymbol::Pm,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Sm]=Atom::byElement(ElementSymbol::Sm,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Eu]=Atom::byElement(ElementSymbol::Eu,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Gd]=Atom::byElement(ElementSymbol::Gd,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Tb]=Atom::byElement(ElementSymbol::Tb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Dy]=Atom::byElement(ElementSymbol::Dy,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ho]=Atom::byElement(ElementSymbol::Ho,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Er]=Atom::byElement(ElementSymbol::Er,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Tm]=Atom::byElement(ElementSymbol::Tm,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Yb]=Atom::byElement(ElementSymbol::Yb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Lu]=Atom::byElement(ElementSymbol::Lu,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Hf]=Atom::byElement(ElementSymbol::Hf,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ta]=Atom::byElement(ElementSymbol::Ta,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::W ]=Atom::byElement(ElementSymbol::W, 1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Re]=Atom::byElement(ElementSymbol::Re,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Os]=Atom::byElement(ElementSymbol::Os,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ir]=Atom::byElement(ElementSymbol::Ir,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pt]=Atom::byElement(ElementSymbol::Pt,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Au]=Atom::byElement(ElementSymbol::Au,1.00,GLcolor(0.85,0.65,0.13));
  atom.velement[ElementSymbol::Hg]=Atom::byElement(ElementSymbol::Hg,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Tl]=Atom::byElement(ElementSymbol::Tl,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pb]=Atom::byElement(ElementSymbol::Pb,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Bi]=Atom::byElement(ElementSymbol::Bi,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Po]=Atom::byElement(ElementSymbol::Po,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::At]=Atom::byElement(ElementSymbol::At,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Rn]=Atom::byElement(ElementSymbol::Rn,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Fr]=Atom::byElement(ElementSymbol::Fr,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ra]=Atom::byElement(ElementSymbol::Ra,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Ac]=Atom::byElement(ElementSymbol::Ac,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Th]=Atom::byElement(ElementSymbol::Th,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pa]=Atom::byElement(ElementSymbol::Pa,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::U ]=Atom::byElement(ElementSymbol::U, 1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Np]=Atom::byElement(ElementSymbol::Np,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Pu]=Atom::byElement(ElementSymbol::Pu,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Am]=Atom::byElement(ElementSymbol::Am,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Cm]=Atom::byElement(ElementSymbol::Cm,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Bk]=Atom::byElement(ElementSymbol::Bk,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Cf]=Atom::byElement(ElementSymbol::Cf,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Es]=Atom::byElement(ElementSymbol::Es,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Fm]=Atom::byElement(ElementSymbol::Fm,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Md]=Atom::byElement(ElementSymbol::Md,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::No]=Atom::byElement(ElementSymbol::No,1.00,GLcolor(1.00,0.08,0.58));
  atom.velement[ElementSymbol::Lr]=Atom::byElement(ElementSymbol::Lr,1.00,GLcolor(1.00,0.08,0.58));
  atom.element_default            =Atom::byElement(ElementSymbol::X ,1.00, GLcolor::black );

  atom.color_selected = GLcolor::yellow;

  bond.show      = true;
  bond.show_copy = false;
  bond.lines     = false;
  bond.scale = 0.5/8;
  bond.slices = 8.0;

  bond.velement.push_back( Bond::byElement(ElementSymbol::H,ElementSymbol::H,1.50,GLcolor::white) );
  bond.velement.push_back( Bond::byElement(ElementSymbol::H,ElementSymbol::C,1.75,GLcolor::white) );
  bond.velement.push_back( Bond::byElement(ElementSymbol::C,ElementSymbol::C,2.00,GLcolor::white) );
  bond.element_default = ( Bond::byElement(ElementSymbol::X,ElementSymbol::X,2.00,GLcolor::white) );

  cell.show = true;
  cell.color = GLcolor::white;
  cell.color_selected = GLcolor::red;

  axis.show = true;
}

GLOption::Field::Field( void )
{
  show = true;

  range_manual = false;
  data_min = 0.0, data_max = 0.0;

  gradation = 
    Gradation( GLcolor::blue, GLcolor::cyan, GLcolor::green,
	       GLcolor::yellow, GLcolor::red, 0.50 );
  gradation_arg.clear();
  gradation_arg.push(GLcolor::cyan);
  gradation_arg.push(GLcolor::green);
  gradation_arg.push(GLcolor::yellow);
  gradation_arg.push(GLcolor::red);
  gradation_arg.push(GLcolor::magenta);
  gradation_arg.push(GLcolor::blue);
  gradation_arg.push(GLcolor::cyan);
  gradation_arg.setAlpha( 0.50 );

  crosec.showA = false;
  crosec.showB = false;
  crosec.showC = false;
  crosec.scaleA = 0.5;
  crosec.scaleB = 0.5;
  crosec.scaleC = 0.5;
  crosec.plane.alpha = 0.50;
  crosec.plane.show = true;
  crosec.isoline.show = true;
  crosec.isoline.lines = 16;
  crosec.gradient.show = false;
  crosec.gradient.scale = 0.5;
  crosec.gradient.thick = 1.0;

  isosurf.show  = true;
  isosurf.vvalue.clear();
  isosurf.vvalue.push_back(0.0);
  isosurf.index_shown = 1;
  isosurf.update_shown();
  isosurf.alpha = 0.75;

  fog.show  = false;
  fog.scale = 0.5;
  frame.show = true;
  frame.color = GLcolor::white;

  bar.show = true;
}

void GLOption::Field::Isosurf::add( void )
{
  vvalue.push_back( vvalue.back() );

  index_shown = (int)vvalue.size();
  update_shown();
}

void GLOption::Field::Isosurf::del( void )
{
  if( (int)vvalue.size()<=1 ) return;
  if( index_shown > (int)vvalue.size() ) index_shown = 1;
  vvalue.erase( vvalue.begin()+index_shown-1 );
  update_shown();
}

void GLOption::Field::Isosurf::change_shown( void )
{
  if( vvalue.empty() ) return;
  if( index_shown > (int)vvalue.size() ) index_shown = 1;

  vvalue[index_shown-1] = value_shown;
}

void GLOption::Field::Isosurf::update_shown( void )
{
  if( vvalue.empty() ) return;
  if( index_shown > (int)vvalue.size() ) index_shown = 1;
    
  value_shown  = vvalue[index_shown-1];
}

GLOption::Band::Band( void )
{
  background = GLcolor::white;
  foreground = GLcolor::black;
  gradation  =
    Gradation( GLcolor::blue, GLcolor::cyan, GLcolor::green,
	       GLcolor::yellow, GLcolor::red, 1.0 );
  monochrome = false;

  line.show  = true;
  line.size  = 1;
  point.show = true;
  point.size = 2;
}

GLOption::Dos::Dos( void )
{
  background = GLcolor::white;
  foreground = GLcolor::black;
  gradation  =
    Gradation( GLcolor::blue, GLcolor::cyan, GLcolor::green,
	       GLcolor::yellow, GLcolor::red, 1.0 );
  monochrome = false;

  line.show  = true;
  line.size  = 1;
  point.show = true;
  point.size = 2;
}

static bool loadColor( GLcolor& color, const QDomElement& node )
{
  GLcolor temp;
  char str[32];

  temp.A = 1.0; // default

  if( 3 <= XML::sscanf( XML::getAttribute(node,"color"),
		       "%lf %lf %lf %lf",
		       &temp.R, &temp.G, &temp.B, &temp.A ) ){
    color = temp;
    return true;
  }else if( 1 <= XML::sscanf( XML::getAttribute(node,"color"),
		       "%31s %lf",
		       str, &temp.A ) ){
    QColor qcolor;
    qcolor.setNamedColor( str );
    if( qcolor.isValid() ){
      color.R = qcolor.redF();
      color.G = qcolor.greenF();
      color.B = qcolor.blueF();
      color.A = temp.A;
      return true;
    }
    return false;
  }
  return false;
}

void GLOption::loadDefaults( void )
{
  QDomDocument doc;

  if( !XML::load( doc, "defaults.glml") ){
    return;
  }

  vcolorname.clear();
  vcolorptr.clear();

  QDomNode root = XML::getRoot(doc);

  //---- <Window>
  {
    char str[32];
    QDomElement group, node;

    group = XML::getFirstElementByTagName(root,"Window");

    if( 1 == XML::sscanf( XML::getAttribute(group,"fullscreen"), "%s", str )){
      if( !strcmp( str, "on" ) ){
	window.fullscreen = true;
      }
      else{
	window.fullscreen = false;
      }
    }
    
    if( 1 == XML::sscanf( XML::getAttribute(group,"perspective"), "%s", str )){
      if( !strcmp( str, "on" ) ){
	location.perspective = true;
      }
      else{
	location.perspective = false;
      }
    }

    node = XML::getFirstElementByTagName(group,"background");
    loadColor( window.background, node );
    node = XML::getFirstElementByTagName(group,"foreground");
    loadColor( window.foreground, node );

    vcolorname.push_back( "background of 3d-viewer" );
    vcolorptr .push_back( &window.background );

    vcolorname.push_back( "foreground of 3d-viewer" );
    vcolorptr .push_back( &window.foreground );
  }

  //---- <Lattice>
  {
    QDomElement group, node;
    vector<QDomElement> vnode;
    char name[8], name1[8], name2[8];
    double radius, length;
    GLcolor color;

    group = XML::getFirstElementByTagName(root,"Lattice");

    vnode = XML::getElementsByTagName(group,"atom");
    for( int i=0; i<(int)vnode.size(); i++ ){
      XML::sscanf( XML::getAttribute(vnode[i],"element"), "%s", name );
      XML::sscanf( XML::getAttribute(vnode[i],"radius"), "%lf", &radius );
      loadColor( color, vnode[i] );

      const int id = ElementSymbol::getAtomicNumber(name);
      Lattice::Atom::byElement& element = lattice.atom.element(id);

      if( element == lattice.atom.element_default ){
      }
      else{
	element = Lattice::Atom::byElement(id,radius,color);
      }
    }

    vnode = XML::getElementsByTagName(group,"bond");
    for( int i=0; i<(int)vnode.size(); i++ ){
      XML::sscanf( XML::getAttribute(vnode[i],"element1"), "%s", name1 );
      XML::sscanf( XML::getAttribute(vnode[i],"element2"), "%s", name2 );
      XML::sscanf( XML::getAttribute(vnode[i],"length"), "%lf", &length );
      loadColor( color, vnode[i] );

      const int id1 = ElementSymbol::getAtomicNumber(name1);
      const int id2 = ElementSymbol::getAtomicNumber(name2);
      Lattice::Bond::byElement& element = lattice.bond.element(id1,id2);

      if( element == lattice.bond.element_default ){
	lattice.bond.velement.push_back( Lattice::Bond::byElement(id1,id2,length,color) );
      }
      else{
	element = Lattice::Bond::byElement(id1,id2,length,color);
      }
    }

    node = XML::getFirstElementByTagName(group,"cell");
    loadColor( lattice.cell.color, node );

    vcolorname.push_back( "frame of cell" );
    vcolorptr .push_back( &lattice.cell.color );
  }


  //---- <Field>
  {
    QDomElement group, node;
    vector<QDomElement> vnode;
    GLcolor color;

    group = XML::getFirstElementByTagName(root,"Field");
    vnode = XML::getElementsByTagName(group,"gradation");

    if( !vnode.empty() ){
      field.gradation.clear();
      for( int i=0; i<(int)vnode.size(); i++ ){
	if( loadColor( color, vnode[i] ) ){
	  field.gradation.push(color);
	}
      }
    }

    vnode = XML::getElementsByTagName(group,"gradation_arg");

    if( !vnode.empty() ){
      field.gradation_arg.clear();
      for( int i=0; i<(int)vnode.size(); i++ ){
	if( loadColor( color, vnode[i] ) ){
	  field.gradation_arg.push(color);
	}
      }
      field.crosec.plane.alpha = color.A;
      field.isosurf.alpha = color.A;
      field.fog.alpha = color.A;
    }

    node = XML::getFirstElementByTagName(group,"frame");
    loadColor( field.frame.color, node );

    for( int i=0; i<(int)field.gradation.vcolor.size(); i++ ){
      char name[128];
      sprintf(name,"gradation %d of field value",i );
      vcolorname.push_back( name );
      vcolorptr .push_back( &field.gradation.vcolor[i] );
    }

    for( int i=0; i<(int)field.gradation_arg.vcolor.size(); i++ ){
      char name[128];
      sprintf(name,"gradation %d of field argument",i );
      vcolorname.push_back( name );
      vcolorptr .push_back( &field.gradation_arg.vcolor[i] );
    }

    vcolorname.push_back( "frame of field" );
    vcolorptr .push_back( &field.frame.color );
  }

  //---- <Band>
  {
    QDomElement group, node;
    vector<QDomElement> vnode;
    GLcolor color;

    group = XML::getFirstElementByTagName(root,"Band");

    node = XML::getFirstElementByTagName(group,"background");
    loadColor( band.background, node );

    node = XML::getFirstElementByTagName(group,"foreground");
    loadColor( band.foreground, node );

    vnode = XML::getElementsByTagName(group,"gradation");

    if( !vnode.empty() ){
      band.gradation.clear();
      for( int i=0; i<(int)vnode.size(); i++ ){
	if( loadColor( color, vnode[i] ) ){
	  band.gradation.push(color);
	}
      }
    }

    vcolorname.push_back( "background of band map" );
    vcolorptr .push_back( &band.background );

    vcolorname.push_back( "foreground of band map" );
    vcolorptr .push_back( &band.foreground );

    for( int i=0; i<(int)band.gradation.vcolor.size(); i++ ){
      char name[128];
      sprintf(name,"gradation %d of band map",i );
      vcolorname.push_back( name );
      vcolorptr .push_back( &band.gradation.vcolor[i] );
    }
  }

  //---- <Dos>
  {
    QDomElement group, node;
    vector<QDomElement> vnode;
    GLcolor color;

    group = XML::getFirstElementByTagName(root,"Dos");

    node = XML::getFirstElementByTagName(group,"background");
    loadColor( dos.background, node );

    node = XML::getFirstElementByTagName(group,"foreground");
    loadColor( dos.foreground, node );

    vnode = XML::getElementsByTagName(group,"gradation");

    if( !vnode.empty() ){
      dos.gradation.clear();
      for( int i=0; i<(int)vnode.size(); i++ ){
	if( loadColor( color, vnode[i] ) ){
	  dos.gradation.push(color);
	}
      }
    }

    vcolorname.push_back( "background of DOS map" );
    vcolorptr .push_back( &dos.background );
    vcolorname.push_back( "foreground of DOS map" );
    vcolorptr .push_back( &dos.foreground );

    for( int i=0; i<(int)dos.gradation.vcolor.size(); i++ ){
      char name[128];
      sprintf(name,"gradation %d of DOS map",i );
      vcolorname.push_back( name );
      vcolorptr .push_back( &dos.gradation.vcolor[i] );
    }
  }
}


GLcolor& GLOption::getColorTarget( void )
{
  return *vcolorptr[icolor];
}
