/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file gloption.h
 \brief GL\̑SĂ̕\w
*/

#ifndef __GLOPTION_H_INCLUDED
#define __GLOPTION_H_INCLUDED

#include <vector>
using namespace std;

#include <QtCore/QString>
#include "glmisc.h"
#include "position.h"

// p^ǗNX
struct GLOption
{
  GLOption( void );

  struct Window {
    Window( void );

    QString title;
    int     width;
    int     height;
    GLcolor background;
    GLcolor foreground;
    bool    fullscreen;
  } window;

  struct Location {
    Location( void );

    double   world;

    Position eye;
    Position gaze;
    Position up;

    double   pangle;
    double   pnear;
    double   pfar;

    bool perspective;

    double scrollA, scrollB, scrollC;
    Coordinates scroll( const Coordinates& coords ){
      Coordinates result;

      result.a = scrollA == 0.0 ? coords.a : fmod(coords.a+scrollA,1.0);
      result.b = scrollB == 0.0 ? coords.b : fmod(coords.b+scrollB,1.0);
      result.c = scrollC == 0.0 ? coords.c : fmod(coords.c+scrollC,1.0);

      return result;
    }
    int  extendA, extendB, extendC;
    bool   wigner;
    bool   brillouin;
  } location;

  struct Light {
    struct Direction {
      GLdouble x,y,z,a;
      Direction(){}
      Direction( const GLdouble x, const GLdouble y, const GLdouble z, const GLdouble a ) {
	this->x = x;
	this->y = y;
	this->z = z;
	this->a = a;
      }
      operator GLdouble* () {
	return &x;
      }
    };
    Light( void );

    GLcolor  diffuse;
    GLcolor  specular;
    GLcolor  ambient;
    GLdouble shininess;
    Direction direction_orig;
    Direction direction;
    bool  second;
    Direction second_direction;
    bool  fog;
  } light;


  struct Lattice {
    Lattice( void );

    bool show;

    struct Atom {
      bool   show;
      bool   show_copy;
      bool   points;
      double scale;
      double slices;
      GLcolor color_selected;

      struct byElement {
	int     id;
	double  radius;
	GLcolor color;
	byElement( void ){
	  this->radius = 1.0;
	  this->color  = GLcolor::white;
	}
	byElement( const int id, const double radius, const GLcolor& color ){
	  this->id     = id;
	  this->radius = radius;
	  this->color  = color;
	}
	bool operator == ( const byElement& element ) const {
	  return this == &element;
	}
      };
      vector<byElement> velement;
      byElement element_default;
      byElement& element( const int id ){
	if( id < (int)velement.size() ){
	  return velement[id];
	}
	return element_default;
      }
    } atom;

    struct Bond {
      bool   show;
      bool   show_copy;
      bool   lines;
      double scale;
      double slices;

      struct byElement {
	int id1;
	int id2;
	double length;
	GLcolor color;
	byElement( void ){
	  this->id1 = 0;
	  this->id2 = 0;
	  this->length = 2.0;
	  this->color  = GLcolor::white;
	}
	byElement( const int id1, const int id2,
		   const double length, const GLcolor& color ){
	  this->id1    = id1;
	  this->id2    = id2;
	  this->length = length;
	  this->color  = color;
	}
	bool operator == ( const byElement& element ) const {
	  return this == &element;
	}
      };
      vector<byElement> velement;
      byElement element_default;
      byElement& element( const int id ){
	if( id < (int)velement.size() ){
	  return velement[id];
	}
	return element_default;
      }
      byElement& element( const int id1, const int id2 ){
	for( int b=0; b<(int)velement.size(); b++ ){
	  if( (velement[b].id1 == id1 && velement[b].id2 == id2 ) ||
	      (velement[b].id1 == id2 && velement[b].id2 == id1 ) ){
	    return velement[b];
	  }
	}
	return element_default;
      }
    } bond;

    struct Cell {
      bool show;
      GLcolor color;
      GLcolor color_selected;
    } cell;

    struct Axis {
      bool show;
    } axis;
  } lattice;

  struct Field {
    Field( void );

    bool show;

    bool   range_manual;
    double data_min, data_max;

    Gradation gradation;
    Gradation gradation_arg;
    
    struct CroSec {
      bool   showA, showB, showC;
      double scaleA, scaleB, scaleC;

      struct Plane {
	bool   show;
	double alpha;
      } plane;
      struct Isoline {
	bool   show;
	int    lines;
      } isoline;
      struct Gradient {
	bool   show;
	double scale;
	double thick;
      } gradient;
    } crosec;

    struct Isosurf {
      bool   show;
      vector<double> vvalue;
      int    index_shown;
      double value_shown;

      double alpha;

      void add( void );
      void del( void );
      void change_shown( void );
      void update_shown( void );
    } isosurf;

    struct Fog {
      bool   show;
      double alpha;
      double scale;
    } fog;

    struct Frame {
      bool show;
      GLcolor color;
    } frame;

    struct Bar {
      bool show;
    } bar;

  } field;

  struct Band {
    Band( void );

    GLcolor   background;
    GLcolor   foreground; // monochrome color
    Gradation gradation;
    bool      monochrome;

    double kmin, kmax;
    double emin, emax;

    struct Line {
      bool show;
      int  size;
    } line;
    struct Point {
      bool show;
      int  size;
    } point;
  } band;

  struct Dos {
    Dos( void );

    GLcolor   background;
    GLcolor   foreground; // monochrome color
    Gradation gradation;
    bool      monochrome;

    double emin, emax;
    double dmin, dmax;

    struct Line {
      bool show;
      int  size;
    } line;
    struct Point {
      bool show;
      int  size;
    } point;
  } dos;

  int              icolor;
  vector<QString>  vcolorname;
  vector<GLcolor*> vcolorptr;

  GLcolor& getColorTarget( void );

  void loadDefaults( void );
};

#endif // __GLOPTION_H_INCLUDED
