/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glspline.cc
 \brief f[^̃XvCԃNX
*/

#include "glspline.h"

// XvC֐̐ݒ֐
Spline::Spline( const vector<double>& _vf, const vector<double>& _vx )
{
  vf = _vf;
  vx = _vx;

  vector<double> vdx(vx.size());
  vector<double> vdf(vx.size());
  vector<double> vu(vx.size());

  vc.resize(vx.size());
  vb.resize(vx.size());
  vd.resize(vx.size());

  // f[^ԊǔvZ
  for( int i=0; i+1<(int)vx.size(); i++ ){
    vdx[i] = vx[i+1] - vx[i];
  }
  vdx.back()=0.0;
  
  // f[^̈ǨvZ
  for( int i=0; i+1<(int)vx.size(); i++ ){
    vdf[i] = (vf[i+1]-vf[i])*(1.0/vdx[i]);
  }
  
  // sAx=c̉Eӂ̐ݒ
  vc.front() = 0.0;
  for( int i=1; i+1<(int)vx.size(); i++ ){
    vc[i] = (vdf[i+0]-vdf[i-1])*3.0;
  }
  vc.back() = 0.0;
  
  // LUšW̐ݒ
  vu.front() = 0.0;
  for( int i=1; i+1<(int)vx.size(); i++ ){
    vu[i] = 1.0/( 2*(vdx[i+1]+vdx[i]) - vdx[i]*vdx[i]*vu[i-1] );
  }
  vu.back() = 0.0;

  // Lsł̉̌vZ
  for( int i=1; i+1<(int)vx.size(); i++ ){
    vc[i] = vc[i] - vc[i-1]*(vdx[i-1]*vu[i-1]);
  }
  // Usł̉̌vZ
  for( int i=(int)vx.size()-2; i>=1; i-- ){
    vc[i] = (vc[i] - vc[i+1]*vdx[i])*vu[i];
  }

  // 3XvC֐̌W̌vZ
  vb.front() = vd.front() = 0.0;
  for( int i=0; i+1<(int)vx.size(); i++ ){
    vd[i] = (vc[i+1]-vc[i])*(1.0/(3.0*vdx[i]));
    vb[i] = vdf[i] - vc[i]*vdx[i] - vd[i]*(vdx[i]*vdx[i]);
  }
  vb.back() = vd.back() = 0.0;
}

// Cӂ̈ʒuł̊֐̒lԂ֐  
double Spline::operator()( const double x ) const
{
  int i;
  if( x < vx.front() ){
    i=0;
  }
  else if( x > vx.back() ){
    i=(int)vx.size()-1;
  }
  else{
    // binary search
    int ia=0, ib=(int)vx.size()-1;
    while( ia+1 < ib ){
      const int ic = (ia+ib)/2;
      if( x<vx[ic] ) ib=ic; else ia=ic;
    }
    i=ia;
  }
  const double dx = x - vx[i];
  
  return vf[i] + dx*(vb[i] + dx*(vc[i] + dx*vd[i]));
}


// 2f[^XvCԂ֐
void Spline2D::convert
( vector2d<double>& data_out, const vector2d<double>& data_in, const int NS )
{
  if( NS==1 ){
    data_out = data_in;
    return;
  }

  //  data_out.resize( NS*(data_in.sizeX()-1)+1, NS*(data_in.sizeY()-1)+1 );
  data_out.resize( NS*data_in.sizeX(), NS*data_in.sizeY() );

  {
    vector<double> vy0(data_in.sizeY());
    vector<double> vf0(data_in.sizeY());
    
    for( int iy=0; iy<data_in.sizeY(); iy++ ){
      vy0[iy] = (double)iy*NS;
    }
    for( int ix=0; ix<data_in.sizeX(); ix++ ){
      for( int iy=0; iy<data_in.sizeY(); iy++ ){
	vf0[iy] = data_in(ix,iy);
      }
      Spline spline(vf0,vy0);
      
      for( int iy=0; iy<data_out.sizeY(); iy++ ){
	data_out(NS*ix,iy) = spline((double)iy);
      }
    }
  }

  {
    vector<double> vx0(data_in.sizeX());
    vector<double> vf0(data_in.sizeX());
    
    for( int ix=0; ix<data_in.sizeX(); ix++ ){
      vx0[ix] = (double)ix*NS;
    }
    for( int iy=0; iy<data_out.sizeY(); iy++ ){
      for( int ix=0; ix<data_in.sizeX(); ix++ ){
	vf0[ix] = data_out(NS*ix,iy);
      }
      Spline spline(vf0,vx0);
      
      for( int ix=0; ix<data_out.sizeX(); ix++ ){
	data_out(ix,iy) = spline((double)ix);
      }
    }
  }
}
