/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glview.h
 \brief GLr[ÃNX
*/

#ifndef __GLVIEW_H_INCLUDED
#define __GLVIEW_H_INCLUDED

#include <QtGui/QtGui>
#include <QtOpenGL/QGLWidget>
#include "gllattice.h"
#include "glfield.h"
#include "glband.h"
#include "gldos.h"

class GLView : public QGLWidget
{
  Q_OBJECT

private:
  DTModel&  model;

public:
  GLLattice lattice;
  GLField   field;

public:
  GLView( DTModel& _model, QWidget *parent = 0 );
signals:
  void changed( void );
public slots:
  void update( void );

protected:
  void initializeGL( void );
  void paintGL( void );
  void resizeGL( int width, int height );

  void contextMenuEvent( QContextMenuEvent* ev );
  void mousePressEvent( QMouseEvent* ev );
  void mouseDoubleClickEvent( QMouseEvent* ev );
  void mouseReleaseEvent( QMouseEvent* ev );
  void mouseMoveEvent( QMouseEvent* ev );
  void keyPressEvent( QKeyEvent* ev );
  void keyReleaseEvent( QKeyEvent* ev );
  void wheelEvent( QWheelEvent* ev );

  int  x_down, y_down;
  int  x_drag, y_drag;
  bool rotate_view;
  bool shift_dragging;
  void drawRegion( void );

  QMenu*    popupmenu;

private slots:
  void menuEvent( QAction* action );

public:
  void draw( void );
  vector<int> select(  QMouseEvent* ev );
  void drawCell( void );
  void drawPeriodic( void );
  void drawWigner( void );
  void drawBrillouin( void );
  bool save( void ); 

private:
   void gluProjection( int width, int height, bool perspective );
};

#endif // __GLVIEW_H_INCLUDED
