/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtctrl.cc
 \brief QTRg[̓NX
*/

#include "dtmodel.h"
#include "glview2d.h"
#include "qtctrl.h"
#include "qtwidgets.h"

GLView2d::GLView2d( DTModel& _model ) :
  model(_model),
  band(_model),
  dos(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  setMinimumSize( model.gloption.window.width+20,
		    model.gloption.window.height+80 );
  setSizePolicy( QSizePolicy::Expanding, QSizePolicy::Expanding );

  setWindowTitle( model.gloption.window.title+"(Viewer2D)" );

  {
    connect( &model,   SIGNAL(changed()),
	     this, SLOT(update()) );

    connect( &band,   SIGNAL(changed()), &model, SLOT(update()) );
    connect( &dos,    SIGNAL(changed()), &model, SLOT(update()) );
  }
  {
    tab = new QTabWidget;

    tab->addTab(&band, "Band");
    tab->addTab(&dos,  "DOS");

    layout->addWidget(tab);
  }
  {
    MyQPushButton* widget = new MyQPushButton
      ( "close", this, SLOT(edit(const MyEvent&)), ID_CLOSE );
    layout->addWidget(widget);
  }
  setLayout(layout);
}

void GLView2d::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_CLOSE : {
    hide();
  } break;
  default: break;
  }
}

void GLView2d::update( void )
{
  band.update();
  dos.update();
}

void GLView2d::updateBand( void )
{
  band.update();
}

void GLView2d::updateDos( void )
{
  dos.update();
}
