/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file glview2d.h
 \brief GLr[ÃNX
*/

#ifndef __GLVIEW2D_H_INCLUDED
#define __GLVIEW2D_H_INCLUDED

#include <QtGui/QtGui>
#include <QtOpenGL/QGLWidget>
#include "glband.h"
#include "gldos.h"

class MyEvent;

class GLView2d : public QWidget
{
  Q_OBJECT;

private:
  DTModel&  model;

public:
  QTabWidget* tab;
  GLBand    band;
  GLDos     dos;

  enum { ID_BAND, ID_DOS, ID_CLOSE };

public:
  GLView2d( DTModel& _model );

public slots:
  void update( void);

private:
  void updateBand( void );
  void updateDos( void );

private slots:
  void edit( const MyEvent& ev );
};

#endif // __GLVIEW2D_H_INCLUDED
