/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file imatrix.h
 \brief 3x3s+3LxNgNX
*/

#ifndef __IMATRIX_H_INCLUDED
#define __IMATRIX_H_INCLUDED

//#include "matrix.h"
#include "position.h"
#include "fraction.h"

// Ώ̑(]AցAsړ)\s
class IMatrix
{
public:
  int      M[3][3]; // ]Aւ̑\sBlB
  fraction T[3];    // sړ̑\sBLlB

  IMatrix( void );
  IMatrix( const int Mxx, const int Mxy, const int Mxz,
	   const int Myx, const int Myy, const int Myz,
	   const int Mzx, const int Mzy, const int Mzz );
  IMatrix( const int M[3][3], const fraction T[3] );
  IMatrix( const char* symmetry );

  inline int& operator () ( const int i, const int j ){
    return M[i][j];
  }
  inline const int& operator () ( const int i, const int j ) const {
    return M[i][j];
  }

  bool operator == ( const IMatrix& that ) const;
  bool operator != ( const IMatrix& that ) const;

  IMatrix& operator += ( const IMatrix& that );
  IMatrix& operator *= ( const double d );
  IMatrix  operator *  ( const IMatrix& that ) const;

  IMatrix getTransposed( void ) const;
  IMatrix getTransInverse( void ) const;

  //  Matrix  getMatrix( void ) const;

  Coordinates operator * ( const Coordinates& p ) const;
  
  IMatrix getConstraint( void ) const;

  int determinant( void ) const;
  void initCanditate( void );
  bool nextCanditate( void );
  void transformUnitary( double matrix_transformed[3][3], const double matrix[3][3] ) const;

  char* name( void ) const;
  static int parse( char* str, char* axis, int& n, int& m );
  static IMatrix getIdentity( void );
  static void normalize( fraction& value );
};

#endif // __IMATRIX_H_INCLUDED
