/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file main.cc
 \brief TAPIOCA CvO
*/

/*!
  \mainpage

  TAPIOCAW[̈ꗗ:

  - main.cc	CvO
  - window.h window.cc	CEBhENX
  - dtmodel.h dtmodel.cc	f[^̓NX
  - dtlattice.h dtlattice.cc	iqf[^̓NX
  - dtcell.h dtcell.cc	iq̒PʖEf[^̃NX
  - dtsymmetry.h dtsymmetry.cc	iq̑Ώ̐f[^̃NX
  - dtatoms.h dtatoms.cc	iq̌qzuf[^̃NX
  - dttapp.h dttapp.cc	TAPPݒf[^̃NX
  - dtxtapp.h dtxtapp.cc	xTAPPݒf[^̃NX
  - dttcpp.h dttcpp.cc	TC++ݒf[^̃NXij
  - dtfield.h dtfield.cc	OtB[hf[^̃NX
  - dtband.h dtband.cc	ohf[^̃NX
  - dthistory.h	Ǘ̃NX
  - glview.h glview.cc	GLr[ÃNX
  - gllattice.h gllattice.cc	iqGL\̓NX
  - glatoms.h glatoms.cc	iq̌qGL\̃NX
  - glbonds.h glbonds.cc	iq̌GL\̃NX
  - glcell.h glcell.cc	iq̒PʖEGL\̃NX
  - glfield.h glfield.cc	OtB[hGL\̓NX
  - glisosurf.h glisosurf.cc	OtB[h̓lʂGL\̃NX
  - glcrosec.h glcrosec.cc	OtB[h̒fʐ}GL\̃NX
  - glfog.h glfog.cc	OtB[h̃tHOGL\̃NX
  - glframe.h glframe.cc	OtB[ḧ̗gGL\̃NX
  - glspline.h glspline.cc	f[^̃XvCԃNX
  - glbase.h glbase.cc	GLIuWFNg̕`{NX
  - glband.h glband.cc	ohGL\̃NX
  - gleps.h gleps.cc	}`EPS`ł̃t@CoNX
  - glmisc.h glmisc.cc	GL̂̑̏
  - gloption.h gloption.cc	GL\̑SĂ̕\w
  - qtctrl.h qtctrl.cc	QTRg[̓NX
  - qtlattice.h qtlattice.cc	iqGUI\̓NX
  - qtcell.h qtcell.cc	iq̒PʖEGUI\̃NX
  - qtalignment.h qtalignment.cc	iq̌qzuGUI\̃NX
  - qtsymmetry.h qtsymmetry.cc	iq̑Ώ̐GUI\̃NX
  - qtatoms.h qtatoms.cc	iq̌qzuGUI\̃NX
  - qttapp.h qttapp.cc	TAPP̐ݒGUI\̃NX
  - qtxtapp.h qtxtapp.cc	xTAPP̐ݒGUI\̃NX
  - qttcpp.h qttcpp.cc	TC++̐ݒGUI\̃NXij
  - qtgraphics.h qtgraphics.cc	GL\GUI\̓NX
  - qtgllattice.h qtgllattice.cc	iqGL\GUI\̓NX
  - qtglfield.h qtglfield.cc	tB[hGL\GUI\̓NX
  - qtglperiodic.h qtglperiodic.cc	GL\GUI\̓NX
  - qtglmisc.h qtglmisc.cc	̑GL\GUI\̓NX
  - qtwidgets.h qtwidgets.cc	t@\GUIiNX
  - qtexception.h qtexception.cc	QTG[ΉNX
  - qtxml.h qtxml.cc	XMLf[^ǍNX
  - qtxpm.h	        XPMACRf[^
  - matrix.h matrix.cc	3x3sNX
  - position.h	3WNX
  - imatrix.h imatrix.cc	3x3s+3LxNgNX
  - fraction.h	LNX
  - vector2d.h	񎟌tB[hNX
  - vector3d.h	OtB[hNX
  - symbol.h	fLNX
*/

#include <QtGui/QApplication>
#include "window.h"
#include <unistd.h>

int main( int argc, char* argv[] )
{
  const QString curdir = QDir::currentPath();
  const QString bindir = getDirName(QDir::fromNativeSeparators(argv[0]));
  QDir::setCurrent( bindir );

  QApplication app(argc, argv);

  MainWindow window;
  window.show();

  QDir::setCurrent( curdir );

  for( int i=1; i<argc; i++ ){
    window.load(argv[i]);
  }

  return app.exec();
}
