/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file matrix.h
 \brief 3x3$B<B?t9TNs%/%i%9(B
*/

#ifndef __MATRIX_H_INCLUDED
#define __MATRIX_H_INCLUDED

#include "position.h"

class Matrix
{
public:
  double M[3][3];

  Matrix( void );
  Matrix( const Position M[3] );

  Matrix( const double Mxx, const double Mxy, const double Mxz,
	  const double Myx, const double Myy, const double Myz,
	  const double Mzx, const double Mzy, const double Mzz );

  inline double& operator () ( const int i, const int j ){
    return M[i][j];
  }
  inline const double& operator () ( const int i, const int j ) const {
    return M[i][j];
  }
  bool operator == ( const Matrix& that ) const;
  bool operator != ( const Matrix& that ) const;
  Matrix& operator += ( const Matrix& that );
  Matrix& operator *= ( const double d );
  Matrix operator * ( const Matrix& that ) const;
  Position operator * ( const Position& p ) const;

  Matrix getInverse( void ) const;

  static const Matrix& getIdentity( void );
  static const Matrix& getZero( void );
};

#endif // __MATRIX_H_INCLUDED
