/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "namelist.h"

NameListBuffer::NameListBuffer( const char* fname )
{
  fptr = fopen(fname,"r");
}

NameListBuffer::~NameListBuffer( void )
{
  fclose(fptr);
  fptr = NULL;
}


bool NameListBuffer::readList( const char* group, const char* group2 )
{
  char work[1024],word[128];
  char c;
  bool token=false;

  rewind(fptr);
  reset=true;

  this->group=group;

  bool found=false;
  if( group != NULL ){
    while( fscanf(fptr,"%s",word) != EOF ){
      if( !strcasecmp(word,group) ){
	found=true;
	break;
      }
    }
    if( !found && group2 == NULL ) return false;
  }
  
  if( !found && group2 != NULL ){
    rewind(fptr);
    while( fgets(work,sizeof(work),fptr) ){
      if( !strncasecmp(work,group2,strlen(group2)) ){
	found=true;
	buffer[0] = '\0';
	return true;
      }
    }
    buffer[0] = '\0';
    return false;
  }

  char* ptr = buffer;
  while( (c=fgetc(fptr)) != EOF ){
    if( c=='\'' ){ // NH[g̊JnEI
      fscanf(fptr,"%[^\']%*[\']",work);
      ptr += sprintf( ptr, "\'%s\'",work);
      token=true;
      continue;
    }

    if( c=='/' ){
      fgets(work,sizeof(work),fptr);
      ptr += sprintf(ptr,";");
      break;
    }

    if( c=='!' || c=='#' ){ // Rg̎n܂
      fgets(work,sizeof(work),fptr);
      continue;
    }

    if( !token && isalpha(c) ){ // ϐ̎n܂
      if( ptr != buffer ){
	ptr += sprintf(ptr,";");
      }
    }

    if( c==' ' || c==',' || c=='\r' || c=='\n' ){ // g[N̋؂
      if( token ){
	ptr += sprintf(ptr," ");
      }
      token=false;
    }
    else{
      token=true;
    }

    if( token ){
      ptr += sprintf(ptr,"%c", c);
    }
  }

  // 2*0.1Ȃǂ̑Ώ
  {
    char buffer2[1024*64];
    char* ptr = buffer;
    char* ptr2 = buffer2;
    char term[128], termb[128];
    int terma;
    int len;
    while( 1==sscanf(ptr,"%s%n",term,&len) ){
      ptr += len;
      if( 2 == sscanf( term, "%d*%s", &terma, termb ) ){
	for( int i=1; i<=terma; i++ ){
	  ptr2 += sprintf(ptr2,"%s ", termb);
	}
      }
      else{
	ptr2 += sprintf(ptr2,"%s ", term);
      }
    }
    strcpy(buffer,buffer2);
  }

  return true;
}

bool NameListBuffer::getVariable( char* name, char* value )
{
  static char* ptr;
  int len;
  //  char dummy[128];

  if( reset ){
    ptr = buffer;
    reset = false;
  }
  while(true){
    if( 2 == sscanf( ptr, "%[^= ]%*[= ]%[^;,]%*[;,]%n", name, value, &len ) ){
      ptr += len;
      //trim
      {
	char* p=value;
	for(;*p;p++);
	for(p--;*p==' ';p--) *p='\0';
      }

      //      fprintf( stderr, "[%s] : [%s] : [%s]\n", group, name, value );
      return true;
    }
    /*
    else if( 1 == sscanf( ptr, "%[^;];%n", dummy, &len ) ){
      ptr += len;
    }
    */
    else{
      return false;
    }
  }
}

bool NameListBuffer::readExtra( char* value )
{
  char word[128];

  while(true){
    if( fgets(value,1024,fptr) == NULL ) return false;

    if( 1 != sscanf(value,"%s",word) ) continue;
    if( word[0] =='#' || word[0] =='!' ) continue;
    break;
  }
  int i;
  for( i=0; value[i]; i++ ){
    if( value[i] =='#' || value[i] =='!' ||
	value[i] == '\r' || value[i] == '\n' ){
      value[i] = '\0';
      break;
    }
  }
  for( i--; i>=0; i-- ){
    if( value[i] != ' ' ) break;
    value[i] = '\0';
  }

  //  fprintf( stderr, "[%s] : [%s]\n", group, value );

  return true;
}

bool NameListBuffer::warpLine( const char* tag, char* arg )
{
  rewind(fptr);

  char buf[1024];
  char str[32];
  if( arg ){
    strcpy( arg, "" );
    while( fgets(buf,sizeof(buf),fptr) ) {
      if( 1 <= sscanf( buf, "%32s %32s", str, arg ) ){
	if( strcmp(str,tag) == 0 ) return true;
      }
    }
  }
  else{
    while( fgets(buf,sizeof(buf),fptr) ) {
      if( 1 == sscanf( buf, "%32s", str ) ){
	if( strcmp(str,tag) == 0 ) return true;
      }
    }
  }
  return false;
}
