/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file namelist.h
 \brief Fortran90l[Xg̃NX
*/

#ifndef __NAMELIST_H_INCLUDED
#define __NAMELIST_H_INCLUDED

#include <stdio.h>

class NameListBuffer
{
  static const int buffer_size = 1024*64;
  FILE* fptr;
  char buffer[buffer_size];
public:
  NameListBuffer( const char* fname );
  ~NameListBuffer( void );
  bool readList( const char* group, const char* group2=NULL );
  bool getVariable( char* name, char* value );
  bool readExtra( char* value );
  bool warpLine( const char* tag, char* arg=NULL );
  bool isValid( void ) const { return fptr != NULL; }
private:
  bool reset;
  const char* group;
};

#endif // __NAMELIST_H_INCLUDED
