/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtatoms.h
 \brief iq̌qzuGUI\̃NX
*/

#ifndef __QTTABLE_H_INCLUDED
#define __QTTABLE_H_INCLUDED

#include <QtGui/QtGui>
#include <QtGui/QTableWidget>

#include "qtwidgets.h"

class DTModel;

class QTAtoms : public QWidget
{
  Q_OBJECT

private:
  DTModel&    model;
  const int id;

  enum { ID_REMOVE, ID_ADD, ID_UNDO, ID_CLOSE, ID_BOND,
  ID_PS_INDEX, ID_PS_VALUE, ID_PS_ADD, ID_PS_DEL };

  QTableWidget* table;
  MyQSpinBoxGroup* spinbox_element;
  MyQLineEdit*     lineedit_bond_length;
  MyQLineEdit*     lineedit_bond_angle;
  MyQLineEdit*     lineedit_bond_dihedral;
  MyQLineEdit*     lineedit_element_name;
  MyQLineEdit*     lineedit_element_zo;
  MyQLineEdit*     lineedit_element_zn;
  MyQLineEdit*     lineedit_element_mass;

public:
  QTAtoms( DTModel& _model, const int id );

signals:
  void changed( void );

private slots:
  void edit( const MyEvent& ev );
public slots:
  void update( void );

private slots:
  void itemSelected( void );
  void itemEdited( QTableWidgetItem* );
};

#endif // __QTTABLE_H_INCLUDED
