/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtbrillouin.cc
 \brief uA][GUI\̃NX
*/

#include "dtmodel.h"
#include "qtmisc.h"
#include "qtbrillouin.h"
#include "glbrillouin.h"

QTBrillouin::QTBrillouin( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* layout = new QHBoxLayout(this);
  //  layout->setSizeConstraint( QLayout::SetFixedSize );

  {
    QGroupBox* group = new QGroupBox("brillouin zone");
    QVBoxLayout* box = new QVBoxLayout;

    {
      GLBrillouin* widget = new GLBrillouin(model);
      box->addWidget(widget);
    }

    group->setLayout(box);
    layout->addWidget(group);
  }

  {
    QGroupBox* group = new QGroupBox("symmetric points");
    QVBoxLayout* box = new QVBoxLayout;
    box->setSizeConstraint( QLayout::SetFixedSize );
    {
      // Label, kx, ky, kz, n
      table = new QTableWidget( 0, 6, this );
      table->setFixedWidth(320);
      table->setMinimumHeight(300);

      //      table->setSelectionMode( QAbstractItemView::ExtendedSelection );
      table->setSelectionBehavior( QAbstractItemView::SelectRows );

      connect(table,SIGNAL(itemChanged(QTableWidgetItem*)),this,SLOT(itemEdited(QTableWidgetItem*)) );
      connect(table,SIGNAL(itemSelectionChanged()),this,SLOT(itemSelected()) );

      int column=0;
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("point"));
      table->setColumnWidth(column++,40);
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("ka"));
      table->setColumnWidth(column++,50);
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("kb"));
      table->setColumnWidth(column++,50);
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("kc"));
      table->setColumnWidth(column++,50);
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("line"));
      table->setColumnWidth(column++,60);
      table->setHorizontalHeaderItem(column,new QTableWidgetItem("n"));
      table->setColumnWidth(column++,40);

      box->addWidget(table);
    }

    {
      MyQPushButton* widget = new MyQPushButton
	( "clear all pathes", this, SLOT(edit(const MyEvent&)), ID_CLEAR );
      box->addWidget( widget );
    }
    {
      MyQPushButton* widget = new MyQPushButton
	( "reset to default pathes", this, SLOT(edit(const MyEvent&)), ID_DEFAULT );
      box->addWidget( widget );
    }

    group->setLayout(box);
    layout->addWidget(group);
    layout->setAlignment(group,Qt::AlignTop);
  }

  setLayout(layout);

  update();
}


void QTBrillouin::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_CLEAR : {
    model.lattice.cell.clearKPathSelect();
  } break;
  case ID_DEFAULT : {
    model.lattice.cell.defaultKPathSelect();
  } break;
  default : break;
  }

  emit changed(MyEvent(id));
}

void QTBrillouin::update( void )
{
  char value[8];
  const vector_both<BrillouinSegment>& vsymmLselected = model.lattice.cell.vsymmLselected;

  table->blockSignals(true);

  table->clearContents();

  const int npoint = vsymmLselected.size()+1;
  if( npoint>1 ){
    table->setRowCount(npoint);
  }

  int row=0;
  for( int i=0; i<(int)vsymmLselected.size(); i++ ){
    const BrillouinSegment& symmL = vsymmLselected[i];

    int column=0;
    { // point
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg(symmL.labelPs) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // ka
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positions.a);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // kb
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positions.b);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // kc
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positions.c);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // line
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg(symmL.labelL) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // n
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg(symmL.npoint) );
      table->setItem(row,column++,item);
    }
    row++;
  }

  // the end point of the last segment
  if( !vsymmLselected.empty() ){
    const BrillouinSegment& symmL = vsymmLselected.back();

    int column=0;
    { // name
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg(symmL.labelPe) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // ka
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positione.a);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // kb
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positione.b);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // kc
      QTableWidgetItem* item = new QTableWidgetItem;
      sprintf(value,"%5.3f",symmL.positione.c);
      item->setText( tr("%1").arg(value) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // line
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg("") );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }
    { // n
      QTableWidgetItem* item = new QTableWidgetItem;
      item->setText( tr("%1").arg(0) );
      item->setFlags( Qt::NoItemFlags );
      table->setItem(row,column++,item);
    }

    row++;
  }
  table->blockSignals(false);
}


void QTBrillouin::itemSelected( void )
{
  //  const std::list<BrillouinSegment>& vsymmLselected = model.lattice.cell.vsymmLselected;
  const QList<QTableWidgetItem*> litem = table->selectedItems();

  if( litem.empty() ) return;

  /*
  int row = (int)litem.at(0)->row();
  model.lattice.selectAtoms(row);
  emit changed();
  */
}

void QTBrillouin::itemEdited( QTableWidgetItem* item_selected )
{
  vector_both<BrillouinSegment>& vsymmLselected = model.lattice.cell.vsymmLselected;
  const int row_selected = item_selected->row();

  if( row_selected<0 || (int)vsymmLselected.size()<=row_selected ) return;
  /*
  int row=0;
  std::list<BrillouinSegment>::iterator symmLptr;
  for( symmLptr=vsymmLselected.begin();
	symmLptr!=vsymmLselected.end(); symmLptr++ ){
    if( row == row_selected ){
      break;
    }
    row++;
  }
  */

  table->blockSignals(true);
  switch( item_selected->column() ){
  case 5 : { // n
    int n;
    if( 1 == sscanf( qPrintable(item_selected->text()), "%d", &n ) ){
      item_selected->setText( tr("%1").arg(n) );
      vsymmLselected[row_selected].npoint = n;
      emit changed(MyEvent(id));
    }
  } break;
  }
  table->blockSignals(false);
}
