/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtcell.cc
 \brief iq̒PʖEGUI\̃NX
*/

#include "dtmodel.h"
#include "qtcell.h"
#include "qtxpm.h"

QTCell::QTCell( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QHBoxLayout* layout = new QHBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  // cell shape
  {
    QGroupBox* group = new QGroupBox("cell shape");
    QVBoxLayout* box = new QVBoxLayout;

    {
      MyQRadioButton* widget = new MyQRadioButton
	( "cubic (A=B=C; a=b=c=90)",
	  model.lattice.cell.shape, DTCell::CUBIC,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::CUBIC::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "tetragonal (A,B=C; a=b=c=90)",
	  model.lattice.cell.shape, DTCell::TETRAGONAL_A,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::TETRAGONAL_A::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "tetragonal (B,C=A; a=b=c=90)",
	  model.lattice.cell.shape, DTCell::TETRAGONAL_B,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::TETRAGONAL_B::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "tetragonal (C,A=B; a=b=c=90)",
	  model.lattice.cell.shape, DTCell::TETRAGONAL_C,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::TETRAGONAL_C::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "orthorhombic (A,B,C; a=b=c=90)",
	  model.lattice.cell.shape, DTCell::ORTHORHOMBIC,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::ORTHORHOMBIC::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "monoclinic (A,B,C; a,b=c=90)",
	  model.lattice.cell.shape, DTCell::MONOCLINIC_A,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::MONOCLINIC_A::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "monoclinic (A,B,C; b,c=a=90)",
	  model.lattice.cell.shape, DTCell::MONOCLINIC_B,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::MONOCLINIC_B::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "monoclinic (A,B,C; c,a=b=90)",
	  model.lattice.cell.shape, DTCell::MONOCLINIC_C,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::MONOCLINIC_C::xpm));

      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "trigonal (A=B=C; a=b=c)",
	  model.lattice.cell.shape, DTCell::TRIGONAL,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::TRIGONAL::xpm));

      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "triclinic (A,B,C; a,b,c)",
	  model.lattice.cell.shape, DTCell::TRICLINIC,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::TRICLINIC::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "hexagonal (A,B=C; a=120,b=c=90)",
	  model.lattice.cell.shape, DTCell::HEXAGONAL_A,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::HEXAGONAL_A::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "hexagonal (B,C=A; b=120,c=a=90)",
	  model.lattice.cell.shape, DTCell::HEXAGONAL_B,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::HEXAGONAL_B::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "hexagonal (C,A=B; c=120,a=b=90)",
	  model.lattice.cell.shape, DTCell::HEXAGONAL_C,
	  this, SLOT(edit(const MyEvent&)), ID_SHAPE );
      widget->setIcon(QPixmap(CELL_SHAPE::HEXAGONAL_C::xpm));
      box->addWidget(widget);
      vwidget.push_back(widget);
    }

    group->setLayout(box);
    layout->addWidget(group);
  }

  QVBoxLayout* layout1 = new QVBoxLayout;

  // cell vectors
  {
    QGroupBox* group = new QGroupBox("unit length");
    group->setFixedHeight(80);
    QHBoxLayout* box = new QHBoxLayout;

    box->addWidget(new QLabel("length:"));

    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.length, DTCell::length_min, DTCell::length_max,
	 this, SLOT(edit(const MyEvent&)), ID_UNIT );
      box->addWidget(widget);

      vwidget.push_back(widget);
    }
    box->addWidget(new QLabel("angstrom"));

    group->setLayout(box);
    layout1->addWidget(group);
  }

  // cell vectors
  {
    QGroupBox* group = new QGroupBox("unit vectors");
    group->setFixedHeight(160);
    QGridLayout* box = new QGridLayout;

    int row=0;

    box->addWidget(new QLabel("x"),row,1);
    box->addWidget(new QLabel("y"),row,2);
    box->addWidget(new QLabel("z"),row,3);
    row++;

    box->addWidget(new QLabel("Ea:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ea.x, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,1);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ea.y, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,2);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ea.z, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,3);

      vwidget.push_back(widget);
    }
    row++;


    box->addWidget(new QLabel("Eb:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Eb.x, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,1);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Eb.y, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,2);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Eb.z, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,3);

      vwidget.push_back(widget);
    }
    row++;


    box->addWidget(new QLabel("Ec:"),row,0);
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ec.x, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,1);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ec.y, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,2);

      vwidget.push_back(widget);
    }
    {
      MyQLineEdit* widget = new MyQLineEdit
	(
	 model.lattice.cell.Ec.z, DTCell::E_min, DTCell::E_max,
	 this, SLOT(edit(const MyEvent&)), ID_VECTOR );
      widget->setFixedWidth(100);
      box->addWidget(widget,row,3);

      vwidget.push_back(widget);
    }
    row++;

    group->setLayout(box);
    layout1->addWidget(group);
  }

  // atom alignment
  {
    QGroupBox* group = new QGroupBox("atom alignment");
    QGridLayout* box = new QGridLayout;

    {
      MyQRadioButton* widget = new MyQRadioButton
	( "any",
	  model.lattice.getData().alignment, DTAtoms::ANY,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::ANY::xpm));
      box->addWidget(widget,0,0);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "simple",
	  model.lattice.getData().alignment, DTAtoms::SIMPLE,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::SIMPLE::xpm));
      box->addWidget(widget,1,0);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "face centered",
	  model.lattice.getData().alignment, DTAtoms::FACE_CENTERED,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::FACE_CENTERED::xpm));
      box->addWidget(widget,2,0);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "body centered",
	  model.lattice.getData().alignment, DTAtoms::BODY_CENTERED,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::BODY_CENTERED::xpm));
      box->addWidget(widget,0,1);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "base centered",
	  model.lattice.getData().alignment, DTAtoms::BASE_CENTERED,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::BASE_CENTERED::xpm));
      box->addWidget(widget,1,1);
      vwidget.push_back(widget);
    }
    {
      MyQRadioButton* widget = new MyQRadioButton
	( "diamond",
	  model.lattice.getData().alignment, DTAtoms::DIAMOND,
	  this, SLOT(edit(const MyEvent&)), ID_ALIGNMENT );
      widget->setIcon(QPixmap(ATOM_ALIGNMENT::DIAMOND::xpm));
      box->addWidget(widget,2,1);
      vwidget.push_back(widget);
    }

    group->setLayout(box);
    layout1->addWidget(group);
  }



  layout->addLayout(layout1);

  setLayout(layout);

  update( );
}


void QTCell::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_SHAPE : {
    model.lattice.cell.shape_changed = true;
  } break;
  case ID_UNIT : {
    model.lattice.cell.vectors_changed = true;
  } break;
  case ID_VECTOR : {
    model.lattice.cell.vectors_changed = true;
  } break;
  case ID_ALIGNMENT : {
    model.lattice.cell.alignment_changed = true;
  } break;
  default : break;
  }

  emit changed(MyEvent(id));
}

void QTCell::update( void )
{
  MyQTab::update();
}
