/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtcluster.cc
 \brief NX^GUI\̃NX
*/

#include "dtmodel.h"
#include "qtcluster.h"

QTCluster::QTCluster( DTModel& _model, const int id ) : MyQTab(id), model(_model)
{
  QVBoxLayout* layout = new QVBoxLayout(this);
  layout->setSizeConstraint( QLayout::SetFixedSize );

  //---- method
  {
    MyQGroupBox* widget = new MyQGroupBox("unit vector of cluster");
    QHBoxLayout* box = new QHBoxLayout;

    {
      MyQRadioButton* swidget = new MyQRadioButton
	( "none", model.lattice.cluster.method, 0,
	  this, SLOT(edit(const MyEvent&)), ID_CLUSTER_SIZE );
      box->addWidget(swidget,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    {
      MyQRadioButton* swidget = new MyQRadioButton
	( "XYZ", model.lattice.cluster.method, 1,
	  this, SLOT(edit(const MyEvent&)), ID_CLUSTER_SIZE );
      box->addWidget(swidget,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    {
      MyQRadioButton* swidget = new MyQRadioButton
	( "ABC", model.lattice.cluster.method, 2,
	  this, SLOT(edit(const MyEvent&)), ID_CLUSTER_SIZE );
      box->addWidget(swidget,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    widget->setLayout(box);
    layout->addWidget(widget);
  }

  //---- XYZ
  {
    QGroupBox* widget = new QGroupBox("XYZ");
    QGridLayout* box  = new QGridLayout;
    int row=0,col=0;

    box->addWidget(new QLabel("Ecluster_x:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.Ex, 1, 100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    row++,col=0;

    box->addWidget(new QLabel("Ecluster_y:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.Ey, 1, 100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    row++,col=0;

    box->addWidget(new QLabel("Ecluster_z:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.Ez, 1, 100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++,Qt::AlignLeft);
      vwidget.push_back(swidget);
    }
    row++,col=0;

    widget->setLayout(box);
    layout->addWidget(widget);

    group_xyz = widget;
  }

  //---- 
  {
    QGroupBox* widget = new QGroupBox("ABC");
    QGridLayout* box  = new QGridLayout;
    int row=0,col=0;

    col++;
    box->addWidget(new QLabel("Ea"),row,col++,Qt::AlignLeft);
    box->addWidget(new QLabel("Eb"),row,col++,Qt::AlignLeft);
    box->addWidget(new QLabel("Ec"),row,col++,Qt::AlignLeft);
    row++,col=0;

    box->addWidget(new QLabel("Ecluster_a:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[0][0], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[0][1], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[0][2], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    row++; col=0;

    box->addWidget(new QLabel("Ecluster_b:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[1][0], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[1][1], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[1][2], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    row++; col=0;

    box->addWidget(new QLabel("Ecluster_c:"),row,col++,Qt::AlignLeft);
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[2][0], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[2][1], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    {
      MyQSpinBox* swidget = new MyQSpinBox
	( model.lattice.cluster.M[2][2], -100, +100,
	 this, SLOT(edit(const MyEvent&)),  ID_CLUSTER_SIZE );
      box->addWidget(swidget,row,col++);
      vwidget.push_back(swidget);
    }
    row++; col=0;

    widget->setLayout(box);
    layout->addWidget(widget);

    group_abc = widget;
  }

  {
    QGroupBox* group = new QGroupBox;
    QVBoxLayout* box  = new QVBoxLayout;

    {
      MyQPushButton* widget = new MyQPushButton
	( "cancel clustering", this, SLOT(edit(const MyEvent&)), ID_CLUSTER_CANCEL );
      box->addWidget(widget);
      vwidget.push_back(widget);

      button_cancel = widget;
    }

    {
      MyQPushButton* widget = new MyQPushButton
	( "execute clustering", this, SLOT(edit(const MyEvent&)), ID_CLUSTER_EXEC );
      box->addWidget(widget);
      vwidget.push_back(widget);

      button_exec = widget;
    }

    group->setLayout(box);
    layout->addWidget(group);
  }

  setLayout(layout);
}


void QTCluster::edit( const MyEvent& ev )
{
  switch(ev.id){
  case ID_CLUSTER_METHOD : {
    if( model.lattice.cluster.method==0 ){
      model.lattice.cancel_clustering();
      emit changed(MyEvent(id));
    }
  } break;
  case ID_CLUSTER_SIZE : {
    model.lattice.clustering();
    emit changed(MyEvent(id));
  } break;
  case ID_CLUSTER_CANCEL : {
    model.lattice.cancel_clustering();
    emit changed(MyEvent(id));
  } break;
  case ID_CLUSTER_EXEC : {
    model.exec_clustering();

    emit changed(MyEvent(id));
  } break;
  }
}

void QTCluster::update( void )
{
  if( model.lattice.isclustering() ){
    button_cancel->setEnabled(true);
    button_exec->setEnabled(true);
  }
  else{
    button_cancel->setEnabled(false);
    button_exec->setEnabled(false);
  }

  if( model.lattice.cluster.method==0 ){
    group_xyz->setEnabled(false);
    group_abc->setEnabled(false);
  }
  if( model.lattice.cluster.method==1 ){
    group_xyz->setEnabled(true);
    group_abc->setEnabled(false);
  }
  if( model.lattice.cluster.method==2 ){
    group_xyz->setEnabled(false);
    group_abc->setEnabled(true);
  }

  MyQTab::update();
}
