/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtcluster.h
 \brief NX^GUI\̃NX
*/

#ifndef __QTCLUSTER_H_INCLUDED
#define __QTCLUSTER_H_INCLUDED

#include "qtwidgets.h"

class DTModel;

class QTCluster : public MyQTab
{
  Q_OBJECT

private:
  DTModel& model;

  enum { ID_CLUSTER_METHOD, ID_CLUSTER_SIZE, ID_CLUSTER_CANCEL, ID_CLUSTER_EXEC };

  QGroupBox* group_xyz;
  QGroupBox* group_abc;
  MyQPushButton* button_cancel;
  MyQPushButton* button_exec;

public:
  QTCluster( DTModel& _model, const int id );
public slots:
  void update( void );
private slots:
  void edit( const MyEvent& ev );
};

#endif // __QTCLUSTER_H_INCLUDED
