/*
 Copyright (c) 2014 Shinji Tsuneyuki
 This file is distributed under the terms of the GNU General Public License version 3.
 */

/*!
 \file qtctrl.cc
 \brief QTRg[̓NX
*/

#include "dtmodel.h"
#include "glview.h"
#include "qtlattice.h"
#include "qtatoms.h"
#include "qtxtapp.h"
#include "qtgraphics.h"
#include "qtctrl.h"

QTCtrl::QTCtrl( DTModel& _model, GLView& _view ) :
  model(_model), view(_view)
{
  lattice  = new QTLattice ( model, ID_LATTICE  );
  atoms    = new QTAtoms   ( model, ID_ATOMS    );
  xtapp    = new QTXTapp   ( model, ID_XTAPP    );
  graphics = new QTGraphics( model, ID_GRAPHICS );

  connect( &model,   SIGNAL(changed()),   this, SLOT(update()) );
  connect(   this,   SIGNAL(changed()), &model, SLOT(update()) );
  connect( lattice,  SIGNAL(changed()), &model, SLOT(update()) );
  connect( atoms,    SIGNAL(changed()), &model, SLOT(update()) );
  connect( xtapp,    SIGNAL(changed()), &model, SLOT(update()) );
  connect( graphics, SIGNAL(changed()),  &view, SLOT(update()) );
  connect( graphics, SIGNAL(changed()), graphics, SLOT(update()) );
}

void QTCtrl::showLattice( void )
{
  lattice->show();
  lattice->raise();
}

void QTCtrl::showAtoms( void )
{
  atoms->show();
  atoms->raise();
}

void QTCtrl::showXTapp( void )
{
  xtapp->show();
  xtapp->raise();
}

void QTCtrl::showGraphics( void )
{
  graphics->show();
  graphics->raise();
}


void QTCtrl::update( void )
{
  lattice->update();
  atoms->update();
  xtapp->update();
  graphics->update();
}

